/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.operationlog;

import com.google.common.collect.Queues;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import javax.annotation.PostConstruct;
import org.apache.inlong.manager.dao.entity.OperationLogEntity;
import org.apache.inlong.manager.dao.mapper.OperationLogEntityMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OperationLogPool {
    private static final Logger log = LoggerFactory.getLogger(OperationLogPool.class);
    private static final int TIMEOUT_SECOND = 30;
    private static final int THREAD_NUM = 3;
    private static final int BUFFER_SIZE = 500;
    private static final ArrayBlockingQueue<OperationLogEntity> OPERATION_POOL = new ArrayBlockingQueue(10000);
    private static final ExecutorService EXECUTOR_SERVICE = new ThreadPoolExecutor(3, 3, 100L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(10000), new ThreadFactoryBuilder().setNameFormat("inlong-operation-log-%s").build(), new ThreadPoolExecutor.CallerRunsPolicy());
    @Autowired
    private OperationLogEntityMapper operationLogMapper;

    public static void publish(OperationLogEntity operation) {
        if (!OPERATION_POOL.offer(operation)) {
            log.info("discard operation log: {}", (Object)operation);
        }
    }

    @PostConstruct
    public void init() {
        IntStream.range(0, 3).forEach(i -> EXECUTOR_SERVICE.submit(this::saveOperationLog));
    }

    private void saveOperationLog() {
        ArrayList buffer = new ArrayList(500);
        while (true) {
            buffer.clear();
            try {
                int size = Queues.drain(OPERATION_POOL, buffer, (int)500, (long)30L, (TimeUnit)TimeUnit.SECONDS);
                if (buffer.isEmpty()) continue;
                long startTime = System.currentTimeMillis();
                this.operationLogMapper.insertBatch(buffer);
                log.info("receive {} logs and saved cost {} ms", (Object)size, (Object)(System.currentTimeMillis() - startTime));
                continue;
            }
            catch (InterruptedException e) {
                log.error("save operation log interrupted", (Throwable)e);
            }
            catch (Exception e) {
                log.error("save operation log error: ", (Throwable)e);
                continue;
            }
            break;
        }
    }
}

