/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.node.kafka;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.pojo.sort.node.KafkaNodeConfig;
import org.apache.inlong.common.pojo.sort.node.NodeConfig;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.DataNodeEntity;
import org.apache.inlong.manager.pojo.cluster.kafka.KafkaClusterInfo;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.pojo.node.DataNodeRequest;
import org.apache.inlong.manager.pojo.node.kafka.KafkaDataNodeDTO;
import org.apache.inlong.manager.pojo.node.kafka.KafkaDataNodeInfo;
import org.apache.inlong.manager.pojo.node.kafka.KafkaDataNodeRequest;
import org.apache.inlong.manager.service.node.AbstractDataNodeOperator;
import org.apache.inlong.manager.service.resource.queue.kafka.KafkaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class KafkaDataNodeOperator
extends AbstractDataNodeOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaDataNodeOperator.class);
    private static final String bootstrapServers = "bootstrap.servers";
    private static final String clientId = "client.id";
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private RestTemplate restTemplate;

    @Override
    public Boolean accept(String dataNodeType) {
        return this.getDataNodeType().equals(dataNodeType);
    }

    @Override
    public String getDataNodeType() {
        return "KAFKA";
    }

    @Override
    public DataNodeInfo getFromEntity(DataNodeEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.DATA_NODE_NOT_FOUND);
        }
        KafkaDataNodeInfo kafkaDataNodeInfo = new KafkaDataNodeInfo();
        CommonBeanUtils.copyProperties((Object)entity, (Object)kafkaDataNodeInfo);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            KafkaDataNodeDTO dto = KafkaDataNodeDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)kafkaDataNodeInfo);
        }
        return kafkaDataNodeInfo;
    }

    @Override
    public Map<String, String> parse2SinkParams(DataNodeInfo info) {
        Map<String, String> params = super.parse2SinkParams(info);
        KafkaDataNodeInfo kafkaDataNodeInfo = (KafkaDataNodeInfo)info;
        params.put(bootstrapServers, kafkaDataNodeInfo.getBootstrapServers());
        params.put(clientId, kafkaDataNodeInfo.getClientId());
        return params;
    }

    @Override
    protected void setTargetEntity(DataNodeRequest request, DataNodeEntity targetEntity) {
        KafkaDataNodeRequest nodeRequest = (KafkaDataNodeRequest)request;
        CommonBeanUtils.copyProperties((Object)nodeRequest, (Object)targetEntity, (boolean)true);
        try {
            KafkaDataNodeDTO dto = KafkaDataNodeDTO.getFromRequest((KafkaDataNodeRequest)nodeRequest, (String)targetEntity.getExtParams());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.DATA_NODE_INFO_INCORRECT, String.format("Failed to build extParams for kafka node: %s", e.getMessage()));
        }
    }

    @Override
    public Boolean testConnection(DataNodeRequest request) {
        KafkaDataNodeRequest kafkaDataNodeRequest = (KafkaDataNodeRequest)request;
        String bootstrapServers = kafkaDataNodeRequest.getBootstrapServers();
        Preconditions.expectNotBlank((String)bootstrapServers, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"connection bootstrapServers  cannot be empty");
        if (this.getKafkaConnection(bootstrapServers)) {
            LOGGER.info("kafka connection success for bootstrapServers={}", (Object)bootstrapServers);
        }
        return true;
    }

    @Override
    public NodeConfig getNodeConfig(DataNodeEntity dataNodeEntity) {
        DataNodeInfo dataNodeInfo = this.getFromEntity(dataNodeEntity);
        KafkaNodeConfig kafkaNodeConfig = (KafkaNodeConfig)CommonBeanUtils.copyProperties((Object)dataNodeInfo, KafkaNodeConfig::new);
        kafkaNodeConfig.setNodeName(dataNodeInfo.getName());
        return kafkaNodeConfig;
    }

    private boolean getKafkaConnection(String bootstrapServers) {
        KafkaClusterInfo kafkaClusterInfo = KafkaClusterInfo.builder().bootstrapServers(bootstrapServers).build();
        try {
            KafkaUtils.getAdminClient(kafkaClusterInfo);
            return true;
        }
        catch (Exception e) {
            String errMsg = String.format("Kafka connection failed for bootstrapServers=%s", kafkaClusterInfo.getBootstrapServers());
            LOGGER.error(errMsg, (Throwable)e);
            throw new BusinessException(errMsg);
        }
    }
}

