/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.node.iceberg;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.DataNodeEntity;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.pojo.node.DataNodeRequest;
import org.apache.inlong.manager.pojo.node.iceberg.IcebergDataNodeDTO;
import org.apache.inlong.manager.pojo.node.iceberg.IcebergDataNodeInfo;
import org.apache.inlong.manager.pojo.node.iceberg.IcebergDataNodeRequest;
import org.apache.inlong.manager.service.node.AbstractDataNodeOperator;
import org.apache.inlong.manager.service.resource.sink.iceberg.IcebergCatalogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IcebergDataNodeOperator
extends AbstractDataNodeOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(IcebergDataNodeOperator.class);
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String dataNodeType) {
        return this.getDataNodeType().equals(dataNodeType);
    }

    @Override
    public String getDataNodeType() {
        return "ICEBERG";
    }

    @Override
    public DataNodeInfo getFromEntity(DataNodeEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.DATA_NODE_NOT_FOUND);
        }
        IcebergDataNodeInfo icebergDataNodeInfo = new IcebergDataNodeInfo();
        CommonBeanUtils.copyProperties((Object)entity, (Object)icebergDataNodeInfo);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            IcebergDataNodeDTO dto = IcebergDataNodeDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)icebergDataNodeInfo);
        }
        return icebergDataNodeInfo;
    }

    @Override
    protected void setTargetEntity(DataNodeRequest request, DataNodeEntity targetEntity) {
        IcebergDataNodeRequest nodeRequest = (IcebergDataNodeRequest)request;
        CommonBeanUtils.copyProperties((Object)nodeRequest, (Object)targetEntity, (boolean)true);
        try {
            IcebergDataNodeDTO dto = IcebergDataNodeDTO.getFromRequest((IcebergDataNodeRequest)nodeRequest, (String)targetEntity.getExtParams());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("Failed to build extParams for Iceberg node: %s", e.getMessage()));
        }
    }

    @Override
    public Boolean testConnection(DataNodeRequest request) {
        IcebergDataNodeRequest icebergDataNodeRequest = (IcebergDataNodeRequest)request;
        String metastoreUri = icebergDataNodeRequest.getUrl();
        String warehouse = icebergDataNodeRequest.getWarehouse();
        Preconditions.expectNotBlank((String)metastoreUri, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"connection url cannot be empty");
        try {
            HiveCatalog catalog = IcebergCatalogUtils.getCatalog(metastoreUri, warehouse);
            catalog.listNamespaces();
            LOGGER.info("iceberg connection not null - connection success for metastoreUri={}, warehouse={}", (Object)metastoreUri, (Object)warehouse);
            return true;
        }
        catch (Exception e) {
            String errMsg = String.format("iceberg connection failed for metastoreUri=%s, warehouse=%s", metastoreUri, warehouse);
            LOGGER.error(errMsg, (Throwable)e);
            throw new BusinessException(errMsg);
        }
    }
}

