/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.module;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.PackageConfigEntity;
import org.apache.inlong.manager.dao.mapper.PackageConfigEntityMapper;
import org.apache.inlong.manager.pojo.common.OrderFieldEnum;
import org.apache.inlong.manager.pojo.common.OrderTypeEnum;
import org.apache.inlong.manager.pojo.common.PageRequest;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.module.PackagePageRequest;
import org.apache.inlong.manager.pojo.module.PackageRequest;
import org.apache.inlong.manager.pojo.module.PackageResponse;
import org.apache.inlong.manager.pojo.user.UserInfo;
import org.apache.inlong.manager.service.module.PackageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PackageServiceImpl
implements PackageService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PackageServiceImpl.class);
    @Autowired
    private PackageConfigEntityMapper packageConfigEntityMapper;

    @Override
    public Integer save(PackageRequest request, String operator) {
        LOGGER.info("begin to save package info: {}", (Object)request);
        PackageConfigEntity packageConfigEntity = (PackageConfigEntity)CommonBeanUtils.copyProperties((Object)request, PackageConfigEntity::new);
        packageConfigEntity.setCreator(operator);
        packageConfigEntity.setModifier(operator);
        int id = this.packageConfigEntityMapper.insert(packageConfigEntity);
        LOGGER.info("success to save package info: {}", (Object)request);
        return id;
    }

    @Override
    public Boolean update(PackageRequest request, String operator) {
        LOGGER.info("begin to update package info: {}", (Object)request);
        PackageConfigEntity packageConfigEntity = this.packageConfigEntityMapper.selectByPrimaryKey(request.getId());
        if (packageConfigEntity == null) {
            throw new BusinessException(ErrorCodeEnum.PACKAGE_NOT_FOUND, String.format("Package does not exist with id=%s", request.getId()));
        }
        CommonBeanUtils.copyProperties((Object)request, (Object)packageConfigEntity, (boolean)true);
        packageConfigEntity.setModifier(operator);
        this.packageConfigEntityMapper.updateByIdSelective(packageConfigEntity);
        LOGGER.info("success to update package info: {}", (Object)request);
        return true;
    }

    @Override
    public PackageResponse get(Integer id, UserInfo opInfo) {
        LOGGER.info("begin to get package info for id = {}", (Object)id);
        PackageConfigEntity packageConfigEntity = this.packageConfigEntityMapper.selectByPrimaryKey(id);
        if (packageConfigEntity == null) {
            throw new BusinessException(ErrorCodeEnum.PACKAGE_NOT_FOUND, String.format("Package does not exist with id=%s", id));
        }
        LOGGER.info("success to get package info for id = {}", (Object)id);
        return (PackageResponse)CommonBeanUtils.copyProperties((Object)packageConfigEntity, PackageResponse::new);
    }

    @Override
    public PageResult<PackageResponse> listByCondition(PackagePageRequest request) {
        LOGGER.debug("begin to list package page, request = {}", (Object)request);
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        OrderFieldEnum.checkOrderField((PageRequest)request);
        OrderTypeEnum.checkOrderType((PageRequest)request);
        Page entityPage = (Page)this.packageConfigEntityMapper.selectByCondition(request);
        List packageResponseList = CommonBeanUtils.copyListProperties((List)entityPage, PackageResponse::new);
        PageResult pageResult = new PageResult(packageResponseList, Long.valueOf(entityPage.getTotal()), Integer.valueOf(entityPage.getPageNum()), Integer.valueOf(entityPage.getPageSize()));
        LOGGER.debug("success to list package page, result size {}", (Object)pageResult.getList().size());
        return pageResult;
    }

    @Override
    public Boolean delete(Integer id, String operator) {
        LOGGER.info("begin to delete packeage by id={}", (Object)id);
        Preconditions.expectNotNull((Object)id, (String)ErrorCodeEnum.ID_IS_EMPTY.getMessage());
        PackageConfigEntity entity = this.packageConfigEntityMapper.selectByPrimaryKey(id);
        Preconditions.expectNotNull((Object)entity, (String)ErrorCodeEnum.PACKAGE_NOT_FOUND.getMessage());
        entity.setModifier(operator);
        entity.setIsDeleted(entity.getId());
        this.packageConfigEntityMapper.updateByIdSelective(entity);
        LOGGER.info("success to delete package by id: {}", (Object)entity);
        return true;
    }
}

