/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.module;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.ModuleConfigEntity;
import org.apache.inlong.manager.dao.mapper.ModuleConfigEntityMapper;
import org.apache.inlong.manager.pojo.common.OrderFieldEnum;
import org.apache.inlong.manager.pojo.common.OrderTypeEnum;
import org.apache.inlong.manager.pojo.common.PageRequest;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.module.ModuleDTO;
import org.apache.inlong.manager.pojo.module.ModulePageRequest;
import org.apache.inlong.manager.pojo.module.ModuleRequest;
import org.apache.inlong.manager.pojo.module.ModuleResponse;
import org.apache.inlong.manager.pojo.user.UserInfo;
import org.apache.inlong.manager.service.module.ModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ModuleServiceImpl
implements ModuleService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleServiceImpl.class);
    @Autowired
    private ModuleConfigEntityMapper moduleConfigEntityMapper;
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Integer save(ModuleRequest request, String operator) {
        LOGGER.info("begin to save module info: {}", (Object)request);
        ModuleConfigEntity moduleConfigEntity = (ModuleConfigEntity)CommonBeanUtils.copyProperties((Object)request, ModuleConfigEntity::new);
        try {
            ModuleDTO dto = ModuleDTO.getFromRequest((ModuleRequest)request, (String)moduleConfigEntity.getExtParams(), (Integer)moduleConfigEntity.getPackageId());
            String extParams = this.objectMapper.writeValueAsString((Object)dto);
            moduleConfigEntity.setExtParams(extParams);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.MODULE_INFO_INCORRECT, String.format("serialize extParams of module failure: %s", e.getMessage()));
        }
        moduleConfigEntity.setCreator(operator);
        moduleConfigEntity.setModifier(operator);
        int id = this.moduleConfigEntityMapper.insert(moduleConfigEntity);
        LOGGER.info("success to save module info: {}", (Object)request);
        return id;
    }

    @Override
    public Boolean update(ModuleRequest request, String operator) {
        LOGGER.info("begin to update module info: {}", (Object)request);
        ModuleConfigEntity moduleConfigEntity = this.moduleConfigEntityMapper.selectByPrimaryKey(request.getId());
        if (moduleConfigEntity == null) {
            throw new BusinessException(ErrorCodeEnum.MODULE_NOT_FOUND, String.format("Module does not exist with id=%s", request.getId()));
        }
        CommonBeanUtils.copyProperties((Object)request, (Object)moduleConfigEntity, (boolean)true);
        try {
            ModuleDTO dto = ModuleDTO.getFromRequest((ModuleRequest)request, (String)moduleConfigEntity.getExtParams(), (Integer)moduleConfigEntity.getPackageId());
            String extParams = this.objectMapper.writeValueAsString((Object)dto);
            request.setExtParams(extParams);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.MODULE_INFO_INCORRECT, String.format("serialize extParams of module failure: %s", e.getMessage()));
        }
        CommonBeanUtils.copyProperties((Object)request, (Object)moduleConfigEntity, (boolean)true);
        moduleConfigEntity.setModifier(operator);
        this.moduleConfigEntityMapper.updateByIdSelective(moduleConfigEntity);
        LOGGER.info("success to update module info: {}", (Object)request);
        return true;
    }

    @Override
    public ModuleResponse get(Integer id, UserInfo opInfo) {
        LOGGER.info("begin to get module info for id = {}", (Object)id);
        ModuleConfigEntity entity = this.moduleConfigEntityMapper.selectByPrimaryKey(id);
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.MODULE_NOT_FOUND, String.format("Module config does not exist with id=%s", id));
        }
        ModuleResponse response = (ModuleResponse)CommonBeanUtils.copyProperties((Object)entity, ModuleResponse::new);
        CommonBeanUtils.copyProperties((Object)ModuleDTO.getFromJson((String)entity.getExtParams()), (Object)response, (boolean)true);
        LOGGER.info("begin to get module info for id = {}", (Object)id);
        return response;
    }

    @Override
    public PageResult<ModuleResponse> listByCondition(ModulePageRequest request) {
        LOGGER.debug("begin to list source page, request = {}", (Object)request);
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        OrderFieldEnum.checkOrderField((PageRequest)request);
        OrderTypeEnum.checkOrderType((PageRequest)request);
        Page entityPage = (Page)this.moduleConfigEntityMapper.selectByCondition(request);
        PageResult pageResult = PageResult.fromPage((Page)entityPage).map(entity -> {
            ModuleResponse response = (ModuleResponse)CommonBeanUtils.copyProperties((Object)entity, ModuleResponse::new);
            CommonBeanUtils.copyProperties((Object)ModuleDTO.getFromJson((String)entity.getExtParams()), (Object)response, (boolean)true);
            return response;
        });
        LOGGER.debug("success to list source page, result size {}", (Object)pageResult.getList().size());
        return pageResult;
    }

    @Override
    public Boolean delete(Integer id, String operator) {
        LOGGER.info("begin to delete module config by id={}", (Object)id);
        Preconditions.expectNotNull((Object)id, (String)ErrorCodeEnum.ID_IS_EMPTY.getMessage());
        ModuleConfigEntity entity = this.moduleConfigEntityMapper.selectByPrimaryKey(id);
        Preconditions.expectNotNull((Object)entity, (String)ErrorCodeEnum.MODULE_NOT_FOUND.getMessage());
        entity.setModifier(operator);
        entity.setIsDeleted(entity.getId());
        this.moduleConfigEntityMapper.updateByIdSelective(entity);
        LOGGER.info("success to delete module config by id: {}", (Object)entity);
        return true;
    }
}

