/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.service.channel;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.audit.service.entities.StatData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataQueue.class);
    private final LinkedBlockingQueue<StatData> queue;

    public DataQueue(int capacity) {
        this.queue = new LinkedBlockingQueue(capacity);
    }

    public void push(StatData statDataPo) throws InterruptedException {
        this.queue.put(statDataPo);
    }

    public StatData pull(long timeout, TimeUnit unit) throws InterruptedException {
        return (StatData)this.queue.poll(timeout, unit);
    }

    public void destroy() {
        if (this.queue != null) {
            this.queue.clear();
        }
        LOGGER.info("destroy channel!");
    }
}

