/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.multipleinput.input;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.table.runtime.operators.multipleinput.TableOperatorWrapper;
import org.apache.flink.util.Preconditions;

public class InputSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int multipleInputId;
    private final int readOrder;
    private final TableOperatorWrapper<?> output;
    private final int outputOpInputId;

    public InputSpec(int multipleInputId, int readOrder, TableOperatorWrapper<?> output, int outputOpInputId) {
        this.multipleInputId = multipleInputId;
        this.readOrder = readOrder;
        this.output = (TableOperatorWrapper)Preconditions.checkNotNull(output);
        this.outputOpInputId = outputOpInputId;
    }

    public int getMultipleInputId() {
        return this.multipleInputId;
    }

    public int getReadOrder() {
        return this.readOrder;
    }

    public TableOperatorWrapper<?> getOutput() {
        return this.output;
    }

    public int getOutputOpInputId() {
        return this.outputOpInputId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputSpec inputSpec = (InputSpec)o;
        return this.multipleInputId == inputSpec.multipleInputId && this.readOrder == inputSpec.readOrder && this.outputOpInputId == inputSpec.outputOpInputId && this.output.equals(inputSpec.output);
    }

    public int hashCode() {
        return Objects.hash(this.multipleInputId, this.readOrder, this.output, this.outputOpInputId);
    }

    public String toString() {
        return "InputSpec{multipleInputId=" + this.multipleInputId + ", readOrder=" + this.readOrder + ", output=" + this.output + ", outputOpInputId=" + this.outputOpInputId + '}';
    }
}

