/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.conversion;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.conversion.ArrayObjectArrayConverter;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.table.types.DataType;

@Internal
public class ArrayListConverter<E>
implements DataStructureConverter<ArrayData, List<E>> {
    private static final long serialVersionUID = 1L;
    private final E[] arrayKind;
    private final ArrayObjectArrayConverter<E> elementsConverter;

    private ArrayListConverter(E[] arrayKind, ArrayObjectArrayConverter<E> elementsConverter) {
        this.arrayKind = arrayKind;
        this.elementsConverter = elementsConverter;
    }

    @Override
    public void open(ClassLoader classLoader) {
        this.elementsConverter.open(classLoader);
    }

    @Override
    public ArrayData toInternal(List<E> external) {
        return this.elementsConverter.toInternal(external.toArray(this.arrayKind));
    }

    @Override
    public List<E> toExternal(ArrayData internal) {
        return new ArrayList<E>(Arrays.asList(this.elementsConverter.toExternal(internal)));
    }

    public static ArrayListConverter<?> create(DataType dataType) {
        DataType elementDataType = (DataType)dataType.getChildren().get(0);
        return new ArrayListConverter<Object>(ArrayListConverter.createObjectArrayKind(elementDataType.getConversionClass()), ArrayObjectArrayConverter.createForElement(elementDataType));
    }

    private static Object[] createObjectArrayKind(Class<?> elementClazz) {
        if (elementClazz.isPrimitive()) {
            return (Object[])Array.newInstance(ClassUtils.primitiveToWrapper(elementClazz), 0);
        }
        return (Object[])Array.newInstance(elementClazz, 0);
    }
}

