/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.manager.service.tube;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.tubemq.manager.controller.node.request.AddTopicReq;

public class TubeHttpTopicInfoList {
    private boolean result;
    private String errMsg;
    private int errCode;
    private List<TopicInfoList> data;

    public List<Integer> getTopicBrokerIdList() {
        ArrayList<Integer> tmpBrokerIdList = new ArrayList<Integer>();
        if (this.data != null) {
            for (TopicInfoList topicInfoList : this.data) {
                if (topicInfoList.getTopicInfo() == null) continue;
                for (TopicInfoList.TopicInfo topicInfo : topicInfoList.getTopicInfo()) {
                    tmpBrokerIdList.add(topicInfo.getBrokerId());
                }
            }
        }
        return tmpBrokerIdList;
    }

    public List<TopicInfoList.TopicInfo> getTopicInfo() {
        if (CollectionUtils.isEmpty(this.data)) {
            return Lists.newArrayList();
        }
        return this.data.get(0).getTopicInfo();
    }

    public AddTopicReq getAddTopicReq(List<Integer> brokerIds, List<String> targetTopicNames, String token) {
        AddTopicReq req = new AddTopicReq();
        TopicInfoList topicInfoList = this.data.get(0);
        if (topicInfoList == null) {
            return req;
        }
        List<TopicInfoList.TopicInfo> topicInfos = topicInfoList.getTopicInfo();
        if (CollectionUtils.isEmpty(topicInfos)) {
            return req;
        }
        TopicInfoList.TopicInfo topicInfo = topicInfos.get(0);
        String brokerStr = StringUtils.join(brokerIds, (String)",");
        String topic = StringUtils.join(targetTopicNames, (String)",");
        this.setAttributes(token, req, topicInfo, brokerStr, topic);
        return req;
    }

    private void setAttributes(String token, AddTopicReq req, TopicInfoList.TopicInfo topicInfo, String brokerStr, String topic) {
        req.setBrokerId(brokerStr);
        req.setTopicName(topic);
        req.setMethod("admin_add_new_topic_record");
        req.setAcceptPublish(topicInfo.acceptPublish);
        req.setAcceptSubscribe(topicInfo.acceptSubscribe);
        req.setType("op_modify");
        req.setCreateUser("webapi");
        req.setDeleteWhen(topicInfo.getDeleteWhen());
        req.setNumPartitions(topicInfo.getNumPartitions());
        req.setUnflushInterval(topicInfo.getUnflushInterval());
        req.setConfModAuthToken(token);
        req.setDeletePolicy(topicInfo.getDeletePolicy());
    }

    public boolean isResult() {
        return this.result;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public int getErrCode() {
        return this.errCode;
    }

    public List<TopicInfoList> getData() {
        return this.data;
    }

    public void setResult(boolean result) {
        this.result = result;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public void setErrCode(int errCode) {
        this.errCode = errCode;
    }

    public void setData(List<TopicInfoList> data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TubeHttpTopicInfoList)) {
            return false;
        }
        TubeHttpTopicInfoList other = (TubeHttpTopicInfoList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isResult() != other.isResult()) {
            return false;
        }
        if (this.getErrCode() != other.getErrCode()) {
            return false;
        }
        String this$errMsg = this.getErrMsg();
        String other$errMsg = other.getErrMsg();
        if (this$errMsg == null ? other$errMsg != null : !this$errMsg.equals(other$errMsg)) {
            return false;
        }
        List<TopicInfoList> this$data = this.getData();
        List<TopicInfoList> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TubeHttpTopicInfoList;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isResult() ? 79 : 97);
        result = result * 59 + this.getErrCode();
        String $errMsg = this.getErrMsg();
        result = result * 59 + ($errMsg == null ? 43 : $errMsg.hashCode());
        List<TopicInfoList> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "TubeHttpTopicInfoList(result=" + this.isResult() + ", errMsg=" + this.getErrMsg() + ", errCode=" + this.getErrCode() + ", data=" + this.getData() + ")";
    }

    public static class TopicInfoList {
        private String topicName;
        private List<TopicInfo> topicInfo;

        public String getTopicName() {
            return this.topicName;
        }

        public List<TopicInfo> getTopicInfo() {
            return this.topicInfo;
        }

        public void setTopicName(String topicName) {
            this.topicName = topicName;
        }

        public void setTopicInfo(List<TopicInfo> topicInfo) {
            this.topicInfo = topicInfo;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TopicInfoList)) {
                return false;
            }
            TopicInfoList other = (TopicInfoList)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$topicName = this.getTopicName();
            String other$topicName = other.getTopicName();
            if (this$topicName == null ? other$topicName != null : !this$topicName.equals(other$topicName)) {
                return false;
            }
            List<TopicInfo> this$topicInfo = this.getTopicInfo();
            List<TopicInfo> other$topicInfo = other.getTopicInfo();
            return !(this$topicInfo == null ? other$topicInfo != null : !((Object)this$topicInfo).equals(other$topicInfo));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TopicInfoList;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $topicName = this.getTopicName();
            result = result * 59 + ($topicName == null ? 43 : $topicName.hashCode());
            List<TopicInfo> $topicInfo = this.getTopicInfo();
            result = result * 59 + ($topicInfo == null ? 43 : ((Object)$topicInfo).hashCode());
            return result;
        }

        public String toString() {
            return "TubeHttpTopicInfoList.TopicInfoList(topicName=" + this.getTopicName() + ", topicInfo=" + this.getTopicInfo() + ")";
        }

        public static class TopicInfo {
            private String topicName;
            private int topicStatusId;
            private int brokerId;
            private String brokerIp;
            private int brokerPort;
            private int numPartitions;
            private int unflushThreshold;
            private int unflushInterval;
            private int unFlushDataHold;
            private String deleteWhen;
            private String deletePolicy;
            private boolean acceptPublish;
            private boolean acceptSubscribe;
            private int numTopicStores;
            private int memCacheMsgSizeInMB;
            private int memCacheFlushIntvl;
            private int memCacheMsgCntInK;
            private String createUser;
            private String createDate;
            private String modifyUser;
            private String modifyDate;
            private RunInfo runInfo;

            public String getTopicName() {
                return this.topicName;
            }

            public int getTopicStatusId() {
                return this.topicStatusId;
            }

            public int getBrokerId() {
                return this.brokerId;
            }

            public String getBrokerIp() {
                return this.brokerIp;
            }

            public int getBrokerPort() {
                return this.brokerPort;
            }

            public int getNumPartitions() {
                return this.numPartitions;
            }

            public int getUnflushThreshold() {
                return this.unflushThreshold;
            }

            public int getUnflushInterval() {
                return this.unflushInterval;
            }

            public int getUnFlushDataHold() {
                return this.unFlushDataHold;
            }

            public String getDeleteWhen() {
                return this.deleteWhen;
            }

            public String getDeletePolicy() {
                return this.deletePolicy;
            }

            public boolean isAcceptPublish() {
                return this.acceptPublish;
            }

            public boolean isAcceptSubscribe() {
                return this.acceptSubscribe;
            }

            public int getNumTopicStores() {
                return this.numTopicStores;
            }

            public int getMemCacheMsgSizeInMB() {
                return this.memCacheMsgSizeInMB;
            }

            public int getMemCacheFlushIntvl() {
                return this.memCacheFlushIntvl;
            }

            public int getMemCacheMsgCntInK() {
                return this.memCacheMsgCntInK;
            }

            public String getCreateUser() {
                return this.createUser;
            }

            public String getCreateDate() {
                return this.createDate;
            }

            public String getModifyUser() {
                return this.modifyUser;
            }

            public String getModifyDate() {
                return this.modifyDate;
            }

            public RunInfo getRunInfo() {
                return this.runInfo;
            }

            public void setTopicName(String topicName) {
                this.topicName = topicName;
            }

            public void setTopicStatusId(int topicStatusId) {
                this.topicStatusId = topicStatusId;
            }

            public void setBrokerId(int brokerId) {
                this.brokerId = brokerId;
            }

            public void setBrokerIp(String brokerIp) {
                this.brokerIp = brokerIp;
            }

            public void setBrokerPort(int brokerPort) {
                this.brokerPort = brokerPort;
            }

            public void setNumPartitions(int numPartitions) {
                this.numPartitions = numPartitions;
            }

            public void setUnflushThreshold(int unflushThreshold) {
                this.unflushThreshold = unflushThreshold;
            }

            public void setUnflushInterval(int unflushInterval) {
                this.unflushInterval = unflushInterval;
            }

            public void setUnFlushDataHold(int unFlushDataHold) {
                this.unFlushDataHold = unFlushDataHold;
            }

            public void setDeleteWhen(String deleteWhen) {
                this.deleteWhen = deleteWhen;
            }

            public void setDeletePolicy(String deletePolicy) {
                this.deletePolicy = deletePolicy;
            }

            public void setAcceptPublish(boolean acceptPublish) {
                this.acceptPublish = acceptPublish;
            }

            public void setAcceptSubscribe(boolean acceptSubscribe) {
                this.acceptSubscribe = acceptSubscribe;
            }

            public void setNumTopicStores(int numTopicStores) {
                this.numTopicStores = numTopicStores;
            }

            public void setMemCacheMsgSizeInMB(int memCacheMsgSizeInMB) {
                this.memCacheMsgSizeInMB = memCacheMsgSizeInMB;
            }

            public void setMemCacheFlushIntvl(int memCacheFlushIntvl) {
                this.memCacheFlushIntvl = memCacheFlushIntvl;
            }

            public void setMemCacheMsgCntInK(int memCacheMsgCntInK) {
                this.memCacheMsgCntInK = memCacheMsgCntInK;
            }

            public void setCreateUser(String createUser) {
                this.createUser = createUser;
            }

            public void setCreateDate(String createDate) {
                this.createDate = createDate;
            }

            public void setModifyUser(String modifyUser) {
                this.modifyUser = modifyUser;
            }

            public void setModifyDate(String modifyDate) {
                this.modifyDate = modifyDate;
            }

            public void setRunInfo(RunInfo runInfo) {
                this.runInfo = runInfo;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TopicInfo)) {
                    return false;
                }
                TopicInfo other = (TopicInfo)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.getTopicStatusId() != other.getTopicStatusId()) {
                    return false;
                }
                if (this.getBrokerId() != other.getBrokerId()) {
                    return false;
                }
                if (this.getBrokerPort() != other.getBrokerPort()) {
                    return false;
                }
                if (this.getNumPartitions() != other.getNumPartitions()) {
                    return false;
                }
                if (this.getUnflushThreshold() != other.getUnflushThreshold()) {
                    return false;
                }
                if (this.getUnflushInterval() != other.getUnflushInterval()) {
                    return false;
                }
                if (this.getUnFlushDataHold() != other.getUnFlushDataHold()) {
                    return false;
                }
                if (this.isAcceptPublish() != other.isAcceptPublish()) {
                    return false;
                }
                if (this.isAcceptSubscribe() != other.isAcceptSubscribe()) {
                    return false;
                }
                if (this.getNumTopicStores() != other.getNumTopicStores()) {
                    return false;
                }
                if (this.getMemCacheMsgSizeInMB() != other.getMemCacheMsgSizeInMB()) {
                    return false;
                }
                if (this.getMemCacheFlushIntvl() != other.getMemCacheFlushIntvl()) {
                    return false;
                }
                if (this.getMemCacheMsgCntInK() != other.getMemCacheMsgCntInK()) {
                    return false;
                }
                String this$topicName = this.getTopicName();
                String other$topicName = other.getTopicName();
                if (this$topicName == null ? other$topicName != null : !this$topicName.equals(other$topicName)) {
                    return false;
                }
                String this$brokerIp = this.getBrokerIp();
                String other$brokerIp = other.getBrokerIp();
                if (this$brokerIp == null ? other$brokerIp != null : !this$brokerIp.equals(other$brokerIp)) {
                    return false;
                }
                String this$deleteWhen = this.getDeleteWhen();
                String other$deleteWhen = other.getDeleteWhen();
                if (this$deleteWhen == null ? other$deleteWhen != null : !this$deleteWhen.equals(other$deleteWhen)) {
                    return false;
                }
                String this$deletePolicy = this.getDeletePolicy();
                String other$deletePolicy = other.getDeletePolicy();
                if (this$deletePolicy == null ? other$deletePolicy != null : !this$deletePolicy.equals(other$deletePolicy)) {
                    return false;
                }
                String this$createUser = this.getCreateUser();
                String other$createUser = other.getCreateUser();
                if (this$createUser == null ? other$createUser != null : !this$createUser.equals(other$createUser)) {
                    return false;
                }
                String this$createDate = this.getCreateDate();
                String other$createDate = other.getCreateDate();
                if (this$createDate == null ? other$createDate != null : !this$createDate.equals(other$createDate)) {
                    return false;
                }
                String this$modifyUser = this.getModifyUser();
                String other$modifyUser = other.getModifyUser();
                if (this$modifyUser == null ? other$modifyUser != null : !this$modifyUser.equals(other$modifyUser)) {
                    return false;
                }
                String this$modifyDate = this.getModifyDate();
                String other$modifyDate = other.getModifyDate();
                if (this$modifyDate == null ? other$modifyDate != null : !this$modifyDate.equals(other$modifyDate)) {
                    return false;
                }
                RunInfo this$runInfo = this.getRunInfo();
                RunInfo other$runInfo = other.getRunInfo();
                return !(this$runInfo == null ? other$runInfo != null : !((Object)this$runInfo).equals(other$runInfo));
            }

            protected boolean canEqual(Object other) {
                return other instanceof TopicInfo;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.getTopicStatusId();
                result = result * 59 + this.getBrokerId();
                result = result * 59 + this.getBrokerPort();
                result = result * 59 + this.getNumPartitions();
                result = result * 59 + this.getUnflushThreshold();
                result = result * 59 + this.getUnflushInterval();
                result = result * 59 + this.getUnFlushDataHold();
                result = result * 59 + (this.isAcceptPublish() ? 79 : 97);
                result = result * 59 + (this.isAcceptSubscribe() ? 79 : 97);
                result = result * 59 + this.getNumTopicStores();
                result = result * 59 + this.getMemCacheMsgSizeInMB();
                result = result * 59 + this.getMemCacheFlushIntvl();
                result = result * 59 + this.getMemCacheMsgCntInK();
                String $topicName = this.getTopicName();
                result = result * 59 + ($topicName == null ? 43 : $topicName.hashCode());
                String $brokerIp = this.getBrokerIp();
                result = result * 59 + ($brokerIp == null ? 43 : $brokerIp.hashCode());
                String $deleteWhen = this.getDeleteWhen();
                result = result * 59 + ($deleteWhen == null ? 43 : $deleteWhen.hashCode());
                String $deletePolicy = this.getDeletePolicy();
                result = result * 59 + ($deletePolicy == null ? 43 : $deletePolicy.hashCode());
                String $createUser = this.getCreateUser();
                result = result * 59 + ($createUser == null ? 43 : $createUser.hashCode());
                String $createDate = this.getCreateDate();
                result = result * 59 + ($createDate == null ? 43 : $createDate.hashCode());
                String $modifyUser = this.getModifyUser();
                result = result * 59 + ($modifyUser == null ? 43 : $modifyUser.hashCode());
                String $modifyDate = this.getModifyDate();
                result = result * 59 + ($modifyDate == null ? 43 : $modifyDate.hashCode());
                RunInfo $runInfo = this.getRunInfo();
                result = result * 59 + ($runInfo == null ? 43 : ((Object)$runInfo).hashCode());
                return result;
            }

            public String toString() {
                return "TubeHttpTopicInfoList.TopicInfoList.TopicInfo(topicName=" + this.getTopicName() + ", topicStatusId=" + this.getTopicStatusId() + ", brokerId=" + this.getBrokerId() + ", brokerIp=" + this.getBrokerIp() + ", brokerPort=" + this.getBrokerPort() + ", numPartitions=" + this.getNumPartitions() + ", unflushThreshold=" + this.getUnflushThreshold() + ", unflushInterval=" + this.getUnflushInterval() + ", unFlushDataHold=" + this.getUnFlushDataHold() + ", deleteWhen=" + this.getDeleteWhen() + ", deletePolicy=" + this.getDeletePolicy() + ", acceptPublish=" + this.isAcceptPublish() + ", acceptSubscribe=" + this.isAcceptSubscribe() + ", numTopicStores=" + this.getNumTopicStores() + ", memCacheMsgSizeInMB=" + this.getMemCacheMsgSizeInMB() + ", memCacheFlushIntvl=" + this.getMemCacheFlushIntvl() + ", memCacheMsgCntInK=" + this.getMemCacheMsgCntInK() + ", createUser=" + this.getCreateUser() + ", createDate=" + this.getCreateDate() + ", modifyUser=" + this.getModifyUser() + ", modifyDate=" + this.getModifyDate() + ", runInfo=" + this.getRunInfo() + ")";
            }

            public static class RunInfo {
                private String acceptPublish;
                private String acceptSubscribe;
                private String numPartitions;
                private String numTopicStores;
                private String brokerManageStatus;

                public String getAcceptPublish() {
                    return this.acceptPublish;
                }

                public String getAcceptSubscribe() {
                    return this.acceptSubscribe;
                }

                public String getNumPartitions() {
                    return this.numPartitions;
                }

                public String getNumTopicStores() {
                    return this.numTopicStores;
                }

                public String getBrokerManageStatus() {
                    return this.brokerManageStatus;
                }

                public void setAcceptPublish(String acceptPublish) {
                    this.acceptPublish = acceptPublish;
                }

                public void setAcceptSubscribe(String acceptSubscribe) {
                    this.acceptSubscribe = acceptSubscribe;
                }

                public void setNumPartitions(String numPartitions) {
                    this.numPartitions = numPartitions;
                }

                public void setNumTopicStores(String numTopicStores) {
                    this.numTopicStores = numTopicStores;
                }

                public void setBrokerManageStatus(String brokerManageStatus) {
                    this.brokerManageStatus = brokerManageStatus;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof RunInfo)) {
                        return false;
                    }
                    RunInfo other = (RunInfo)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$acceptPublish = this.getAcceptPublish();
                    String other$acceptPublish = other.getAcceptPublish();
                    if (this$acceptPublish == null ? other$acceptPublish != null : !this$acceptPublish.equals(other$acceptPublish)) {
                        return false;
                    }
                    String this$acceptSubscribe = this.getAcceptSubscribe();
                    String other$acceptSubscribe = other.getAcceptSubscribe();
                    if (this$acceptSubscribe == null ? other$acceptSubscribe != null : !this$acceptSubscribe.equals(other$acceptSubscribe)) {
                        return false;
                    }
                    String this$numPartitions = this.getNumPartitions();
                    String other$numPartitions = other.getNumPartitions();
                    if (this$numPartitions == null ? other$numPartitions != null : !this$numPartitions.equals(other$numPartitions)) {
                        return false;
                    }
                    String this$numTopicStores = this.getNumTopicStores();
                    String other$numTopicStores = other.getNumTopicStores();
                    if (this$numTopicStores == null ? other$numTopicStores != null : !this$numTopicStores.equals(other$numTopicStores)) {
                        return false;
                    }
                    String this$brokerManageStatus = this.getBrokerManageStatus();
                    String other$brokerManageStatus = other.getBrokerManageStatus();
                    return !(this$brokerManageStatus == null ? other$brokerManageStatus != null : !this$brokerManageStatus.equals(other$brokerManageStatus));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof RunInfo;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $acceptPublish = this.getAcceptPublish();
                    result = result * 59 + ($acceptPublish == null ? 43 : $acceptPublish.hashCode());
                    String $acceptSubscribe = this.getAcceptSubscribe();
                    result = result * 59 + ($acceptSubscribe == null ? 43 : $acceptSubscribe.hashCode());
                    String $numPartitions = this.getNumPartitions();
                    result = result * 59 + ($numPartitions == null ? 43 : $numPartitions.hashCode());
                    String $numTopicStores = this.getNumTopicStores();
                    result = result * 59 + ($numTopicStores == null ? 43 : $numTopicStores.hashCode());
                    String $brokerManageStatus = this.getBrokerManageStatus();
                    result = result * 59 + ($brokerManageStatus == null ? 43 : $brokerManageStatus.hashCode());
                    return result;
                }

                public String toString() {
                    return "TubeHttpTopicInfoList.TopicInfoList.TopicInfo.RunInfo(acceptPublish=" + this.getAcceptPublish() + ", acceptSubscribe=" + this.getAcceptSubscribe() + ", numPartitions=" + this.getNumPartitions() + ", numTopicStores=" + this.getNumTopicStores() + ", brokerManageStatus=" + this.getBrokerManageStatus() + ")";
                }
            }
        }
    }
}

