/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.internals.AdminApiLookupStrategy;
import org.apache.kafka.clients.admin.internals.ApiRequestScope;
import org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.InvalidGroupIdException;
import org.apache.kafka.common.errors.TransactionalIdAuthorizationException;
import org.apache.kafka.common.message.FindCoordinatorRequestData;
import org.apache.kafka.common.message.FindCoordinatorResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class CoordinatorStrategy
implements AdminApiLookupStrategy<CoordinatorKey> {
    private static final ApiRequestScope BATCH_REQUEST_SCOPE = new ApiRequestScope(){};
    private final Logger log;
    private final FindCoordinatorRequest.CoordinatorType type;
    private Set<CoordinatorKey> unrepresentableKeys = Collections.emptySet();
    boolean batch = true;

    public CoordinatorStrategy(FindCoordinatorRequest.CoordinatorType type, LogContext logContext) {
        this.type = type;
        this.log = logContext.logger(CoordinatorStrategy.class);
    }

    @Override
    public ApiRequestScope lookupScope(CoordinatorKey key) {
        if (this.batch) {
            return BATCH_REQUEST_SCOPE;
        }
        return new LookupRequestScope(key);
    }

    public FindCoordinatorRequest.Builder buildRequest(Set<CoordinatorKey> keys) {
        this.unrepresentableKeys = keys.stream().filter(k -> k == null || !CoordinatorStrategy.isRepresentableKey(k.idValue)).collect(Collectors.toSet());
        Set<CoordinatorKey> representableKeys = keys.stream().filter(k -> k != null && CoordinatorStrategy.isRepresentableKey(k.idValue)).collect(Collectors.toSet());
        if (this.batch) {
            this.ensureSameType(representableKeys);
            FindCoordinatorRequestData data = new FindCoordinatorRequestData().setKeyType(this.type.id()).setCoordinatorKeys(representableKeys.stream().map(k -> k.idValue).collect(Collectors.toList()));
            return new FindCoordinatorRequest.Builder(data);
        }
        CoordinatorKey key = this.requireSingletonAndType(representableKeys);
        return new FindCoordinatorRequest.Builder(new FindCoordinatorRequestData().setKey(key.idValue).setKeyType(key.type.id()));
    }

    @Override
    public AdminApiLookupStrategy.LookupResult<CoordinatorKey> handleResponse(Set<CoordinatorKey> keys, AbstractResponse abstractResponse) {
        HashMap<CoordinatorKey, Integer> mappedKeys = new HashMap<CoordinatorKey, Integer>();
        HashMap<CoordinatorKey, Throwable> failedKeys = new HashMap<CoordinatorKey, Throwable>();
        for (CoordinatorKey key : this.unrepresentableKeys) {
            failedKeys.put(key, new InvalidGroupIdException("The given group id '" + key.idValue + "' cannot be represented in a request."));
        }
        for (FindCoordinatorResponseData.Coordinator coordinator : ((FindCoordinatorResponse)abstractResponse).coordinators()) {
            CoordinatorKey key = coordinator.key() == null ? this.requireSingletonAndType(keys) : (this.type == FindCoordinatorRequest.CoordinatorType.GROUP ? CoordinatorKey.byGroupId(coordinator.key()) : CoordinatorKey.byTransactionalId(coordinator.key()));
            this.handleError(Errors.forCode(coordinator.errorCode()), key, coordinator.nodeId(), mappedKeys, failedKeys);
        }
        return new AdminApiLookupStrategy.LookupResult<CoordinatorKey>(failedKeys, mappedKeys);
    }

    public void disableBatch() {
        this.batch = false;
    }

    private CoordinatorKey requireSingletonAndType(Set<CoordinatorKey> keys) {
        if (keys.size() != 1) {
            throw new IllegalArgumentException("Unexpected size of key set: expected 1, but got " + keys.size());
        }
        CoordinatorKey key = keys.iterator().next();
        if (key.type != this.type) {
            throw new IllegalArgumentException("Unexpected key type: expected key to be of type " + (Object)((Object)this.type) + ", but got " + (Object)((Object)key.type));
        }
        return key;
    }

    private void ensureSameType(Set<CoordinatorKey> keys) {
        if (keys.size() < 1) {
            throw new IllegalArgumentException("Unexpected size of key set: expected >= 1, but got " + keys.size());
        }
        if (keys.stream().filter(k -> k.type == this.type).collect(Collectors.toSet()).size() != keys.size()) {
            throw new IllegalArgumentException("Unexpected key set: expected all key to be of type " + (Object)((Object)this.type) + ", but some key were not");
        }
    }

    private static boolean isRepresentableKey(String groupId) {
        return groupId != null;
    }

    private void handleError(Errors error, CoordinatorKey key, int nodeId, Map<CoordinatorKey, Integer> mappedKeys, Map<CoordinatorKey, Throwable> failedKeys) {
        switch (error) {
            case NONE: {
                mappedKeys.put(key, nodeId);
                break;
            }
            case COORDINATOR_NOT_AVAILABLE: 
            case COORDINATOR_LOAD_IN_PROGRESS: {
                this.log.debug("FindCoordinator request for key {} returned topic-level error {}. Will retry", (Object)key, (Object)error);
                break;
            }
            case GROUP_AUTHORIZATION_FAILED: {
                failedKeys.put(key, new GroupAuthorizationException("FindCoordinator request for groupId `" + key + "` failed due to authorization failure", key.idValue));
                break;
            }
            case TRANSACTIONAL_ID_AUTHORIZATION_FAILED: {
                failedKeys.put(key, new TransactionalIdAuthorizationException("FindCoordinator request for transactionalId `" + key + "` failed due to authorization failure"));
                break;
            }
            default: {
                failedKeys.put(key, error.exception("FindCoordinator request for key `" + key + "` failed due to an unexpected error"));
            }
        }
    }

    private static class LookupRequestScope
    implements ApiRequestScope {
        final CoordinatorKey key;

        private LookupRequestScope(CoordinatorKey key) {
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LookupRequestScope that = (LookupRequestScope)o;
            return Objects.equals(this.key, that.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }
    }
}

