/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ccr;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.ccr.FollowConfig;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ContextParser;
import org.elasticsearch.common.xcontent.XContentParser;

public final class FollowInfoResponse {
    static final ParseField FOLLOWER_INDICES_FIELD = new ParseField("follower_indices", new String[0]);
    private static final ConstructingObjectParser<FollowInfoResponse, Void> PARSER = new ConstructingObjectParser("indices", true, args -> {
        List infos = (List)args[0];
        return new FollowInfoResponse(infos);
    });
    private final List<FollowerInfo> infos;

    public static FollowInfoResponse fromXContent(XContentParser parser) {
        return (FollowInfoResponse)PARSER.apply(parser, null);
    }

    FollowInfoResponse(List<FollowerInfo> infos) {
        this.infos = infos;
    }

    public List<FollowerInfo> getInfos() {
        return this.infos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FollowInfoResponse that = (FollowInfoResponse)o;
        return this.infos.equals(that.infos);
    }

    public int hashCode() {
        return Objects.hash(this.infos);
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (ContextParser)FollowerInfo.PARSER, FOLLOWER_INDICES_FIELD);
    }

    public static enum Status {
        ACTIVE("active"),
        PAUSED("paused");

        private final String name;

        private Status(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Status fromString(String value) {
            switch (value) {
                case "active": {
                    return ACTIVE;
                }
                case "paused": {
                    return PAUSED;
                }
            }
            throw new IllegalArgumentException("unexpected status value [" + value + "]");
        }
    }

    public static final class FollowerInfo {
        static final ParseField FOLLOWER_INDEX_FIELD = new ParseField("follower_index", new String[0]);
        static final ParseField REMOTE_CLUSTER_FIELD = new ParseField("remote_cluster", new String[0]);
        static final ParseField LEADER_INDEX_FIELD = new ParseField("leader_index", new String[0]);
        static final ParseField STATUS_FIELD = new ParseField("status", new String[0]);
        static final ParseField PARAMETERS_FIELD = new ParseField("parameters", new String[0]);
        private static final ConstructingObjectParser<FollowerInfo, Void> PARSER = new ConstructingObjectParser("follower_info", true, args -> new FollowerInfo((String)args[0], (String)args[1], (String)args[2], Status.fromString((String)args[3]), (FollowConfig)args[4]));
        private final String followerIndex;
        private final String remoteCluster;
        private final String leaderIndex;
        private final Status status;
        private final FollowConfig parameters;

        FollowerInfo(String followerIndex, String remoteCluster, String leaderIndex, Status status, FollowConfig parameters) {
            this.followerIndex = followerIndex;
            this.remoteCluster = remoteCluster;
            this.leaderIndex = leaderIndex;
            this.status = status;
            this.parameters = parameters;
        }

        public String getFollowerIndex() {
            return this.followerIndex;
        }

        public String getRemoteCluster() {
            return this.remoteCluster;
        }

        public String getLeaderIndex() {
            return this.leaderIndex;
        }

        public Status getStatus() {
            return this.status;
        }

        public FollowConfig getParameters() {
            return this.parameters;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FollowerInfo that = (FollowerInfo)o;
            return Objects.equals(this.followerIndex, that.followerIndex) && Objects.equals(this.remoteCluster, that.remoteCluster) && Objects.equals(this.leaderIndex, that.leaderIndex) && this.status == that.status && Objects.equals(this.parameters, that.parameters);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.followerIndex, this.remoteCluster, this.leaderIndex, this.status, this.parameters});
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), FOLLOWER_INDEX_FIELD);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), REMOTE_CLUSTER_FIELD);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), LEADER_INDEX_FIELD);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), STATUS_FIELD);
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> FollowConfig.fromXContent(p), PARAMETERS_FIELD);
        }
    }
}

