/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.elasticsearch.action.admin.cluster.storedscripts.DeleteStoredScriptRequest;
import org.elasticsearch.action.admin.cluster.storedscripts.GetStoredScriptRequest;
import org.elasticsearch.action.admin.cluster.storedscripts.GetStoredScriptResponse;
import org.elasticsearch.action.admin.cluster.storedscripts.PutStoredScriptRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.explain.ExplainRequest;
import org.elasticsearch.action.explain.ExplainResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.main.MainRequest;
import org.elasticsearch.action.main.MainResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.CcrClient;
import org.elasticsearch.client.ClusterClient;
import org.elasticsearch.client.GraphClient;
import org.elasticsearch.client.IndexLifecycleClient;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.IngestClient;
import org.elasticsearch.client.LicenseClient;
import org.elasticsearch.client.MachineLearningClient;
import org.elasticsearch.client.MigrationClient;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestConverters;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RethrottleRequest;
import org.elasticsearch.client.RollupClient;
import org.elasticsearch.client.SecurityClient;
import org.elasticsearch.client.SnapshotClient;
import org.elasticsearch.client.TasksClient;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.ValidationException;
import org.elasticsearch.client.WatcherClient;
import org.elasticsearch.client.XPackClient;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.elasticsearch.client.core.MultiTermVectorsRequest;
import org.elasticsearch.client.core.MultiTermVectorsResponse;
import org.elasticsearch.client.core.TermVectorsRequest;
import org.elasticsearch.client.core.TermVectorsResponse;
import org.elasticsearch.client.tasks.TaskSubmissionResponse;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ContextParser;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.rankeval.RankEvalRequest;
import org.elasticsearch.index.rankeval.RankEvalResponse;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.plugins.spi.NamedXContentProvider;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.mustache.MultiSearchTemplateRequest;
import org.elasticsearch.script.mustache.MultiSearchTemplateResponse;
import org.elasticsearch.script.mustache.SearchTemplateRequest;
import org.elasticsearch.script.mustache.SearchTemplateResponse;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.bucket.adjacency.ParsedAdjacencyMatrix;
import org.elasticsearch.search.aggregations.bucket.composite.ParsedComposite;
import org.elasticsearch.search.aggregations.bucket.filter.ParsedFilter;
import org.elasticsearch.search.aggregations.bucket.filter.ParsedFilters;
import org.elasticsearch.search.aggregations.bucket.geogrid.ParsedGeoHashGrid;
import org.elasticsearch.search.aggregations.bucket.global.ParsedGlobal;
import org.elasticsearch.search.aggregations.bucket.histogram.ParsedAutoDateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.ParsedDateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.ParsedHistogram;
import org.elasticsearch.search.aggregations.bucket.missing.ParsedMissing;
import org.elasticsearch.search.aggregations.bucket.nested.ParsedNested;
import org.elasticsearch.search.aggregations.bucket.nested.ParsedReverseNested;
import org.elasticsearch.search.aggregations.bucket.range.ParsedBinaryRange;
import org.elasticsearch.search.aggregations.bucket.range.ParsedDateRange;
import org.elasticsearch.search.aggregations.bucket.range.ParsedGeoDistance;
import org.elasticsearch.search.aggregations.bucket.range.ParsedRange;
import org.elasticsearch.search.aggregations.bucket.sampler.ParsedSampler;
import org.elasticsearch.search.aggregations.bucket.significant.ParsedSignificantLongTerms;
import org.elasticsearch.search.aggregations.bucket.significant.ParsedSignificantStringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedDoubleTerms;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedLongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedStringTerms;
import org.elasticsearch.search.aggregations.metrics.avg.ParsedAvg;
import org.elasticsearch.search.aggregations.metrics.cardinality.ParsedCardinality;
import org.elasticsearch.search.aggregations.metrics.geobounds.ParsedGeoBounds;
import org.elasticsearch.search.aggregations.metrics.geocentroid.ParsedGeoCentroid;
import org.elasticsearch.search.aggregations.metrics.mad.ParsedMedianAbsoluteDeviation;
import org.elasticsearch.search.aggregations.metrics.max.ParsedMax;
import org.elasticsearch.search.aggregations.metrics.min.ParsedMin;
import org.elasticsearch.search.aggregations.metrics.percentiles.hdr.ParsedHDRPercentileRanks;
import org.elasticsearch.search.aggregations.metrics.percentiles.hdr.ParsedHDRPercentiles;
import org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.ParsedTDigestPercentileRanks;
import org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.ParsedTDigestPercentiles;
import org.elasticsearch.search.aggregations.metrics.scripted.ParsedScriptedMetric;
import org.elasticsearch.search.aggregations.metrics.stats.ParsedStats;
import org.elasticsearch.search.aggregations.metrics.stats.extended.ParsedExtendedStats;
import org.elasticsearch.search.aggregations.metrics.sum.ParsedSum;
import org.elasticsearch.search.aggregations.metrics.tophits.ParsedTopHits;
import org.elasticsearch.search.aggregations.metrics.valuecount.ParsedValueCount;
import org.elasticsearch.search.aggregations.metrics.weighted_avg.ParsedWeightedAvg;
import org.elasticsearch.search.aggregations.pipeline.ParsedSimpleValue;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.ParsedBucketMetricValue;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.percentile.ParsedPercentilesBucket;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.stats.ParsedStatsBucket;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.stats.extended.ParsedExtendedStatsBucket;
import org.elasticsearch.search.aggregations.pipeline.derivative.ParsedDerivative;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.completion.CompletionSuggestion;
import org.elasticsearch.search.suggest.phrase.PhraseSuggestion;
import org.elasticsearch.search.suggest.term.TermSuggestion;

public class RestHighLevelClient
implements Closeable {
    private final RestClient client;
    private final NamedXContentRegistry registry;
    private final CheckedConsumer<RestClient, IOException> doClose;
    private final IndicesClient indicesClient = new IndicesClient(this);
    private final ClusterClient clusterClient = new ClusterClient(this);
    private final IngestClient ingestClient = new IngestClient(this);
    private final SnapshotClient snapshotClient = new SnapshotClient(this);
    private final TasksClient tasksClient = new TasksClient(this);
    private final XPackClient xPackClient = new XPackClient(this);
    private final WatcherClient watcherClient = new WatcherClient(this);
    private final GraphClient graphClient = new GraphClient(this);
    private final LicenseClient licenseClient = new LicenseClient(this);
    private final IndexLifecycleClient indexLifecycleClient = new IndexLifecycleClient(this);
    private final MigrationClient migrationClient = new MigrationClient(this);
    private final MachineLearningClient machineLearningClient = new MachineLearningClient(this);
    private final SecurityClient securityClient = new SecurityClient(this);
    private final RollupClient rollupClient = new RollupClient(this);
    private final CcrClient ccrClient = new CcrClient(this);
    private static final DeprecationHandler DEPRECATION_HANDLER = new DeprecationHandler(){

        public void usedDeprecatedName(String usedName, String modernName) {
        }

        public void usedDeprecatedField(String usedName, String replacedWith) {
        }

        public void deprecated(String message, Object ... params) {
        }
    };

    public RestHighLevelClient(RestClientBuilder restClientBuilder) {
        this(restClientBuilder, Collections.emptyList());
    }

    protected RestHighLevelClient(RestClientBuilder restClientBuilder, List<NamedXContentRegistry.Entry> namedXContentEntries) {
        this(restClientBuilder.build(), (CheckedConsumer<RestClient, IOException>)((CheckedConsumer)RestClient::close), namedXContentEntries);
    }

    protected RestHighLevelClient(RestClient restClient, CheckedConsumer<RestClient, IOException> doClose, List<NamedXContentRegistry.Entry> namedXContentEntries) {
        this.client = Objects.requireNonNull(restClient, "restClient must not be null");
        this.doClose = Objects.requireNonNull(doClose, "doClose consumer must not be null");
        this.registry = new NamedXContentRegistry(Stream.of(RestHighLevelClient.getDefaultNamedXContents().stream(), RestHighLevelClient.getProvidedNamedXContents().stream(), namedXContentEntries.stream()).flatMap(Function.identity()).collect(Collectors.toList()));
    }

    public final RestClient getLowLevelClient() {
        return this.client;
    }

    @Override
    public final void close() throws IOException {
        this.doClose.accept((Object)this.client);
    }

    public final IndicesClient indices() {
        return this.indicesClient;
    }

    public final ClusterClient cluster() {
        return this.clusterClient;
    }

    public final IngestClient ingest() {
        return this.ingestClient;
    }

    public final SnapshotClient snapshot() {
        return this.snapshotClient;
    }

    public RollupClient rollup() {
        return this.rollupClient;
    }

    public final CcrClient ccr() {
        return this.ccrClient;
    }

    public final TasksClient tasks() {
        return this.tasksClient;
    }

    public final XPackClient xpack() {
        return this.xPackClient;
    }

    public WatcherClient watcher() {
        return this.watcherClient;
    }

    public GraphClient graph() {
        return this.graphClient;
    }

    public LicenseClient license() {
        return this.licenseClient;
    }

    public IndexLifecycleClient indexLifecycle() {
        return this.indexLifecycleClient;
    }

    public MigrationClient migration() {
        return this.migrationClient;
    }

    public MachineLearningClient machineLearning() {
        return this.machineLearningClient;
    }

    public SecurityClient security() {
        return this.securityClient;
    }

    public final BulkResponse bulk(BulkRequest bulkRequest, RequestOptions options) throws IOException {
        return (BulkResponse)this.performRequestAndParseEntity(bulkRequest, RequestConverters::bulk, options, BulkResponse::fromXContent, Collections.emptySet());
    }

    @Deprecated
    public final BulkResponse bulk(BulkRequest bulkRequest, Header ... headers) throws IOException {
        return (BulkResponse)this.performRequestAndParseEntity(bulkRequest, RequestConverters::bulk, BulkResponse::fromXContent, Collections.emptySet(), headers);
    }

    public final void bulkAsync(BulkRequest bulkRequest, RequestOptions options, ActionListener<BulkResponse> listener) {
        this.performRequestAsyncAndParseEntity(bulkRequest, RequestConverters::bulk, options, BulkResponse::fromXContent, listener, Collections.emptySet());
    }

    @Deprecated
    public final void bulkAsync(BulkRequest bulkRequest, ActionListener<BulkResponse> listener, Header ... headers) {
        this.performRequestAsyncAndParseEntity(bulkRequest, RequestConverters::bulk, BulkResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public final BulkByScrollResponse reindex(ReindexRequest reindexRequest, RequestOptions options) throws IOException {
        return (BulkByScrollResponse)this.performRequestAndParseEntity(reindexRequest, RequestConverters::reindex, options, BulkByScrollResponse::fromXContent, Collections.emptySet());
    }

    public final TaskSubmissionResponse submitReindexTask(ReindexRequest reindexRequest, RequestOptions options) throws IOException {
        return (TaskSubmissionResponse)((Object)this.performRequestAndParseEntity(reindexRequest, RequestConverters::submitReindex, options, TaskSubmissionResponse::fromXContent, Collections.emptySet()));
    }

    public final void reindexAsync(ReindexRequest reindexRequest, RequestOptions options, ActionListener<BulkByScrollResponse> listener) {
        this.performRequestAsyncAndParseEntity(reindexRequest, RequestConverters::reindex, options, BulkByScrollResponse::fromXContent, listener, Collections.emptySet());
    }

    public final BulkByScrollResponse updateByQuery(UpdateByQueryRequest updateByQueryRequest, RequestOptions options) throws IOException {
        return (BulkByScrollResponse)this.performRequestAndParseEntity(updateByQueryRequest, RequestConverters::updateByQuery, options, BulkByScrollResponse::fromXContent, Collections.emptySet());
    }

    public final void updateByQueryAsync(UpdateByQueryRequest updateByQueryRequest, RequestOptions options, ActionListener<BulkByScrollResponse> listener) {
        this.performRequestAsyncAndParseEntity(updateByQueryRequest, RequestConverters::updateByQuery, options, BulkByScrollResponse::fromXContent, listener, Collections.emptySet());
    }

    public final BulkByScrollResponse deleteByQuery(DeleteByQueryRequest deleteByQueryRequest, RequestOptions options) throws IOException {
        return (BulkByScrollResponse)this.performRequestAndParseEntity(deleteByQueryRequest, RequestConverters::deleteByQuery, options, BulkByScrollResponse::fromXContent, Collections.emptySet());
    }

    public final void deleteByQueryAsync(DeleteByQueryRequest deleteByQueryRequest, RequestOptions options, ActionListener<BulkByScrollResponse> listener) {
        this.performRequestAsyncAndParseEntity(deleteByQueryRequest, RequestConverters::deleteByQuery, options, BulkByScrollResponse::fromXContent, listener, Collections.emptySet());
    }

    public final ListTasksResponse deleteByQueryRethrottle(RethrottleRequest rethrottleRequest, RequestOptions options) throws IOException {
        return (ListTasksResponse)this.performRequestAndParseEntity(rethrottleRequest, RequestConverters::rethrottleDeleteByQuery, options, ListTasksResponse::fromXContent, Collections.emptySet());
    }

    public final void deleteByQueryRethrottleAsync(RethrottleRequest rethrottleRequest, RequestOptions options, ActionListener<ListTasksResponse> listener) {
        this.performRequestAsyncAndParseEntity(rethrottleRequest, RequestConverters::rethrottleDeleteByQuery, options, ListTasksResponse::fromXContent, listener, Collections.emptySet());
    }

    public final ListTasksResponse updateByQueryRethrottle(RethrottleRequest rethrottleRequest, RequestOptions options) throws IOException {
        return (ListTasksResponse)this.performRequestAndParseEntity(rethrottleRequest, RequestConverters::rethrottleUpdateByQuery, options, ListTasksResponse::fromXContent, Collections.emptySet());
    }

    public final void updateByQueryRethrottleAsync(RethrottleRequest rethrottleRequest, RequestOptions options, ActionListener<ListTasksResponse> listener) {
        this.performRequestAsyncAndParseEntity(rethrottleRequest, RequestConverters::rethrottleUpdateByQuery, options, ListTasksResponse::fromXContent, listener, Collections.emptySet());
    }

    public final ListTasksResponse reindexRethrottle(RethrottleRequest rethrottleRequest, RequestOptions options) throws IOException {
        return (ListTasksResponse)this.performRequestAndParseEntity(rethrottleRequest, RequestConverters::rethrottleReindex, options, ListTasksResponse::fromXContent, Collections.emptySet());
    }

    public final void reindexRethrottleAsync(RethrottleRequest rethrottleRequest, RequestOptions options, ActionListener<ListTasksResponse> listener) {
        this.performRequestAsyncAndParseEntity(rethrottleRequest, RequestConverters::rethrottleReindex, options, ListTasksResponse::fromXContent, listener, Collections.emptySet());
    }

    public final boolean ping(RequestOptions options) throws IOException {
        return (Boolean)this.performRequest(new MainRequest(), request -> RequestConverters.ping(), options, RestHighLevelClient::convertExistsResponse, Collections.emptySet());
    }

    @Deprecated
    public final boolean ping(Header ... headers) throws IOException {
        return (Boolean)this.performRequest(new MainRequest(), request -> RequestConverters.ping(), RestHighLevelClient::convertExistsResponse, Collections.emptySet(), headers);
    }

    public final MainResponse info(RequestOptions options) throws IOException {
        return (MainResponse)this.performRequestAndParseEntity(new MainRequest(), request -> RequestConverters.info(), options, MainResponse::fromXContent, Collections.emptySet());
    }

    @Deprecated
    public final MainResponse info(Header ... headers) throws IOException {
        return (MainResponse)this.performRequestAndParseEntity(new MainRequest(), request -> RequestConverters.info(), MainResponse::fromXContent, Collections.emptySet(), headers);
    }

    public final GetResponse get(GetRequest getRequest, RequestOptions options) throws IOException {
        return (GetResponse)this.performRequestAndParseEntity(getRequest, RequestConverters::get, options, GetResponse::fromXContent, Collections.singleton(404));
    }

    @Deprecated
    public final GetResponse get(GetRequest getRequest, Header ... headers) throws IOException {
        return (GetResponse)this.performRequestAndParseEntity(getRequest, RequestConverters::get, GetResponse::fromXContent, Collections.singleton(404), headers);
    }

    public final void getAsync(GetRequest getRequest, RequestOptions options, ActionListener<GetResponse> listener) {
        this.performRequestAsyncAndParseEntity(getRequest, RequestConverters::get, options, GetResponse::fromXContent, listener, Collections.singleton(404));
    }

    @Deprecated
    public final void getAsync(GetRequest getRequest, ActionListener<GetResponse> listener, Header ... headers) {
        this.performRequestAsyncAndParseEntity(getRequest, RequestConverters::get, GetResponse::fromXContent, listener, Collections.singleton(404), headers);
    }

    @Deprecated
    public final MultiGetResponse multiGet(MultiGetRequest multiGetRequest, RequestOptions options) throws IOException {
        return this.mget(multiGetRequest, options);
    }

    public final MultiGetResponse mget(MultiGetRequest multiGetRequest, RequestOptions options) throws IOException {
        return (MultiGetResponse)this.performRequestAndParseEntity(multiGetRequest, RequestConverters::multiGet, options, MultiGetResponse::fromXContent, Collections.singleton(404));
    }

    @Deprecated
    public final MultiGetResponse multiGet(MultiGetRequest multiGetRequest, Header ... headers) throws IOException {
        return (MultiGetResponse)this.performRequestAndParseEntity(multiGetRequest, RequestConverters::multiGet, MultiGetResponse::fromXContent, Collections.singleton(404), headers);
    }

    @Deprecated
    public final void multiGetAsync(MultiGetRequest multiGetRequest, RequestOptions options, ActionListener<MultiGetResponse> listener) {
        this.mgetAsync(multiGetRequest, options, listener);
    }

    public final void mgetAsync(MultiGetRequest multiGetRequest, RequestOptions options, ActionListener<MultiGetResponse> listener) {
        this.performRequestAsyncAndParseEntity(multiGetRequest, RequestConverters::multiGet, options, MultiGetResponse::fromXContent, listener, Collections.singleton(404));
    }

    @Deprecated
    public final void multiGetAsync(MultiGetRequest multiGetRequest, ActionListener<MultiGetResponse> listener, Header ... headers) {
        this.performRequestAsyncAndParseEntity(multiGetRequest, RequestConverters::multiGet, MultiGetResponse::fromXContent, listener, Collections.singleton(404), headers);
    }

    public final boolean exists(GetRequest getRequest, RequestOptions options) throws IOException {
        return (Boolean)this.performRequest(getRequest, RequestConverters::exists, options, RestHighLevelClient::convertExistsResponse, Collections.emptySet());
    }

    @Deprecated
    public final boolean exists(GetRequest getRequest, Header ... headers) throws IOException {
        return (Boolean)this.performRequest(getRequest, RequestConverters::exists, RestHighLevelClient::convertExistsResponse, Collections.emptySet(), headers);
    }

    public final void existsAsync(GetRequest getRequest, RequestOptions options, ActionListener<Boolean> listener) {
        this.performRequestAsync(getRequest, RequestConverters::exists, options, RestHighLevelClient::convertExistsResponse, listener, Collections.emptySet());
    }

    @Deprecated
    public final void existsAsync(GetRequest getRequest, ActionListener<Boolean> listener, Header ... headers) {
        this.performRequestAsync(getRequest, RequestConverters::exists, RestHighLevelClient::convertExistsResponse, listener, Collections.emptySet(), headers);
    }

    public boolean existsSource(GetRequest getRequest, RequestOptions options) throws IOException {
        return (Boolean)this.performRequest(getRequest, RequestConverters::sourceExists, options, RestHighLevelClient::convertExistsResponse, Collections.emptySet());
    }

    public final void existsSourceAsync(GetRequest getRequest, RequestOptions options, ActionListener<Boolean> listener) {
        this.performRequestAsync(getRequest, RequestConverters::sourceExists, options, RestHighLevelClient::convertExistsResponse, listener, Collections.emptySet());
    }

    public final IndexResponse index(IndexRequest indexRequest, RequestOptions options) throws IOException {
        return (IndexResponse)this.performRequestAndParseEntity(indexRequest, RequestConverters::index, options, IndexResponse::fromXContent, Collections.emptySet());
    }

    @Deprecated
    public final IndexResponse index(IndexRequest indexRequest, Header ... headers) throws IOException {
        return (IndexResponse)this.performRequestAndParseEntity(indexRequest, RequestConverters::index, IndexResponse::fromXContent, Collections.emptySet(), headers);
    }

    public final void indexAsync(IndexRequest indexRequest, RequestOptions options, ActionListener<IndexResponse> listener) {
        this.performRequestAsyncAndParseEntity(indexRequest, RequestConverters::index, options, IndexResponse::fromXContent, listener, Collections.emptySet());
    }

    @Deprecated
    public final void indexAsync(IndexRequest indexRequest, ActionListener<IndexResponse> listener, Header ... headers) {
        this.performRequestAsyncAndParseEntity(indexRequest, RequestConverters::index, IndexResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public final CountResponse count(CountRequest countRequest, RequestOptions options) throws IOException {
        return (CountResponse)((Object)this.performRequestAndParseEntity(countRequest, RequestConverters::count, options, CountResponse::fromXContent, Collections.emptySet()));
    }

    public final void countAsync(CountRequest countRequest, RequestOptions options, ActionListener<CountResponse> listener) {
        this.performRequestAsyncAndParseEntity(countRequest, RequestConverters::count, options, CountResponse::fromXContent, listener, Collections.emptySet());
    }

    public final UpdateResponse update(UpdateRequest updateRequest, RequestOptions options) throws IOException {
        return (UpdateResponse)this.performRequestAndParseEntity(updateRequest, RequestConverters::update, options, UpdateResponse::fromXContent, Collections.emptySet());
    }

    @Deprecated
    public final UpdateResponse update(UpdateRequest updateRequest, Header ... headers) throws IOException {
        return (UpdateResponse)this.performRequestAndParseEntity(updateRequest, RequestConverters::update, UpdateResponse::fromXContent, Collections.emptySet(), headers);
    }

    public final void updateAsync(UpdateRequest updateRequest, RequestOptions options, ActionListener<UpdateResponse> listener) {
        this.performRequestAsyncAndParseEntity(updateRequest, RequestConverters::update, options, UpdateResponse::fromXContent, listener, Collections.emptySet());
    }

    @Deprecated
    public final void updateAsync(UpdateRequest updateRequest, ActionListener<UpdateResponse> listener, Header ... headers) {
        this.performRequestAsyncAndParseEntity(updateRequest, RequestConverters::update, UpdateResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public final DeleteResponse delete(DeleteRequest deleteRequest, RequestOptions options) throws IOException {
        return (DeleteResponse)this.performRequestAndParseEntity(deleteRequest, RequestConverters::delete, options, DeleteResponse::fromXContent, Collections.singleton(404));
    }

    @Deprecated
    public final DeleteResponse delete(DeleteRequest deleteRequest, Header ... headers) throws IOException {
        return (DeleteResponse)this.performRequestAndParseEntity(deleteRequest, RequestConverters::delete, DeleteResponse::fromXContent, Collections.singleton(404), headers);
    }

    public final void deleteAsync(DeleteRequest deleteRequest, RequestOptions options, ActionListener<DeleteResponse> listener) {
        this.performRequestAsyncAndParseEntity(deleteRequest, RequestConverters::delete, options, DeleteResponse::fromXContent, listener, Collections.singleton(404));
    }

    @Deprecated
    public final void deleteAsync(DeleteRequest deleteRequest, ActionListener<DeleteResponse> listener, Header ... headers) {
        this.performRequestAsyncAndParseEntity(deleteRequest, RequestConverters::delete, DeleteResponse::fromXContent, listener, Collections.singleton(404), headers);
    }

    public final SearchResponse search(SearchRequest searchRequest, RequestOptions options) throws IOException {
        return (SearchResponse)this.performRequestAndParseEntity(searchRequest, r -> RequestConverters.search(r, "_search"), options, SearchResponse::fromXContent, Collections.emptySet());
    }

    @Deprecated
    public final SearchResponse search(SearchRequest searchRequest, Header ... headers) throws IOException {
        return (SearchResponse)this.performRequestAndParseEntity(searchRequest, r -> RequestConverters.search(r, "_search"), SearchResponse::fromXContent, Collections.emptySet(), headers);
    }

    public final void searchAsync(SearchRequest searchRequest, RequestOptions options, ActionListener<SearchResponse> listener) {
        this.performRequestAsyncAndParseEntity(searchRequest, r -> RequestConverters.search(r, "_search"), options, SearchResponse::fromXContent, listener, Collections.emptySet());
    }

    @Deprecated
    public final void searchAsync(SearchRequest searchRequest, ActionListener<SearchResponse> listener, Header ... headers) {
        this.performRequestAsyncAndParseEntity(searchRequest, r -> RequestConverters.search(r, "_search"), SearchResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    @Deprecated
    public final MultiSearchResponse multiSearch(MultiSearchRequest multiSearchRequest, RequestOptions options) throws IOException {
        return this.msearch(multiSearchRequest, options);
    }

    public final MultiSearchResponse msearch(MultiSearchRequest multiSearchRequest, RequestOptions options) throws IOException {
        return (MultiSearchResponse)this.performRequestAndParseEntity(multiSearchRequest, RequestConverters::multiSearch, options, MultiSearchResponse::fromXContext, Collections.emptySet());
    }

    @Deprecated
    public final MultiSearchResponse multiSearch(MultiSearchRequest multiSearchRequest, Header ... headers) throws IOException {
        return (MultiSearchResponse)this.performRequestAndParseEntity(multiSearchRequest, RequestConverters::multiSearch, MultiSearchResponse::fromXContext, Collections.emptySet(), headers);
    }

    @Deprecated
    public final void multiSearchAsync(MultiSearchRequest searchRequest, RequestOptions options, ActionListener<MultiSearchResponse> listener) {
        this.msearchAsync(searchRequest, options, listener);
    }

    public final void msearchAsync(MultiSearchRequest searchRequest, RequestOptions options, ActionListener<MultiSearchResponse> listener) {
        this.performRequestAsyncAndParseEntity(searchRequest, RequestConverters::multiSearch, options, MultiSearchResponse::fromXContext, listener, Collections.emptySet());
    }

    @Deprecated
    public final void multiSearchAsync(MultiSearchRequest searchRequest, ActionListener<MultiSearchResponse> listener, Header ... headers) {
        this.performRequestAsyncAndParseEntity(searchRequest, RequestConverters::multiSearch, MultiSearchResponse::fromXContext, listener, Collections.emptySet(), headers);
    }

    @Deprecated
    public final SearchResponse searchScroll(SearchScrollRequest searchScrollRequest, RequestOptions options) throws IOException {
        return this.scroll(searchScrollRequest, options);
    }

    public final SearchResponse scroll(SearchScrollRequest searchScrollRequest, RequestOptions options) throws IOException {
        return (SearchResponse)this.performRequestAndParseEntity(searchScrollRequest, RequestConverters::searchScroll, options, SearchResponse::fromXContent, Collections.emptySet());
    }

    @Deprecated
    public final SearchResponse searchScroll(SearchScrollRequest searchScrollRequest, Header ... headers) throws IOException {
        return (SearchResponse)this.performRequestAndParseEntity(searchScrollRequest, RequestConverters::searchScroll, SearchResponse::fromXContent, Collections.emptySet(), headers);
    }

    @Deprecated
    public final void searchScrollAsync(SearchScrollRequest searchScrollRequest, RequestOptions options, ActionListener<SearchResponse> listener) {
        this.scrollAsync(searchScrollRequest, options, listener);
    }

    public final void scrollAsync(SearchScrollRequest searchScrollRequest, RequestOptions options, ActionListener<SearchResponse> listener) {
        this.performRequestAsyncAndParseEntity(searchScrollRequest, RequestConverters::searchScroll, options, SearchResponse::fromXContent, listener, Collections.emptySet());
    }

    @Deprecated
    public final void searchScrollAsync(SearchScrollRequest searchScrollRequest, ActionListener<SearchResponse> listener, Header ... headers) {
        this.performRequestAsyncAndParseEntity(searchScrollRequest, RequestConverters::searchScroll, SearchResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public final ClearScrollResponse clearScroll(ClearScrollRequest clearScrollRequest, RequestOptions options) throws IOException {
        return (ClearScrollResponse)this.performRequestAndParseEntity(clearScrollRequest, RequestConverters::clearScroll, options, ClearScrollResponse::fromXContent, Collections.emptySet());
    }

    @Deprecated
    public final ClearScrollResponse clearScroll(ClearScrollRequest clearScrollRequest, Header ... headers) throws IOException {
        return (ClearScrollResponse)this.performRequestAndParseEntity(clearScrollRequest, RequestConverters::clearScroll, ClearScrollResponse::fromXContent, Collections.emptySet(), headers);
    }

    public final void clearScrollAsync(ClearScrollRequest clearScrollRequest, RequestOptions options, ActionListener<ClearScrollResponse> listener) {
        this.performRequestAsyncAndParseEntity(clearScrollRequest, RequestConverters::clearScroll, options, ClearScrollResponse::fromXContent, listener, Collections.emptySet());
    }

    @Deprecated
    public final void clearScrollAsync(ClearScrollRequest clearScrollRequest, ActionListener<ClearScrollResponse> listener, Header ... headers) {
        this.performRequestAsyncAndParseEntity(clearScrollRequest, RequestConverters::clearScroll, ClearScrollResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public final SearchTemplateResponse searchTemplate(SearchTemplateRequest searchTemplateRequest, RequestOptions options) throws IOException {
        return (SearchTemplateResponse)this.performRequestAndParseEntity(searchTemplateRequest, RequestConverters::searchTemplate, options, SearchTemplateResponse::fromXContent, Collections.emptySet());
    }

    public final void searchTemplateAsync(SearchTemplateRequest searchTemplateRequest, RequestOptions options, ActionListener<SearchTemplateResponse> listener) {
        this.performRequestAsyncAndParseEntity(searchTemplateRequest, RequestConverters::searchTemplate, options, SearchTemplateResponse::fromXContent, listener, Collections.emptySet());
    }

    public final ExplainResponse explain(ExplainRequest explainRequest, RequestOptions options) throws IOException {
        return (ExplainResponse)this.performRequest(explainRequest, RequestConverters::explain, options, response -> {
            CheckedFunction entityParser = parser -> ExplainResponse.fromXContent((XContentParser)parser, (boolean)RestHighLevelClient.convertExistsResponse(response));
            return (ExplainResponse)this.parseEntity(response.getEntity(), entityParser);
        }, Collections.singleton(404));
    }

    public final void explainAsync(ExplainRequest explainRequest, RequestOptions options, ActionListener<ExplainResponse> listener) {
        this.performRequestAsync(explainRequest, RequestConverters::explain, options, response -> {
            CheckedFunction entityParser = parser -> ExplainResponse.fromXContent((XContentParser)parser, (boolean)RestHighLevelClient.convertExistsResponse(response));
            return (ExplainResponse)this.parseEntity(response.getEntity(), entityParser);
        }, listener, Collections.singleton(404));
    }

    public final TermVectorsResponse termvectors(TermVectorsRequest request, RequestOptions options) throws IOException {
        return (TermVectorsResponse)this.performRequestAndParseEntity(request, RequestConverters::termVectors, options, TermVectorsResponse::fromXContent, Collections.emptySet());
    }

    public final void termvectorsAsync(TermVectorsRequest request, RequestOptions options, ActionListener<TermVectorsResponse> listener) {
        this.performRequestAsyncAndParseEntity(request, RequestConverters::termVectors, options, TermVectorsResponse::fromXContent, listener, Collections.emptySet());
    }

    public final MultiTermVectorsResponse mtermvectors(MultiTermVectorsRequest request, RequestOptions options) throws IOException {
        return (MultiTermVectorsResponse)this.performRequestAndParseEntity(request, RequestConverters::mtermVectors, options, MultiTermVectorsResponse::fromXContent, Collections.emptySet());
    }

    public final void mtermvectorsAsync(MultiTermVectorsRequest request, RequestOptions options, ActionListener<MultiTermVectorsResponse> listener) {
        this.performRequestAsyncAndParseEntity(request, RequestConverters::mtermVectors, options, MultiTermVectorsResponse::fromXContent, listener, Collections.emptySet());
    }

    public final RankEvalResponse rankEval(RankEvalRequest rankEvalRequest, RequestOptions options) throws IOException {
        return (RankEvalResponse)this.performRequestAndParseEntity(rankEvalRequest, RequestConverters::rankEval, options, RankEvalResponse::fromXContent, Collections.emptySet());
    }

    @Deprecated
    public final RankEvalResponse rankEval(RankEvalRequest rankEvalRequest, Header ... headers) throws IOException {
        return (RankEvalResponse)this.performRequestAndParseEntity(rankEvalRequest, RequestConverters::rankEval, RankEvalResponse::fromXContent, Collections.emptySet(), headers);
    }

    public final void rankEvalAsync(RankEvalRequest rankEvalRequest, RequestOptions options, ActionListener<RankEvalResponse> listener) {
        this.performRequestAsyncAndParseEntity(rankEvalRequest, RequestConverters::rankEval, options, RankEvalResponse::fromXContent, listener, Collections.emptySet());
    }

    public final MultiSearchTemplateResponse msearchTemplate(MultiSearchTemplateRequest multiSearchTemplateRequest, RequestOptions options) throws IOException {
        return (MultiSearchTemplateResponse)this.performRequestAndParseEntity(multiSearchTemplateRequest, RequestConverters::multiSearchTemplate, options, MultiSearchTemplateResponse::fromXContext, Collections.emptySet());
    }

    public final void msearchTemplateAsync(MultiSearchTemplateRequest multiSearchTemplateRequest, RequestOptions options, ActionListener<MultiSearchTemplateResponse> listener) {
        this.performRequestAsyncAndParseEntity(multiSearchTemplateRequest, RequestConverters::multiSearchTemplate, options, MultiSearchTemplateResponse::fromXContext, listener, Collections.emptySet());
    }

    @Deprecated
    public final void rankEvalAsync(RankEvalRequest rankEvalRequest, ActionListener<RankEvalResponse> listener, Header ... headers) {
        this.performRequestAsyncAndParseEntity(rankEvalRequest, RequestConverters::rankEval, RankEvalResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public final FieldCapabilitiesResponse fieldCaps(FieldCapabilitiesRequest fieldCapabilitiesRequest, RequestOptions options) throws IOException {
        return (FieldCapabilitiesResponse)this.performRequestAndParseEntity(fieldCapabilitiesRequest, RequestConverters::fieldCaps, options, FieldCapabilitiesResponse::fromXContent, Collections.emptySet());
    }

    public GetStoredScriptResponse getScript(GetStoredScriptRequest request, RequestOptions options) throws IOException {
        return (GetStoredScriptResponse)this.performRequestAndParseEntity(request, RequestConverters::getScript, options, GetStoredScriptResponse::fromXContent, Collections.emptySet());
    }

    public void getScriptAsync(GetStoredScriptRequest request, RequestOptions options, ActionListener<GetStoredScriptResponse> listener) {
        this.performRequestAsyncAndParseEntity(request, RequestConverters::getScript, options, GetStoredScriptResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse deleteScript(DeleteStoredScriptRequest request, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.performRequestAndParseEntity(request, RequestConverters::deleteScript, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void deleteScriptAsync(DeleteStoredScriptRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.performRequestAsyncAndParseEntity(request, RequestConverters::deleteScript, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse putScript(PutStoredScriptRequest putStoredScriptRequest, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.performRequestAndParseEntity(putStoredScriptRequest, RequestConverters::putScript, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void putScriptAsync(PutStoredScriptRequest putStoredScriptRequest, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.performRequestAsyncAndParseEntity(putStoredScriptRequest, RequestConverters::putScript, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public final void fieldCapsAsync(FieldCapabilitiesRequest fieldCapabilitiesRequest, RequestOptions options, ActionListener<FieldCapabilitiesResponse> listener) {
        this.performRequestAsyncAndParseEntity(fieldCapabilitiesRequest, RequestConverters::fieldCaps, options, FieldCapabilitiesResponse::fromXContent, listener, Collections.emptySet());
    }

    @Deprecated
    protected final <Req extends ActionRequest, Resp> Resp performRequestAndParseEntity(Req request, CheckedFunction<Req, Request, IOException> requestConverter, CheckedFunction<XContentParser, Resp, IOException> entityParser, Set<Integer> ignores, Header ... headers) throws IOException {
        return this.performRequest(request, requestConverter, response -> this.parseEntity(response.getEntity(), entityParser), ignores, headers);
    }

    @Deprecated
    protected final <Req extends ActionRequest, Resp> Resp performRequestAndParseEntity(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<XContentParser, Resp, IOException> entityParser, Set<Integer> ignores) throws IOException {
        return this.performRequest(request, requestConverter, options, (CheckedFunction<Response, Resp, IOException>)((CheckedFunction)response -> this.parseEntity(response.getEntity(), entityParser)), ignores);
    }

    protected final <Req extends Validatable, Resp> Resp performRequestAndParseEntity(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<XContentParser, Resp, IOException> entityParser, Set<Integer> ignores) throws IOException {
        return this.performRequest(request, requestConverter, options, response -> this.parseEntity(response.getEntity(), entityParser), ignores);
    }

    @Deprecated
    protected final <Req extends ActionRequest, Resp> Resp performRequest(Req request, CheckedFunction<Req, Request, IOException> requestConverter, CheckedFunction<Response, Resp, IOException> responseConverter, Set<Integer> ignores, Header ... headers) throws IOException {
        return this.performRequest(request, requestConverter, RestHighLevelClient.optionsForHeaders(headers), responseConverter, ignores);
    }

    @Deprecated
    protected final <Req extends ActionRequest, Resp> Resp performRequest(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<Response, Resp, IOException> responseConverter, Set<Integer> ignores) throws IOException {
        ActionRequestValidationException validationException = request.validate();
        if (validationException != null && !validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return this.internalPerformRequest(request, requestConverter, options, responseConverter, ignores);
    }

    protected final <Req extends Validatable, Resp> Resp performRequest(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<Response, Resp, IOException> responseConverter, Set<Integer> ignores) throws IOException {
        Optional<ValidationException> validationException = request.validate();
        if (validationException != null && validationException.isPresent()) {
            throw validationException.get();
        }
        return this.internalPerformRequest(request, requestConverter, options, responseConverter, ignores);
    }

    private <Req, Resp> Resp internalPerformRequest(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<Response, Resp, IOException> responseConverter, Set<Integer> ignores) throws IOException {
        Response response;
        Request req = (Request)requestConverter.apply(request);
        req.setOptions(options);
        try {
            response = this.client.performRequest(req);
        }
        catch (ResponseException e) {
            if (ignores.contains(e.getResponse().getStatusLine().getStatusCode())) {
                try {
                    return (Resp)responseConverter.apply((Object)e.getResponse());
                }
                catch (Exception innerException) {
                    throw this.parseResponseException(e);
                }
            }
            throw this.parseResponseException(e);
        }
        try {
            return (Resp)responseConverter.apply((Object)response);
        }
        catch (Exception e) {
            throw new IOException("Unable to parse response body for " + response, e);
        }
    }

    protected final <Req extends Validatable, Resp> Optional<Resp> performRequestAndParseOptionalEntity(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<XContentParser, Resp, IOException> entityParser) throws IOException {
        Response response;
        Optional<ValidationException> validationException = request.validate();
        if (validationException != null && validationException.isPresent()) {
            throw validationException.get();
        }
        Request req = (Request)requestConverter.apply(request);
        req.setOptions(options);
        try {
            response = this.client.performRequest(req);
        }
        catch (ResponseException e) {
            if (RestStatus.NOT_FOUND.getStatus() == e.getResponse().getStatusLine().getStatusCode()) {
                return Optional.empty();
            }
            throw this.parseResponseException(e);
        }
        try {
            return Optional.of(this.parseEntity(response.getEntity(), entityParser));
        }
        catch (Exception e) {
            throw new IOException("Unable to parse response body for " + response, e);
        }
    }

    @Deprecated
    protected final <Req extends ActionRequest, Resp> void performRequestAsyncAndParseEntity(Req request, CheckedFunction<Req, Request, IOException> requestConverter, CheckedFunction<XContentParser, Resp, IOException> entityParser, ActionListener<Resp> listener, Set<Integer> ignores, Header ... headers) {
        this.performRequestAsync(request, requestConverter, response -> this.parseEntity(response.getEntity(), entityParser), listener, ignores, headers);
    }

    @Deprecated
    protected final <Req extends ActionRequest, Resp> void performRequestAsyncAndParseEntity(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<XContentParser, Resp, IOException> entityParser, ActionListener<Resp> listener, Set<Integer> ignores) {
        this.performRequestAsync(request, requestConverter, options, (CheckedFunction<Response, Resp, IOException>)((CheckedFunction)response -> this.parseEntity(response.getEntity(), entityParser)), listener, ignores);
    }

    protected final <Req extends Validatable, Resp> void performRequestAsyncAndParseEntity(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<XContentParser, Resp, IOException> entityParser, ActionListener<Resp> listener, Set<Integer> ignores) {
        this.performRequestAsync(request, requestConverter, options, response -> this.parseEntity(response.getEntity(), entityParser), listener, ignores);
    }

    @Deprecated
    protected final <Req extends ActionRequest, Resp> void performRequestAsync(Req request, CheckedFunction<Req, Request, IOException> requestConverter, CheckedFunction<Response, Resp, IOException> responseConverter, ActionListener<Resp> listener, Set<Integer> ignores, Header ... headers) {
        this.performRequestAsync(request, requestConverter, RestHighLevelClient.optionsForHeaders(headers), responseConverter, listener, ignores);
    }

    @Deprecated
    protected final <Req extends ActionRequest, Resp> void performRequestAsync(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<Response, Resp, IOException> responseConverter, ActionListener<Resp> listener, Set<Integer> ignores) {
        ActionRequestValidationException validationException = request.validate();
        if (validationException != null && !validationException.validationErrors().isEmpty()) {
            listener.onFailure((Exception)validationException);
            return;
        }
        this.internalPerformRequestAsync(request, requestConverter, options, responseConverter, listener, ignores);
    }

    protected final <Req extends Validatable, Resp> void performRequestAsync(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<Response, Resp, IOException> responseConverter, ActionListener<Resp> listener, Set<Integer> ignores) {
        Optional<ValidationException> validationException = request.validate();
        if (validationException != null && validationException.isPresent()) {
            listener.onFailure((Exception)validationException.get());
            return;
        }
        this.internalPerformRequestAsync(request, requestConverter, options, responseConverter, listener, ignores);
    }

    private <Req, Resp> void internalPerformRequestAsync(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<Response, Resp, IOException> responseConverter, ActionListener<Resp> listener, Set<Integer> ignores) {
        Request req;
        try {
            req = (Request)requestConverter.apply(request);
        }
        catch (Exception e) {
            listener.onFailure(e);
            return;
        }
        req.setOptions(options);
        ResponseListener responseListener = this.wrapResponseListener(responseConverter, listener, ignores);
        this.client.performRequestAsync(req, responseListener);
    }

    final <Resp> ResponseListener wrapResponseListener(final CheckedFunction<Response, Resp, IOException> responseConverter, final ActionListener<Resp> actionListener, final Set<Integer> ignores) {
        return new ResponseListener(){

            public void onSuccess(Response response) {
                try {
                    actionListener.onResponse(responseConverter.apply((Object)response));
                }
                catch (Exception e) {
                    IOException ioe = new IOException("Unable to parse response body for " + response, e);
                    this.onFailure(ioe);
                }
            }

            public void onFailure(Exception exception) {
                if (exception instanceof ResponseException) {
                    ResponseException responseException = (ResponseException)exception;
                    Response response = responseException.getResponse();
                    if (ignores.contains(response.getStatusLine().getStatusCode())) {
                        try {
                            actionListener.onResponse(responseConverter.apply((Object)response));
                        }
                        catch (Exception innerException) {
                            actionListener.onFailure((Exception)RestHighLevelClient.this.parseResponseException(responseException));
                        }
                    } else {
                        actionListener.onFailure((Exception)RestHighLevelClient.this.parseResponseException(responseException));
                    }
                } else {
                    actionListener.onFailure(exception);
                }
            }
        };
    }

    protected final <Req extends Validatable, Resp> void performRequestAsyncAndParseOptionalEntity(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<XContentParser, Resp, IOException> entityParser, ActionListener<Optional<Resp>> listener) {
        Request req;
        Optional<ValidationException> validationException = request.validate();
        if (validationException != null && validationException.isPresent()) {
            listener.onFailure((Exception)validationException.get());
            return;
        }
        try {
            req = (Request)requestConverter.apply(request);
        }
        catch (Exception e) {
            listener.onFailure(e);
            return;
        }
        req.setOptions(options);
        ResponseListener responseListener = this.wrapResponseListener404sOptional(response -> this.parseEntity(response.getEntity(), entityParser), listener);
        this.client.performRequestAsync(req, responseListener);
    }

    final <Resp> ResponseListener wrapResponseListener404sOptional(final CheckedFunction<Response, Resp, IOException> responseConverter, final ActionListener<Optional<Resp>> actionListener) {
        return new ResponseListener(){

            public void onSuccess(Response response) {
                try {
                    actionListener.onResponse(Optional.of(responseConverter.apply((Object)response)));
                }
                catch (Exception e) {
                    IOException ioe = new IOException("Unable to parse response body for " + response, e);
                    this.onFailure(ioe);
                }
            }

            public void onFailure(Exception exception) {
                if (exception instanceof ResponseException) {
                    ResponseException responseException = (ResponseException)exception;
                    Response response = responseException.getResponse();
                    if (RestStatus.NOT_FOUND.getStatus() == response.getStatusLine().getStatusCode()) {
                        actionListener.onResponse(Optional.empty());
                    } else {
                        actionListener.onFailure((Exception)RestHighLevelClient.this.parseResponseException(responseException));
                    }
                } else {
                    actionListener.onFailure(exception);
                }
            }
        };
    }

    protected final ElasticsearchStatusException parseResponseException(ResponseException responseException) {
        ElasticsearchStatusException elasticsearchException;
        Response response = responseException.getResponse();
        HttpEntity entity = response.getEntity();
        RestStatus restStatus = RestStatus.fromCode((int)response.getStatusLine().getStatusCode());
        if (entity == null) {
            elasticsearchException = new ElasticsearchStatusException(responseException.getMessage(), restStatus, (Throwable)responseException, new Object[0]);
        } else {
            try {
                elasticsearchException = (ElasticsearchStatusException)this.parseEntity(entity, BytesRestResponse::errorFromXContent);
                elasticsearchException.addSuppressed((Throwable)responseException);
            }
            catch (Exception e) {
                elasticsearchException = new ElasticsearchStatusException("Unable to parse response body", restStatus, (Throwable)responseException, new Object[0]);
                elasticsearchException.addSuppressed((Throwable)e);
            }
        }
        return elasticsearchException;
    }

    protected final <Resp> Resp parseEntity(HttpEntity httpEntity, CheckedFunction<XContentParser, Resp, IOException> entityParser) throws IOException {
        if (httpEntity == null) {
            throw new IllegalStateException("Response body expected but not returned");
        }
        HttpEntity entity = Optional.ofNullable(httpEntity.getContentEncoding()).map(Header::getValue).filter("gzip"::equalsIgnoreCase).map(gzipHeaderValue -> new GzipDecompressingEntity(httpEntity)).orElse(httpEntity);
        if (entity.getContentType() == null) {
            throw new IllegalStateException("Elasticsearch didn't return the [Content-Type] header, unable to parse response body");
        }
        XContentType xContentType = XContentType.fromMediaTypeOrFormat((String)entity.getContentType().getValue());
        if (xContentType == null) {
            throw new IllegalStateException("Unsupported Content-Type: " + entity.getContentType().getValue());
        }
        try (XContentParser parser = xContentType.xContent().createParser(this.registry, DEPRECATION_HANDLER, entity.getContent());){
            Object object = entityParser.apply((Object)parser);
            return (Resp)object;
        }
    }

    private static RequestOptions optionsForHeaders(Header[] headers) {
        RequestOptions.Builder options = RequestOptions.DEFAULT.toBuilder();
        for (Header header : headers) {
            Objects.requireNonNull(header, "header cannot be null");
            options.addHeader(header.getName(), header.getValue());
        }
        return options.build();
    }

    protected static boolean convertExistsResponse(Response response) {
        return response.getStatusLine().getStatusCode() == 200;
    }

    static List<NamedXContentRegistry.Entry> getDefaultNamedXContents() {
        HashMap<String, ContextParser> map = new HashMap<String, ContextParser>();
        map.put("cardinality", (p, c) -> ParsedCardinality.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("hdr_percentiles", (p, c) -> ParsedHDRPercentiles.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("hdr_percentile_ranks", (p, c) -> ParsedHDRPercentileRanks.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("tdigest_percentiles", (p, c) -> ParsedTDigestPercentiles.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("tdigest_percentile_ranks", (p, c) -> ParsedTDigestPercentileRanks.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("percentiles_bucket", (p, c) -> ParsedPercentilesBucket.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("median_absolute_deviation", (p, c) -> ParsedMedianAbsoluteDeviation.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("min", (p, c) -> ParsedMin.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("max", (p, c) -> ParsedMax.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("sum", (p, c) -> ParsedSum.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("avg", (p, c) -> ParsedAvg.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("weighted_avg", (p, c) -> ParsedWeightedAvg.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("value_count", (p, c) -> ParsedValueCount.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("simple_value", (p, c) -> ParsedSimpleValue.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("derivative", (p, c) -> ParsedDerivative.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("bucket_metric_value", (p, c) -> ParsedBucketMetricValue.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("stats", (p, c) -> ParsedStats.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("stats_bucket", (p, c) -> ParsedStatsBucket.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("extended_stats", (p, c) -> ParsedExtendedStats.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("extended_stats_bucket", (p, c) -> ParsedExtendedStatsBucket.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("geo_bounds", (p, c) -> ParsedGeoBounds.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("geo_centroid", (p, c) -> ParsedGeoCentroid.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("histogram", (p, c) -> ParsedHistogram.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("date_histogram", (p, c) -> ParsedDateHistogram.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("auto_date_histogram", (p, c) -> ParsedAutoDateHistogram.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("sterms", (p, c) -> ParsedStringTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("lterms", (p, c) -> ParsedLongTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("dterms", (p, c) -> ParsedDoubleTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("missing", (p, c) -> ParsedMissing.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("nested", (p, c) -> ParsedNested.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("reverse_nested", (p, c) -> ParsedReverseNested.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("global", (p, c) -> ParsedGlobal.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("filter", (p, c) -> ParsedFilter.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("sampler", (p, c) -> ParsedSampler.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("geohash_grid", (p, c) -> ParsedGeoHashGrid.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("range", (p, c) -> ParsedRange.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("date_range", (p, c) -> ParsedDateRange.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("geo_distance", (p, c) -> ParsedGeoDistance.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("filters", (p, c) -> ParsedFilters.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("adjacency_matrix", (p, c) -> ParsedAdjacencyMatrix.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("siglterms", (p, c) -> ParsedSignificantLongTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("sigsterms", (p, c) -> ParsedSignificantStringTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("scripted_metric", (p, c) -> ParsedScriptedMetric.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("ip_range", (p, c) -> ParsedBinaryRange.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("top_hits", (p, c) -> ParsedTopHits.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("composite", (p, c) -> ParsedComposite.fromXContent((XContentParser)p, (String)((String)c)));
        List<NamedXContentRegistry.Entry> entries = map.entrySet().stream().map(entry -> new NamedXContentRegistry.Entry(Aggregation.class, new ParseField((String)entry.getKey(), new String[0]), (ContextParser)entry.getValue())).collect(Collectors.toList());
        entries.add(new NamedXContentRegistry.Entry(Suggest.Suggestion.class, new ParseField("term", new String[0]), (parser, context) -> TermSuggestion.fromXContent((XContentParser)parser, (String)((String)context))));
        entries.add(new NamedXContentRegistry.Entry(Suggest.Suggestion.class, new ParseField("phrase", new String[0]), (parser, context) -> PhraseSuggestion.fromXContent((XContentParser)parser, (String)((String)context))));
        entries.add(new NamedXContentRegistry.Entry(Suggest.Suggestion.class, new ParseField("completion", new String[0]), (parser, context) -> CompletionSuggestion.fromXContent((XContentParser)parser, (String)((String)context))));
        return entries;
    }

    static List<NamedXContentRegistry.Entry> getProvidedNamedXContents() {
        ArrayList<NamedXContentRegistry.Entry> entries = new ArrayList<NamedXContentRegistry.Entry>();
        for (NamedXContentProvider service : ServiceLoader.load(NamedXContentProvider.class)) {
            entries.addAll(service.getNamedXContentParsers());
        }
        return entries;
    }
}

