/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.compression.JZlibDecoder;
import io.netty.handler.codec.compression.JZlibEncoder;
import io.netty.handler.ipfilter.IpFilterRule;
import io.netty.handler.ipfilter.IpFilterRuleType;
import io.netty.handler.ipfilter.RuleBasedIpFilter;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.Server;
import org.apache.avro.ipc.netty.NettyServer;
import org.apache.avro.ipc.specific.SpecificResponder;
import org.apache.flume.ChannelException;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDrivenSource;
import org.apache.flume.FlumeException;
import org.apache.flume.conf.Configurable;
import org.apache.flume.conf.Configurables;
import org.apache.flume.conf.LogPrivacyUtil;
import org.apache.flume.event.EventBuilder;
import org.apache.flume.instrumentation.SourceCounter;
import org.apache.flume.netty.filter.PatternRule;
import org.apache.flume.source.SslContextAwareAbstractSource;
import org.apache.flume.source.avro.AvroFlumeEvent;
import org.apache.flume.source.avro.AvroSourceProtocol;
import org.apache.flume.source.avro.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSource
extends SslContextAwareAbstractSource
implements EventDrivenSource,
Configurable,
AvroSourceProtocol {
    private static final String THREADS = "threads";
    private static final Logger logger = LoggerFactory.getLogger(AvroSource.class);
    private static final String PORT_KEY = "port";
    private static final String BIND_KEY = "bind";
    private static final String COMPRESSION_TYPE = "compression-type";
    private static final String IP_FILTER_KEY = "ipFilter";
    private static final String IP_FILTER_RULES_KEY = "ipFilterRules";
    private int port;
    private String bindAddress;
    private String compressionType;
    private boolean enableIpFilter;
    private String patternRuleConfigDefinition;
    private Server server;
    private SourceCounter sourceCounter;
    private int maxThreads;
    private ScheduledExecutorService connectionCountUpdater;
    private List<IpFilterRule> rules;

    @Override
    public void configure(Context context) {
        this.configureSsl(context);
        Configurables.ensureRequiredNonNull(context, PORT_KEY, BIND_KEY);
        this.port = context.getInteger(PORT_KEY);
        this.bindAddress = context.getString(BIND_KEY);
        this.compressionType = context.getString(COMPRESSION_TYPE, "none");
        try {
            this.maxThreads = context.getInteger(THREADS, Integer.valueOf(0));
        }
        catch (NumberFormatException e) {
            logger.warn("AVRO source's \"threads\" property must specify an integer value.", (Object)context.getString(THREADS));
        }
        this.enableIpFilter = context.getBoolean(IP_FILTER_KEY, Boolean.valueOf(false));
        if (this.enableIpFilter) {
            this.patternRuleConfigDefinition = context.getString(IP_FILTER_RULES_KEY);
            if (this.patternRuleConfigDefinition == null || this.patternRuleConfigDefinition.trim().isEmpty()) {
                throw new FlumeException("ipFilter is configured with true but ipFilterRules is not defined: ");
            }
            String[] patternRuleDefinitions = this.patternRuleConfigDefinition.split(",");
            this.rules = new ArrayList<IpFilterRule>(patternRuleDefinitions.length);
            for (String patternRuleDefinition : patternRuleDefinitions) {
                this.rules.add(this.generateRule(patternRuleDefinition));
            }
        }
        if (this.sourceCounter == null) {
            this.sourceCounter = new SourceCounter(this.getName());
        }
    }

    @Override
    public void start() {
        logger.info("Starting {}...", (Object)this);
        try {
            SpecificResponder responder = new SpecificResponder(AvroSourceProtocol.class, (Object)this);
            boolean enableCompression = this.compressionType.equalsIgnoreCase("deflate");
            this.server = new NettyServer((Responder)responder, new InetSocketAddress(this.bindAddress, this.port), ch -> {
                ChannelPipeline pipeline = ch.pipeline();
                if (enableCompression) {
                    JZlibEncoder encoder = new JZlibEncoder(6);
                    pipeline.addFirst("deflater", (ChannelHandler)encoder);
                    pipeline.addFirst("inflater", (ChannelHandler)new JZlibDecoder());
                }
                Optional<SSLEngine> engine = this.getSslEngine(false);
                engine.ifPresent(sslEngine -> pipeline.addLast("ssl", (ChannelHandler)new SslHandler(sslEngine)));
                if (this.enableIpFilter) {
                    logger.info("Setting up ipFilter with the following rule definition: " + this.patternRuleConfigDefinition);
                    RuleBasedIpFilter filter = new RuleBasedIpFilter(this.rules.toArray(new IpFilterRule[0]));
                    logger.info("Adding ipFilter with " + this.rules.size() + " rules");
                    pipeline.addFirst(IP_FILTER_KEY, (ChannelHandler)filter);
                }
            });
        }
        catch (Exception nce) {
            logger.error("Avro source {} startup failed. Cannot initialize Netty server", (Object)this.getName(), (Object)nce);
            this.stop();
            throw new FlumeException("Failed to set up server socket", (Throwable)nce);
        }
        this.connectionCountUpdater = Executors.newSingleThreadScheduledExecutor();
        this.server.start();
        this.sourceCounter.start();
        super.start();
        NettyServer srv = (NettyServer)this.server;
        this.connectionCountUpdater.scheduleWithFixedDelay(() -> this.sourceCounter.setOpenConnectionCount(srv.getNumActiveConnections()), 0L, 60L, TimeUnit.SECONDS);
        logger.info("Avro source {} started.", (Object)this.getName());
    }

    @Override
    public void stop() {
        logger.info("Avro source {} stopping: {}", (Object)this.getName(), (Object)this);
        if (this.server != null) {
            this.server.close();
            try {
                this.server.join();
                this.server = null;
            }
            catch (InterruptedException e) {
                logger.info("Avro source " + this.getName() + ": Interrupted while waiting for Avro server to stop. Exiting. Exception follows.", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        this.sourceCounter.stop();
        if (this.connectionCountUpdater != null) {
            this.connectionCountUpdater.shutdownNow();
            this.connectionCountUpdater = null;
        }
        super.stop();
        logger.info("Avro source {} stopped. Metrics: {}", (Object)this.getName(), (Object)this.sourceCounter);
    }

    @Override
    public String toString() {
        return "Avro source " + this.getName() + ": { bindAddress: " + this.bindAddress + ", port: " + this.port + " }";
    }

    private static Map<String, String> toStringMap(Map<CharSequence, CharSequence> charSeqMap) {
        HashMap<String, String> stringMap = new HashMap<String, String>();
        for (Map.Entry<CharSequence, CharSequence> entry : charSeqMap.entrySet()) {
            stringMap.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return stringMap;
    }

    public Status append(AvroFlumeEvent avroEvent) {
        if (logger.isDebugEnabled()) {
            if (LogPrivacyUtil.allowLogRawData()) {
                logger.debug("Avro source {}: Received avro event: {}", (Object)this.getName(), (Object)avroEvent);
            } else {
                logger.debug("Avro source {}: Received avro event", (Object)this.getName());
            }
        }
        this.sourceCounter.incrementAppendReceivedCount();
        this.sourceCounter.incrementEventReceivedCount();
        Event event = EventBuilder.withBody((byte[])avroEvent.getBody().array(), AvroSource.toStringMap(avroEvent.getHeaders()));
        try {
            this.getChannelProcessor().processEvent(event);
        }
        catch (ChannelException ex) {
            logger.warn("Avro source " + this.getName() + ": Unable to process event. Exception follows.", (Throwable)ex);
            this.sourceCounter.incrementChannelWriteFail();
            return Status.FAILED;
        }
        this.sourceCounter.incrementAppendAcceptedCount();
        this.sourceCounter.incrementEventAcceptedCount();
        return Status.OK;
    }

    public Status appendBatch(List<AvroFlumeEvent> events) {
        logger.debug("Avro source {}: Received avro event batch of {} events.", (Object)this.getName(), (Object)events.size());
        this.sourceCounter.incrementAppendBatchReceivedCount();
        this.sourceCounter.addToEventReceivedCount(events.size());
        ArrayList<Event> batch = new ArrayList<Event>();
        for (AvroFlumeEvent avroEvent : events) {
            Event event = EventBuilder.withBody((byte[])avroEvent.getBody().array(), AvroSource.toStringMap(avroEvent.getHeaders()));
            batch.add(event);
        }
        try {
            this.getChannelProcessor().processEventBatch(batch);
        }
        catch (Throwable t) {
            logger.error("Avro source " + this.getName() + ": Unable to process event batch. Exception follows.", t);
            this.sourceCounter.incrementChannelWriteFail();
            if (t instanceof Error) {
                throw (Error)t;
            }
            return Status.FAILED;
        }
        this.sourceCounter.incrementAppendBatchAcceptedCount();
        this.sourceCounter.addToEventAcceptedCount(events.size());
        return Status.OK;
    }

    private PatternRule generateRule(String patternRuleDefinition) throws FlumeException {
        int firstColonIndex = (patternRuleDefinition = patternRuleDefinition.trim()).indexOf(":");
        if (firstColonIndex == -1) {
            throw new FlumeException("Invalid ipFilter patternRule '" + patternRuleDefinition + "' should look like <'allow'  or 'deny'>:<'ip' or 'name'>:<pattern>");
        }
        String ruleAccessFlag = patternRuleDefinition.substring(0, firstColonIndex);
        int secondColonIndex = patternRuleDefinition.indexOf(":", firstColonIndex + 1);
        if (!ruleAccessFlag.equals("allow") && !ruleAccessFlag.equals("deny") || secondColonIndex == -1) {
            throw new FlumeException("Invalid ipFilter patternRule '" + patternRuleDefinition + "' should look like <'allow'  or 'deny'>:<'ip' or 'name'>:<pattern>");
        }
        String patternTypeFlag = patternRuleDefinition.substring(firstColonIndex + 1, secondColonIndex);
        if (!patternTypeFlag.equals("ip") && !patternTypeFlag.equals("name")) {
            throw new FlumeException("Invalid ipFilter patternRule '" + patternRuleDefinition + "' should look like <'allow'  or 'deny'>:<'ip' or 'name'>:<pattern>");
        }
        boolean isAllow = ruleAccessFlag.equals("allow");
        String patternRuleString = (patternTypeFlag.equals("ip") ? "i" : "n") + ":" + patternRuleDefinition.substring(secondColonIndex + 1);
        IpFilterRuleType ruleType = isAllow ? IpFilterRuleType.ACCEPT : IpFilterRuleType.REJECT;
        logger.info("Adding ipFilter PatternRule: {} {}", (Object)ruleType, (Object)patternRuleString);
        return new PatternRule(ruleType, patternRuleString);
    }
}

