/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.List;
import org.apache.flume.Context;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.FlumeException;
import org.apache.flume.Sink;
import org.apache.flume.conf.Configurable;
import org.apache.flume.lifecycle.LifecycleAware;
import org.apache.flume.sink.AbstractSinkProcessor;
import org.apache.flume.sink.AbstractSinkSelector;
import org.apache.flume.util.OrderSelector;
import org.apache.flume.util.RandomOrderSelector;
import org.apache.flume.util.RoundRobinOrderSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancingSinkProcessor
extends AbstractSinkProcessor {
    public static final String CONFIG_SELECTOR = "selector";
    public static final String CONFIG_SELECTOR_PREFIX = "selector.";
    public static final String CONFIG_BACKOFF = "backoff";
    public static final String SELECTOR_NAME_ROUND_ROBIN = "ROUND_ROBIN";
    public static final String SELECTOR_NAME_RANDOM = "RANDOM";
    public static final String SELECTOR_NAME_ROUND_ROBIN_BACKOFF = "ROUND_ROBIN_BACKOFF";
    public static final String SELECTOR_NAME_RANDOM_BACKOFF = "RANDOM_BACKOFF";
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadBalancingSinkProcessor.class);
    private SinkSelector selector;

    @Override
    public void configure(Context context) {
        Preconditions.checkState((this.getSinks().size() > 1 ? 1 : 0) != 0, (Object)"The LoadBalancingSinkProcessor cannot be used for a single sink. Please configure more than one sinks and try again.");
        String selectorTypeName = context.getString(CONFIG_SELECTOR, SELECTOR_NAME_ROUND_ROBIN);
        Boolean shouldBackOff = context.getBoolean(CONFIG_BACKOFF, Boolean.valueOf(false));
        this.selector = null;
        if (selectorTypeName.equalsIgnoreCase(SELECTOR_NAME_ROUND_ROBIN)) {
            this.selector = new RoundRobinSinkSelector(shouldBackOff);
        } else if (selectorTypeName.equalsIgnoreCase(SELECTOR_NAME_RANDOM)) {
            this.selector = new RandomOrderSinkSelector(shouldBackOff);
        } else {
            try {
                Class<?> klass = Class.forName(selectorTypeName);
                this.selector = (SinkSelector)klass.newInstance();
            }
            catch (Exception ex) {
                throw new FlumeException("Unable to instantiate sink selector: " + selectorTypeName, (Throwable)ex);
            }
        }
        this.selector.setSinks(this.getSinks());
        this.selector.configure(new Context(context.getSubProperties(CONFIG_SELECTOR_PREFIX)));
        LOGGER.debug("Sink selector: " + this.selector + " initialized");
    }

    @Override
    public void start() {
        super.start();
        this.selector.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.selector.stop();
    }

    @Override
    public Sink.Status process() throws EventDeliveryException {
        Sink.Status status = null;
        Iterator<Sink> sinkIterator = this.selector.createSinkIterator();
        while (sinkIterator.hasNext()) {
            Sink sink = sinkIterator.next();
            try {
                status = sink.process();
                break;
            }
            catch (Exception ex) {
                this.selector.informSinkFailed(sink);
                LOGGER.warn("Sink failed to consume event. Attempting next sink if available.", (Throwable)ex);
            }
        }
        if (status == null) {
            throw new EventDeliveryException("All configured sinks have failed");
        }
        return status;
    }

    private static class RandomOrderSinkSelector
    extends AbstractSinkSelector {
        private OrderSelector<Sink> selector;

        RandomOrderSinkSelector(boolean backoff) {
            this.selector = new RandomOrderSelector(backoff);
        }

        @Override
        public void configure(Context context) {
            super.configure(context);
            if (this.maxTimeOut != 0L) {
                this.selector.setMaxTimeOut(this.maxTimeOut);
            }
        }

        @Override
        public void setSinks(List<Sink> sinks) {
            this.selector.setObjects(sinks);
        }

        @Override
        public Iterator<Sink> createSinkIterator() {
            return this.selector.createIterator();
        }

        @Override
        public void informSinkFailed(Sink failedSink) {
            this.selector.informFailure((Object)failedSink);
        }
    }

    private static class RoundRobinSinkSelector
    extends AbstractSinkSelector {
        private OrderSelector<Sink> selector;

        RoundRobinSinkSelector(boolean backoff) {
            this.selector = new RoundRobinOrderSelector(backoff);
        }

        @Override
        public void configure(Context context) {
            super.configure(context);
            if (this.maxTimeOut != 0L) {
                this.selector.setMaxTimeOut(this.maxTimeOut);
            }
        }

        @Override
        public Iterator<Sink> createSinkIterator() {
            return this.selector.createIterator();
        }

        @Override
        public void setSinks(List<Sink> sinks) {
            this.selector.setObjects(sinks);
        }

        @Override
        public void informSinkFailed(Sink failedSink) {
            this.selector.informFailure((Object)failedSink);
        }
    }

    public static interface SinkSelector
    extends Configurable,
    LifecycleAware {
        public void setSinks(List<Sink> var1);

        public Iterator<Sink> createSinkIterator();

        public void informSinkFailed(Sink var1);
    }
}

