/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.lifecycle;

import java.util.List;
import org.apache.flume.lifecycle.LifecycleAware;
import org.apache.flume.lifecycle.LifecycleState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleController {
    private static final Logger logger = LoggerFactory.getLogger(LifecycleController.class);
    private static final long shortestSleepDuration = 50L;
    private static final int maxNumberOfChecks = 5;

    public static boolean waitForState(LifecycleAware delegate, LifecycleState state) throws InterruptedException {
        return LifecycleController.waitForState(delegate, state, 0L);
    }

    public static boolean waitForState(LifecycleAware delegate, LifecycleState state, long timeout) throws InterruptedException {
        return LifecycleController.waitForOneOf(delegate, new LifecycleState[]{state}, timeout);
    }

    public static boolean waitForOneOf(LifecycleAware delegate, LifecycleState[] states) throws InterruptedException {
        return LifecycleController.waitForOneOf(delegate, states, 0L);
    }

    public static boolean waitForOneOf(LifecycleAware delegate, LifecycleState[] states, long timeout) throws InterruptedException {
        if (logger.isDebugEnabled()) {
            logger.debug("Waiting for state {} for delegate:{} up to {}ms", new Object[]{states, delegate, timeout});
        }
        long sleepInterval = Math.max(50L, timeout / 5L);
        long deadLine = System.currentTimeMillis() + timeout;
        do {
            for (LifecycleState state : states) {
                if (!delegate.getLifecycleState().equals((Object)state)) continue;
                return true;
            }
            Thread.sleep(sleepInterval);
        } while (timeout == 0L || System.currentTimeMillis() < deadLine);
        logger.debug("Didn't see {} state(s) within timeout of {}ms", (Object)states, (Object)timeout);
        return false;
    }

    public static void stopAll(List<LifecycleAware> services) throws InterruptedException {
        for (LifecycleAware service : services) {
            LifecycleController.waitForOneOf(service, LifecycleState.STOP_OR_ERROR);
        }
    }
}

