/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.parameter;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.classmate.members.ResolvedMember;
import com.fasterxml.classmate.members.ResolvedMethod;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.RequestParameterBuilder;
import springfox.documentation.common.Compatibility;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Maps;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.ScalarTypes;
import springfox.documentation.schema.Types;
import springfox.documentation.schema.property.bean.AccessorsProvider;
import springfox.documentation.schema.property.field.FieldProvider;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.RequestParameter;
import springfox.documentation.spi.schema.AlternateTypeProvider;
import springfox.documentation.spi.schema.EnumTypeDeterminer;
import springfox.documentation.spi.service.ParameterMetadataAccessor;
import springfox.documentation.spi.service.contexts.ParameterExpansionContext;
import springfox.documentation.spring.web.plugins.DocumentationPluginsManager;
import springfox.documentation.spring.web.readers.parameter.ExpansionContext;
import springfox.documentation.spring.web.readers.parameter.ModelAttributeField;
import springfox.documentation.spring.web.readers.parameter.ModelAttributeParameterMetadataAccessor;
import springfox.documentation.spring.web.readers.parameter.ParameterTypeDeterminer;

@Component
public class ModelAttributeParameterExpander {
    private static final Logger LOG = LoggerFactory.getLogger(ModelAttributeParameterExpander.class);
    private final FieldProvider fields;
    private final AccessorsProvider accessors;
    private final EnumTypeDeterminer enumTypeDeterminer;
    @Autowired
    private DocumentationPluginsManager pluginsManager;

    @Autowired
    public ModelAttributeParameterExpander(FieldProvider fields, AccessorsProvider accessors, EnumTypeDeterminer enumTypeDeterminer) {
        this.fields = fields;
        this.accessors = accessors;
        this.enumTypeDeterminer = enumTypeDeterminer;
    }

    public List<Compatibility<Parameter, RequestParameter>> expand(ExpansionContext context) {
        ArrayList parameters = new ArrayList();
        Set<PropertyDescriptor> propertyDescriptors = this.propertyDescriptors(context.getParamType().getErasedType());
        Map<Method, PropertyDescriptor> propertyLookupByGetter = this.propertyDescriptorsByMethod(context.getParamType().getErasedType(), propertyDescriptors);
        Iterable getters = this.accessors.in(context.getParamType()).stream().filter(this.onlyValidGetters(propertyLookupByGetter.keySet())).collect(Collectors.toList());
        Map<String, ResolvedField> fieldsByName = StreamSupport.stream(this.fields.in(context.getParamType()).spliterator(), false).collect(Collectors.toMap(ResolvedMember::getName, Function.identity()));
        LOG.debug("Expanding parameter type: {}", (Object)context.getParamType());
        AlternateTypeProvider alternateTypeProvider = context.getAlternateTypeProvider();
        List<ModelAttributeField> attributes = this.allModelAttributes(propertyLookupByGetter, getters, fieldsByName, alternateTypeProvider, context.ignorableTypes());
        attributes.stream().filter(this.simpleType().negate()).filter(this.recursiveType(context).negate()).forEach(each -> {
            LOG.debug("Attempting to expand expandable property: {}", (Object)each.getName());
            parameters.addAll(this.expand(context.childContext(this.nestedParentName(context.getParentName(), (ModelAttributeField)each), each.getFieldType(), context.getOperationContext())));
        });
        Stream<ModelAttributeField> collectionTypes = attributes.stream().filter(this.isCollection().and(this.recursiveCollectionItemType(context.getParamType()).negate()));
        collectionTypes.forEachOrdered(each -> {
            LOG.debug("Attempting to expand collection/array field: {}", (Object)each.getName());
            ResolvedType itemType = Collections.collectionElementType((ResolvedType)each.getFieldType());
            if (itemType == null) {
                return;
            }
            if (ScalarTypes.builtInScalarType((Type)itemType).isPresent() || this.enumTypeDeterminer.isEnum(itemType.getErasedType())) {
                parameters.add(this.simpleFields(context.getParentName(), context, (ModelAttributeField)each));
            } else {
                ExpansionContext childContext = context.childContext(this.nestedParentName(context.getParentName(), (ModelAttributeField)each), itemType, context.getOperationContext());
                if (!context.hasSeenType(itemType)) {
                    parameters.addAll(this.expand(childContext));
                }
            }
        });
        Stream<ModelAttributeField> simpleFields = attributes.stream().filter(this.simpleType());
        simpleFields.forEach(each -> parameters.add(this.simpleFields(context.getParentName(), context, (ModelAttributeField)each)));
        return parameters.stream().filter(this.hiddenParameter().negate()).filter(this.voidParameters().negate()).collect(Collectors.toList());
    }

    private Predicate<Compatibility<Parameter, RequestParameter>> hiddenParameter() {
        return c -> c.getLegacy().map(Parameter::isHidden).orElse(false);
    }

    private List<ModelAttributeField> allModelAttributes(Map<Method, PropertyDescriptor> propertyLookupByGetter, Iterable<ResolvedMethod> getters, Map<String, ResolvedField> fieldsByName, AlternateTypeProvider alternateTypeProvider, Collection<Class> ignorables) {
        Stream<ModelAttributeField> modelAttributesFromGetters = StreamSupport.stream(getters.spliterator(), false).filter(method -> !this.ignored(alternateTypeProvider, (ResolvedMethod)method, ignorables)).map(this.toModelAttributeField(fieldsByName, propertyLookupByGetter, alternateTypeProvider));
        Stream<ModelAttributeField> modelAttributesFromFields = fieldsByName.values().stream().filter(ResolvedMember::isPublic).filter(ResolvedMember::isPublic).map(this.toModelAttributeField(alternateTypeProvider));
        return Stream.concat(modelAttributesFromFields, modelAttributesFromGetters).collect(Collectors.toList());
    }

    private boolean ignored(AlternateTypeProvider alternateTypeProvider, ResolvedMethod method, Collection<Class> ignorables) {
        boolean annotatedIgnorable = ignorables.stream().filter(Annotation.class::isAssignableFrom).anyMatch(annotation -> method.getAnnotations().asList().contains(annotation));
        return annotatedIgnorable || ignorables.contains(this.fieldType(alternateTypeProvider, method).getErasedType());
    }

    private Function<ResolvedField, ModelAttributeField> toModelAttributeField(AlternateTypeProvider alternateTypeProvider) {
        return input -> new ModelAttributeField(alternateTypeProvider.alternateFor(input.getType()), input.getName(), (ResolvedMember<?>)input, (ResolvedMember<?>)input);
    }

    private Predicate<Compatibility<Parameter, RequestParameter>> voidParameters() {
        return input -> ResolvedTypes.isVoid((ResolvedType)input.getLegacy().flatMap(Parameter::getType).orElse(null));
    }

    private Predicate<ModelAttributeField> recursiveCollectionItemType(ResolvedType paramType) {
        return input -> Objects.equals(Collections.collectionElementType((ResolvedType)input.getFieldType()), paramType);
    }

    private Compatibility<Parameter, RequestParameter> simpleFields(String parentName, ExpansionContext context, ModelAttributeField each) {
        LOG.debug("Attempting to expand field: {}", (Object)each);
        String dataTypeName = Optional.ofNullable(Types.typeNameFor((Type)each.getFieldType().getErasedType())).orElse(each.getFieldType().getErasedType().getSimpleName());
        LOG.debug("Building parameter for field: {}, with type: {}", (Object)each, (Object)each.getFieldType());
        ParameterExpansionContext parameterExpansionContext = new ParameterExpansionContext(dataTypeName, parentName, ParameterTypeDeterminer.determineScalarParameterType(context.getOperationContext().consumes(), context.getOperationContext().httpMethod()), (ParameterMetadataAccessor)new ModelAttributeParameterMetadataAccessor(each.annotatedElements(), each.getFieldType(), each.getName()), context.getDocumentationType(), new ParameterBuilder(), new RequestParameterBuilder());
        return this.pluginsManager.expandParameter(parameterExpansionContext);
    }

    private Predicate<ModelAttributeField> recursiveType(ExpansionContext context) {
        return input -> context.hasSeenType(input.getFieldType());
    }

    private Predicate<ModelAttributeField> simpleType() {
        return this.isCollection().negate().and(this.isMap().negate()).and(this.belongsToJavaPackage().or(this.isBaseType()).or(this.isEnum()));
    }

    private Predicate<ModelAttributeField> isCollection() {
        return input -> Collections.isContainerType((ResolvedType)input.getFieldType());
    }

    private Predicate<ModelAttributeField> isMap() {
        return input -> Maps.isMapType((ResolvedType)input.getFieldType());
    }

    private Predicate<ModelAttributeField> isEnum() {
        return input -> this.enumTypeDeterminer.isEnum(input.getFieldType().getErasedType());
    }

    private Predicate<ModelAttributeField> belongsToJavaPackage() {
        return input -> ClassUtils.getPackageName((Class)input.getFieldType().getErasedType()).startsWith("java.lang");
    }

    private Predicate<ModelAttributeField> isBaseType() {
        return input -> ScalarTypes.builtInScalarType((Type)input.getFieldType()).isPresent() || input.getFieldType().isPrimitive();
    }

    private Function<ResolvedMethod, ModelAttributeField> toModelAttributeField(Map<String, ResolvedField> fieldsByName, Map<Method, PropertyDescriptor> propertyLookupByGetter, AlternateTypeProvider alternateTypeProvider) {
        return input -> {
            String name = ((PropertyDescriptor)propertyLookupByGetter.get(input.getRawMember())).getName();
            return new ModelAttributeField(this.fieldType(alternateTypeProvider, (ResolvedMethod)input), name, (ResolvedMember<?>)input, (ResolvedMember<?>)((ResolvedMember)fieldsByName.get(name)));
        };
    }

    private Predicate<ResolvedMethod> onlyValidGetters(Set<Method> methods) {
        return input -> methods.contains(input.getRawMember());
    }

    private String nestedParentName(String parentName, ModelAttributeField attribute) {
        String name = attribute.getName();
        ResolvedType fieldType = attribute.getFieldType();
        if (Collections.isContainerType((ResolvedType)fieldType) && !ScalarTypes.builtInScalarType((Type)Collections.collectionElementType((ResolvedType)fieldType)).isPresent()) {
            name = name + "[0]";
        }
        if (StringUtils.isEmpty((Object)parentName)) {
            return name;
        }
        return String.format("%s.%s", parentName, name);
    }

    private ResolvedType fieldType(AlternateTypeProvider alternateTypeProvider, ResolvedMethod method) {
        return alternateTypeProvider.alternateFor(method.getType());
    }

    private Set<PropertyDescriptor> propertyDescriptors(Class<?> clazz) {
        try {
            return new HashSet<PropertyDescriptor>(Arrays.asList(this.getBeanInfo(clazz).getPropertyDescriptors()));
        }
        catch (IntrospectionException e) {
            LOG.warn(String.format("Failed to get bean properties on (%s)", clazz), (Throwable)e);
            return java.util.Collections.emptySet();
        }
    }

    private Map<Method, PropertyDescriptor> propertyDescriptorsByMethod(Class<?> clazz, Set<PropertyDescriptor> propertyDescriptors) {
        return propertyDescriptors.stream().filter(input -> input.getReadMethod() != null && !clazz.isAssignableFrom(Collection.class) && !"isEmpty".equals(input.getReadMethod().getName())).collect(Collectors.toMap(PropertyDescriptor::getReadMethod, Function.identity()));
    }

    BeanInfo getBeanInfo(Class<?> clazz) throws IntrospectionException {
        return Introspector.getBeanInfo(clazz);
    }

    public DocumentationPluginsManager getPluginsManager() {
        return this.pluginsManager;
    }

    void setPluginsManager(DocumentationPluginsManager pluginsManager) {
        this.pluginsManager = pluginsManager;
    }
}

