/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.date4j;

import hirondelle.date4j.DateTimeFormatter;
import hirondelle.date4j.DateTimeInterval;
import hirondelle.date4j.DateTimeParser;
import hirondelle.date4j.ModelUtil;
import hirondelle.date4j.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public final class DateTime
implements Comparable<DateTime>,
Serializable {
    private String fDateTime;
    private Integer fYear;
    private Integer fMonth;
    private Integer fDay;
    private Integer fHour;
    private Integer fMinute;
    private Integer fSecond;
    private Integer fNanosecond;
    private boolean fIsAlreadyParsed;
    private int fHashCode;
    private static final int EQUAL = 0;
    private static int EPOCH_MODIFIED_JD = 2400000;
    private static final int MILLION = 1000000;
    private static final long serialVersionUID = -1300068157085493891L;

    public DateTime(String aDateTime) {
        this.fIsAlreadyParsed = false;
        if (aDateTime == null) {
            throw new IllegalArgumentException("String passed to DateTime constructor is null. You can use an empty string, but not a null reference.");
        }
        this.fDateTime = aDateTime;
    }

    public static boolean isParseable(String aCandidateDateTime) {
        boolean result = true;
        try {
            DateTime dt = new DateTime(aCandidateDateTime);
            dt.ensureParsed();
        }
        catch (RuntimeException ex) {
            result = false;
        }
        return result;
    }

    public DateTime(Integer aYear, Integer aMonth, Integer aDay, Integer aHour, Integer aMinute, Integer aSecond, Integer aNanoseconds) {
        this.fIsAlreadyParsed = true;
        this.fYear = aYear;
        this.fMonth = aMonth;
        this.fDay = aDay;
        this.fHour = aHour;
        this.fMinute = aMinute;
        this.fSecond = aSecond;
        this.fNanosecond = aNanoseconds;
        this.validateState();
    }

    public static DateTime forDateOnly(Integer aYear, Integer aMonth, Integer aDay) {
        return new DateTime(aYear, aMonth, aDay, null, null, null, null);
    }

    public static DateTime forTimeOnly(Integer aHour, Integer aMinute, Integer aSecond, Integer aNanoseconds) {
        return new DateTime(null, null, null, aHour, aMinute, aSecond, aNanoseconds);
    }

    public static DateTime forInstant(long aMilliseconds, TimeZone aTimeZone) {
        GregorianCalendar calendar = new GregorianCalendar(aTimeZone);
        calendar.setTimeInMillis(aMilliseconds);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        int milliseconds = calendar.get(14);
        int nanoseconds = milliseconds * 1000 * 1000;
        return new DateTime(year, month, day, hour, minute, second, nanoseconds);
    }

    public long getMilliseconds(TimeZone aTimeZone) {
        Integer year = this.getYear();
        Integer month = this.getMonth();
        Integer day = this.getDay();
        Integer hour = this.getHour() == null ? 0 : this.getHour();
        Integer minute = this.getMinute() == null ? 0 : this.getMinute();
        Integer second = this.getSecond() == null ? 0 : this.getSecond();
        Integer nanos = this.getNanoseconds() == null ? 0 : this.getNanoseconds();
        GregorianCalendar calendar = new GregorianCalendar(aTimeZone);
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, nanos / 1000000);
        return calendar.getTimeInMillis();
    }

    public static DateTime forInstantNanos(long aNanoseconds, TimeZone aTimeZone) {
        long millis = aNanoseconds / 1000000L;
        long nanosRemaining = aNanoseconds % 1000000L;
        if (aNanoseconds < 0L) {
            --millis;
            nanosRemaining = 1000000L + nanosRemaining;
        }
        GregorianCalendar calendar = new GregorianCalendar(aTimeZone);
        calendar.setTimeInMillis(millis);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        int milliseconds = calendar.get(14);
        DateTime withoutNanos = new DateTime(year, month, day, hour, minute, second, milliseconds * 1000000);
        DateTime withNanos = withoutNanos.plus(0, 0, 0, 0, 0, 0, (int)nanosRemaining, DayOverflow.Spillover);
        return withNanos;
    }

    public long getNanosecondsInstant(TimeZone aTimeZone) {
        Integer year = this.getYear();
        Integer month = this.getMonth();
        Integer day = this.getDay();
        Integer hour = this.getHour() == null ? 0 : this.getHour();
        Integer minute = this.getMinute() == null ? 0 : this.getMinute();
        Integer second = this.getSecond() == null ? 0 : this.getSecond();
        Integer nanos = this.getNanoseconds() == null ? 0 : this.getNanoseconds();
        int millis = nanos / 1000000;
        int nanosRemaining = nanos % 1000000;
        GregorianCalendar calendar = new GregorianCalendar(aTimeZone);
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, millis);
        long baseResult = calendar.getTimeInMillis() * 1000000L;
        return baseResult + (long)nanosRemaining;
    }

    public String getRawDateString() {
        return this.fDateTime;
    }

    public Integer getYear() {
        this.ensureParsed();
        return this.fYear;
    }

    public Integer getMonth() {
        this.ensureParsed();
        return this.fMonth;
    }

    public Integer getDay() {
        this.ensureParsed();
        return this.fDay;
    }

    public Integer getHour() {
        this.ensureParsed();
        return this.fHour;
    }

    public Integer getMinute() {
        this.ensureParsed();
        return this.fMinute;
    }

    public Integer getSecond() {
        this.ensureParsed();
        return this.fSecond;
    }

    public Integer getNanoseconds() {
        this.ensureParsed();
        return this.fNanosecond;
    }

    public Integer getModifiedJulianDayNumber() {
        this.ensureHasYearMonthDay();
        int result = this.calculateJulianDayNumberAtNoon() - 1 - EPOCH_MODIFIED_JD;
        return result;
    }

    public Integer getWeekDay() {
        this.ensureHasYearMonthDay();
        int dayNumber = this.calculateJulianDayNumberAtNoon() + 1;
        int index = dayNumber % 7;
        return index + 1;
    }

    public Integer getDayOfYear() {
        this.ensureHasYearMonthDay();
        int k = this.isLeapYear() != false ? 1 : 2;
        Integer result = 275 * this.fMonth / 9 - k * ((this.fMonth + 9) / 12) + this.fDay - 30;
        return result;
    }

    public Boolean isLeapYear() {
        this.ensureParsed();
        Boolean result = null;
        if (!this.isPresent(this.fYear)) {
            throw new MissingItem("Year is absent. Cannot determine if leap year.");
        }
        result = DateTime.isLeapYear(this.fYear);
        return result;
    }

    public int getNumDaysInMonth() {
        this.ensureHasYearMonthDay();
        return DateTime.getNumDaysInMonth(this.fYear, this.fMonth);
    }

    public Integer getWeekIndex(DateTime aStartingFromDate) {
        this.ensureHasYearMonthDay();
        aStartingFromDate.ensureHasYearMonthDay();
        int diff = this.getModifiedJulianDayNumber() - aStartingFromDate.getModifiedJulianDayNumber();
        return diff / 7 + 1;
    }

    public Integer getWeekIndex() {
        DateTime start = DateTime.forDateOnly(2000, 1, 2);
        return this.getWeekIndex(start);
    }

    public boolean isSameDayAs(DateTime aThat) {
        boolean result = false;
        this.ensureHasYearMonthDay();
        aThat.ensureHasYearMonthDay();
        result = this.fYear.equals(aThat.fYear) && this.fMonth.equals(aThat.fMonth) && this.fDay.equals(aThat.fDay);
        return result;
    }

    public boolean lt(DateTime aThat) {
        return this.compareTo(aThat) < 0;
    }

    public boolean lteq(DateTime aThat) {
        return this.compareTo(aThat) < 0 || this.equals(aThat);
    }

    public boolean gt(DateTime aThat) {
        return this.compareTo(aThat) > 0;
    }

    public boolean gteq(DateTime aThat) {
        return this.compareTo(aThat) > 0 || this.equals(aThat);
    }

    public Unit getPrecision() {
        this.ensureParsed();
        Unit result = null;
        if (this.isPresent(this.fNanosecond)) {
            result = Unit.NANOSECONDS;
        } else if (this.isPresent(this.fSecond)) {
            result = Unit.SECOND;
        } else if (this.isPresent(this.fMinute)) {
            result = Unit.MINUTE;
        } else if (this.isPresent(this.fHour)) {
            result = Unit.HOUR;
        } else if (this.isPresent(this.fDay)) {
            result = Unit.DAY;
        } else if (this.isPresent(this.fMonth)) {
            result = Unit.MONTH;
        } else if (this.isPresent(this.fYear)) {
            result = Unit.YEAR;
        }
        return result;
    }

    public DateTime truncate(Unit aPrecision) {
        this.ensureParsed();
        DateTime result = null;
        if (Unit.NANOSECONDS == aPrecision) {
            throw new IllegalArgumentException("It makes no sense to truncate to nanosecond precision, since that's the highest precision available.");
        }
        if (Unit.SECOND == aPrecision) {
            result = new DateTime(this.fYear, this.fMonth, this.fDay, this.fHour, this.fMinute, this.fSecond, null);
        } else if (Unit.MINUTE == aPrecision) {
            result = new DateTime(this.fYear, this.fMonth, this.fDay, this.fHour, this.fMinute, null, null);
        } else if (Unit.HOUR == aPrecision) {
            result = new DateTime(this.fYear, this.fMonth, this.fDay, this.fHour, null, null, null);
        } else if (Unit.DAY == aPrecision) {
            result = new DateTime(this.fYear, this.fMonth, this.fDay, null, null, null, null);
        } else if (Unit.MONTH == aPrecision) {
            result = new DateTime(this.fYear, this.fMonth, null, null, null, null, null);
        } else if (Unit.YEAR == aPrecision) {
            result = new DateTime(this.fYear, null, null, null, null, null, null);
        }
        return result;
    }

    public boolean unitsAllPresent(Unit ... aUnits) {
        boolean result = true;
        this.ensureParsed();
        for (Unit unit : aUnits) {
            if (Unit.NANOSECONDS == unit) {
                result = result && this.fNanosecond != null;
                continue;
            }
            if (Unit.SECOND == unit) {
                result = result && this.fSecond != null;
                continue;
            }
            if (Unit.MINUTE == unit) {
                result = result && this.fMinute != null;
                continue;
            }
            if (Unit.HOUR == unit) {
                result = result && this.fHour != null;
                continue;
            }
            if (Unit.DAY == unit) {
                result = result && this.fDay != null;
                continue;
            }
            if (Unit.MONTH == unit) {
                result = result && this.fMonth != null;
                continue;
            }
            if (Unit.YEAR != unit) continue;
            result = result && this.fYear != null;
        }
        return result;
    }

    public boolean hasYearMonthDay() {
        return this.unitsAllPresent(Unit.YEAR, Unit.MONTH, Unit.DAY);
    }

    public boolean hasHourMinuteSecond() {
        return this.unitsAllPresent(Unit.HOUR, Unit.MINUTE, Unit.SECOND);
    }

    public boolean unitsAllAbsent(Unit ... aUnits) {
        boolean result = true;
        this.ensureParsed();
        for (Unit unit : aUnits) {
            if (Unit.NANOSECONDS == unit) {
                result = result && this.fNanosecond == null;
                continue;
            }
            if (Unit.SECOND == unit) {
                result = result && this.fSecond == null;
                continue;
            }
            if (Unit.MINUTE == unit) {
                result = result && this.fMinute == null;
                continue;
            }
            if (Unit.HOUR == unit) {
                result = result && this.fHour == null;
                continue;
            }
            if (Unit.DAY == unit) {
                result = result && this.fDay == null;
                continue;
            }
            if (Unit.MONTH == unit) {
                result = result && this.fMonth == null;
                continue;
            }
            if (Unit.YEAR != unit) continue;
            result = result && this.fYear == null;
        }
        return result;
    }

    public DateTime getStartOfDay() {
        this.ensureHasYearMonthDay();
        return this.getStartEndDateTime(this.fDay, 0, 0, 0, 0);
    }

    public DateTime getEndOfDay() {
        this.ensureHasYearMonthDay();
        return this.getStartEndDateTime(this.fDay, 23, 59, 59, 999999999);
    }

    public DateTime getStartOfMonth() {
        this.ensureHasYearMonthDay();
        return this.getStartEndDateTime(1, 0, 0, 0, 0);
    }

    public DateTime getEndOfMonth() {
        this.ensureHasYearMonthDay();
        return this.getStartEndDateTime(this.getNumDaysInMonth(), 23, 59, 59, 999999999);
    }

    public DateTime plus(Integer aNumYears, Integer aNumMonths, Integer aNumDays, Integer aNumHours, Integer aNumMinutes, Integer aNumSeconds, Integer aNumNanoseconds, DayOverflow aDayOverflow) {
        DateTimeInterval interval = new DateTimeInterval(this, aDayOverflow);
        return interval.plus(aNumYears, aNumMonths, aNumDays, aNumHours, aNumMinutes, aNumSeconds, aNumNanoseconds);
    }

    public DateTime minus(Integer aNumYears, Integer aNumMonths, Integer aNumDays, Integer aNumHours, Integer aNumMinutes, Integer aNumSeconds, Integer aNumNanoseconds, DayOverflow aDayOverflow) {
        DateTimeInterval interval = new DateTimeInterval(this, aDayOverflow);
        return interval.minus(aNumYears, aNumMonths, aNumDays, aNumHours, aNumMinutes, aNumSeconds, aNumNanoseconds);
    }

    public DateTime plusDays(Integer aNumDays) {
        this.ensureHasYearMonthDay();
        int thisJDAtNoon = this.getModifiedJulianDayNumber() + 1 + EPOCH_MODIFIED_JD;
        int resultJD = thisJDAtNoon + aNumDays;
        DateTime datePortion = DateTime.fromJulianDayNumberAtNoon(resultJD);
        return new DateTime(datePortion.getYear(), datePortion.getMonth(), datePortion.getDay(), this.fHour, this.fMinute, this.fSecond, this.fNanosecond);
    }

    public DateTime minusDays(Integer aNumDays) {
        return this.plusDays(-1 * aNumDays);
    }

    public int numDaysFrom(DateTime aThat) {
        return aThat.getModifiedJulianDayNumber() - this.getModifiedJulianDayNumber();
    }

    public long numSecondsFrom(DateTime aThat) {
        long result = 0L;
        aThat.ensureParsed();
        if (this.hasYearMonthDay() && aThat.hasYearMonthDay()) {
            result = this.numDaysFrom(aThat) * 86400;
        }
        result = result - (long)this.numSecondsInTimePortion() + (long)aThat.numSecondsInTimePortion();
        return result;
    }

    public String format(String aFormat) {
        DateTimeFormatter format = new DateTimeFormatter(aFormat);
        return format.format(this);
    }

    public String format(String aFormat, Locale aLocale) {
        DateTimeFormatter format = new DateTimeFormatter(aFormat, aLocale);
        return format.format(this);
    }

    public String format(String aFormat, List<String> aMonths, List<String> aWeekdays, List<String> aAmPmIndicators) {
        DateTimeFormatter format = new DateTimeFormatter(aFormat, aMonths, aWeekdays, aAmPmIndicators);
        return format.format(this);
    }

    public static DateTime now(TimeZone aTimeZone) {
        return DateTime.forInstant(System.currentTimeMillis(), aTimeZone);
    }

    public static DateTime today(TimeZone aTimeZone) {
        DateTime result = DateTime.now(aTimeZone);
        return result.truncate(Unit.DAY);
    }

    public boolean isInTheFuture(TimeZone aTimeZone) {
        return DateTime.now(aTimeZone).lt(this);
    }

    public boolean isInThePast(TimeZone aTimeZone) {
        return DateTime.now(aTimeZone).gt(this);
    }

    public DateTime changeTimeZone(TimeZone aFromTimeZone, TimeZone aToTimeZone) {
        DateTime result = null;
        this.ensureHasYearMonthDay();
        if (this.unitsAllAbsent(Unit.HOUR)) {
            throw new IllegalArgumentException("DateTime does not include the hour. Cannot change the time zone if no hour is present.");
        }
        GregorianCalendar fromDate = new GregorianCalendar(aFromTimeZone);
        fromDate.set(1, this.getYear());
        fromDate.set(2, this.getMonth() - 1);
        fromDate.set(5, this.getDay());
        fromDate.set(11, this.getHour());
        if (this.getMinute() != null) {
            fromDate.set(12, this.getMinute());
        } else {
            fromDate.set(12, 0);
        }
        fromDate.set(13, 0);
        fromDate.set(14, 0);
        GregorianCalendar toDate = new GregorianCalendar(aToTimeZone);
        toDate.setTimeInMillis(fromDate.getTimeInMillis());
        Integer minute = this.getMinute() != null ? Integer.valueOf(toDate.get(12)) : null;
        result = new DateTime(toDate.get(1), toDate.get(2) + 1, toDate.get(5), toDate.get(11), minute, this.getSecond(), this.getNanoseconds());
        return result;
    }

    @Override
    public int compareTo(DateTime aThat) {
        if (this == aThat) {
            return 0;
        }
        this.ensureParsed();
        aThat.ensureParsed();
        ModelUtil.NullsGo nullsGo = ModelUtil.NullsGo.FIRST;
        int comparison = ModelUtil.comparePossiblyNull(this.fYear, aThat.fYear, nullsGo);
        if (comparison != 0) {
            return comparison;
        }
        comparison = ModelUtil.comparePossiblyNull(this.fMonth, aThat.fMonth, nullsGo);
        if (comparison != 0) {
            return comparison;
        }
        comparison = ModelUtil.comparePossiblyNull(this.fDay, aThat.fDay, nullsGo);
        if (comparison != 0) {
            return comparison;
        }
        comparison = ModelUtil.comparePossiblyNull(this.fHour, aThat.fHour, nullsGo);
        if (comparison != 0) {
            return comparison;
        }
        comparison = ModelUtil.comparePossiblyNull(this.fMinute, aThat.fMinute, nullsGo);
        if (comparison != 0) {
            return comparison;
        }
        comparison = ModelUtil.comparePossiblyNull(this.fSecond, aThat.fSecond, nullsGo);
        if (comparison != 0) {
            return comparison;
        }
        comparison = ModelUtil.comparePossiblyNull(this.fNanosecond, aThat.fNanosecond, nullsGo);
        if (comparison != 0) {
            return comparison;
        }
        return 0;
    }

    public boolean equals(Object aThat) {
        this.ensureParsed();
        Boolean result = ModelUtil.quickEquals(this, aThat);
        if (result == null) {
            DateTime that = (DateTime)aThat;
            that.ensureParsed();
            result = ModelUtil.equalsFor(this.getSignificantFields(), that.getSignificantFields());
        }
        return result;
    }

    public int hashCode() {
        if (this.fHashCode == 0) {
            this.ensureParsed();
            this.fHashCode = ModelUtil.hashCodeFor(this.getSignificantFields());
        }
        return this.fHashCode;
    }

    public String toString() {
        String result = "";
        if (Util.textHasContent(this.fDateTime)) {
            result = this.fDateTime;
        } else {
            String format = this.calcToStringFormat();
            if (format != null) {
                result = this.format(this.calcToStringFormat());
            } else {
                StringBuilder builder = new StringBuilder();
                this.addToString("Y", this.fYear, builder);
                this.addToString("M", this.fMonth, builder);
                this.addToString("D", this.fDay, builder);
                this.addToString("h", this.fHour, builder);
                this.addToString("m", this.fMinute, builder);
                this.addToString("s", this.fSecond, builder);
                this.addToString("f", this.fNanosecond, builder);
                result = builder.toString().trim();
            }
        }
        return result;
    }

    void ensureParsed() {
        if (!this.fIsAlreadyParsed) {
            this.parseDateTimeText();
        }
    }

    static Integer getNumDaysInMonth(Integer aYear, Integer aMonth) {
        Integer result = null;
        if (aYear != null && aMonth != null) {
            if (aMonth == 1) {
                result = 31;
            } else if (aMonth == 2) {
                result = DateTime.isLeapYear(aYear) ? 29 : 28;
            } else if (aMonth == 3) {
                result = 31;
            } else if (aMonth == 4) {
                result = 30;
            } else if (aMonth == 5) {
                result = 31;
            } else if (aMonth == 6) {
                result = 30;
            } else if (aMonth == 7) {
                result = 31;
            } else if (aMonth == 8) {
                result = 31;
            } else if (aMonth == 9) {
                result = 30;
            } else if (aMonth == 10) {
                result = 31;
            } else if (aMonth == 11) {
                result = 30;
            } else if (aMonth == 12) {
                result = 31;
            } else {
                throw new AssertionError((Object)("Month is out of range 1..12:" + aMonth));
            }
        }
        return result;
    }

    static DateTime fromJulianDayNumberAtNoon(int aJDAtNoon) {
        int l = aJDAtNoon + 68569;
        int n = 4 * l / 146097;
        int i = 4000 * ((l -= (146097 * n + 3) / 4) + 1) / 1461001;
        l = l - 1461 * i / 4 + 31;
        int j = 80 * l / 2447;
        int d = l - 2447 * j / 80;
        l = j / 11;
        int m = j + 2 - 12 * l;
        int y = 100 * (n - 49) + i + l;
        return DateTime.forDateOnly(y, m, d);
    }

    private int calculateJulianDayNumberAtNoon() {
        int y = this.fYear;
        int m = this.fMonth;
        int d = this.fDay;
        int result = 1461 * (y + 4800 + (m - 14) / 12) / 4 + 367 * (m - 2 - 12 * ((m - 14) / 12)) / 12 - 3 * ((y + 4900 + (m - 14) / 12) / 100) / 4 + d - 32075;
        return result;
    }

    private void ensureHasYearMonthDay() {
        this.ensureParsed();
        if (!this.hasYearMonthDay()) {
            throw new MissingItem("DateTime does not include year/month/day.");
        }
    }

    private int numSecondsInTimePortion() {
        int result = 0;
        if (this.fSecond != null) {
            result += this.fSecond.intValue();
        }
        if (this.fMinute != null) {
            result += 60 * this.fMinute;
        }
        if (this.fHour != null) {
            result += 3600 * this.fHour;
        }
        return result;
    }

    private void validateState() {
        this.checkRange(this.fYear, 1, 9999, "Year");
        this.checkRange(this.fMonth, 1, 12, "Month");
        this.checkRange(this.fDay, 1, 31, "Day");
        this.checkRange(this.fHour, 0, 23, "Hour");
        this.checkRange(this.fMinute, 0, 59, "Minute");
        this.checkRange(this.fSecond, 0, 59, "Second");
        this.checkRange(this.fNanosecond, 0, 999999999, "Nanosecond");
        this.checkNumDaysInMonth(this.fYear, this.fMonth, this.fDay);
    }

    private void checkRange(Integer aValue, int aMin, int aMax, String aName) {
        if (aValue != null && (aValue < aMin || aValue > aMax)) {
            throw new ItemOutOfRange(aName + " is not in the range " + aMin + ".." + aMax + ". Value is:" + aValue);
        }
    }

    private void checkNumDaysInMonth(Integer aYear, Integer aMonth, Integer aDay) {
        if (this.hasYearMonthDay(aYear, aMonth, aDay) && aDay > DateTime.getNumDaysInMonth(aYear, aMonth)) {
            throw new ItemOutOfRange("The day-of-the-month value '" + aDay + "' exceeds the number of days in the month: " + DateTime.getNumDaysInMonth(aYear, aMonth));
        }
    }

    private void parseDateTimeText() {
        DateTimeParser parser = new DateTimeParser();
        DateTime dateTime = parser.parse(this.fDateTime);
        this.fYear = dateTime.fYear;
        this.fMonth = dateTime.fMonth;
        this.fDay = dateTime.fDay;
        this.fHour = dateTime.fHour;
        this.fMinute = dateTime.fMinute;
        this.fSecond = dateTime.fSecond;
        this.fNanosecond = dateTime.fNanosecond;
        this.validateState();
    }

    private boolean hasYearMonthDay(Integer aYear, Integer aMonth, Integer aDay) {
        return this.isPresent(aYear, aMonth, aDay);
    }

    private static boolean isLeapYear(Integer aYear) {
        boolean result = false;
        if (aYear % 100 == 0) {
            if (aYear % 400 == 0) {
                result = true;
            }
        } else if (aYear % 4 == 0) {
            result = true;
        }
        return result;
    }

    private Object[] getSignificantFields() {
        return new Object[]{this.fYear, this.fMonth, this.fDay, this.fHour, this.fMinute, this.fSecond, this.fNanosecond};
    }

    private void addToString(String aName, Object aValue, StringBuilder aBuilder) {
        aBuilder.append(aName + ":" + String.valueOf(aValue) + " ");
    }

    private boolean isPresent(Object ... aItems) {
        boolean result = true;
        for (Object item : aItems) {
            if (item != null) continue;
            result = false;
            break;
        }
        return result;
    }

    private DateTime getStartEndDateTime(Integer aDay, Integer aHour, Integer aMinute, Integer aSecond, Integer aNanosecond) {
        this.ensureHasYearMonthDay();
        return new DateTime(this.fYear, this.fMonth, aDay, aHour, aMinute, aSecond, aNanosecond);
    }

    private String calcToStringFormat() {
        String result = null;
        if (this.unitsAllPresent(Unit.YEAR) && this.unitsAllAbsent(Unit.MONTH, Unit.DAY, Unit.HOUR, Unit.MINUTE, Unit.SECOND, Unit.NANOSECONDS)) {
            result = "YYYY";
        } else if (this.unitsAllPresent(Unit.YEAR, Unit.MONTH) && this.unitsAllAbsent(Unit.DAY, Unit.HOUR, Unit.MINUTE, Unit.SECOND, Unit.NANOSECONDS)) {
            result = "YYYY-MM";
        } else if (this.unitsAllPresent(Unit.YEAR, Unit.MONTH, Unit.DAY) && this.unitsAllAbsent(Unit.HOUR, Unit.MINUTE, Unit.SECOND, Unit.NANOSECONDS)) {
            result = "YYYY-MM-DD";
        } else if (this.unitsAllPresent(Unit.YEAR, Unit.MONTH, Unit.DAY, Unit.HOUR) && this.unitsAllAbsent(Unit.MINUTE, Unit.SECOND, Unit.NANOSECONDS)) {
            result = "YYYY-MM-DD hh";
        } else if (this.unitsAllPresent(Unit.YEAR, Unit.MONTH, Unit.DAY, Unit.HOUR, Unit.MINUTE) && this.unitsAllAbsent(Unit.SECOND, Unit.NANOSECONDS)) {
            result = "YYYY-MM-DD hh:mm";
        } else if (this.unitsAllPresent(Unit.YEAR, Unit.MONTH, Unit.DAY, Unit.HOUR, Unit.MINUTE, Unit.SECOND) && this.unitsAllAbsent(Unit.NANOSECONDS)) {
            result = "YYYY-MM-DD hh:mm:ss";
        } else if (this.unitsAllPresent(Unit.YEAR, Unit.MONTH, Unit.DAY, Unit.HOUR, Unit.MINUTE, Unit.SECOND, Unit.NANOSECONDS)) {
            result = "YYYY-MM-DD hh:mm:ss.fffffffff";
        } else if (this.unitsAllAbsent(Unit.YEAR, Unit.MONTH, Unit.DAY) && this.unitsAllPresent(Unit.HOUR, Unit.MINUTE, Unit.SECOND, Unit.NANOSECONDS)) {
            result = "hh:mm:ss.fffffffff";
        } else if (this.unitsAllAbsent(Unit.YEAR, Unit.MONTH, Unit.DAY, Unit.NANOSECONDS) && this.unitsAllPresent(Unit.HOUR, Unit.MINUTE, Unit.SECOND)) {
            result = "hh:mm:ss";
        } else if (this.unitsAllAbsent(Unit.YEAR, Unit.MONTH, Unit.DAY, Unit.SECOND, Unit.NANOSECONDS) && this.unitsAllPresent(Unit.HOUR, Unit.MINUTE)) {
            result = "hh:mm";
        }
        return result;
    }

    private void readObject(ObjectInputStream aInputStream) throws ClassNotFoundException, IOException {
        aInputStream.defaultReadObject();
        this.validateState();
    }

    private void writeObject(ObjectOutputStream aOutputStream) throws IOException {
        aOutputStream.defaultWriteObject();
    }

    static final class MissingItem
    extends RuntimeException {
        private static final long serialVersionUID = -7359967338896127755L;

        MissingItem(String aMessage) {
            super(aMessage);
        }
    }

    static final class ItemOutOfRange
    extends RuntimeException {
        private static final long serialVersionUID = 4760138291907517660L;

        ItemOutOfRange(String aMessage) {
            super(aMessage);
        }
    }

    public static enum DayOverflow {
        LastDay,
        FirstDay,
        Spillover,
        Abort;

    }

    public static enum Unit {
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        SECOND,
        NANOSECONDS;

    }
}

