/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sources.reader;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.metrics.AgentMetricItem;
import org.apache.inlong.agent.metrics.AgentMetricItemSet;
import org.apache.inlong.agent.plugin.Reader;
import org.apache.inlong.agent.pojo.DebeziumOffset;
import org.apache.inlong.agent.utils.DebeziumOffsetSerializer;
import org.apache.inlong.common.metric.MetricItemSet;
import org.apache.inlong.common.metric.MetricRegister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReader
implements Reader {
    protected static final AtomicLong METRIC_INDEX = new AtomicLong(0L);
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractReader.class);
    protected String inlongGroupId;
    protected String inlongStreamId;
    protected AgentMetricItemSet metricItemSet;
    protected AgentMetricItem readerMetric;
    protected String metricName;
    protected Map<String, String> dimensions;

    public void init(JobProfile jobConf) {
        this.inlongGroupId = jobConf.get("proxy.inlongGroupId", "default_inlong_group_id");
        this.inlongStreamId = jobConf.get("proxy.inlongStreamId", "default_inlong_stream_id");
        this.dimensions = new HashMap<String, String>();
        this.dimensions.put("pluginId", this.getClass().getSimpleName());
        this.dimensions.put("inlongGroupId", this.inlongGroupId);
        this.dimensions.put("inlongStreamId", this.inlongStreamId);
        this.metricName = String.join((CharSequence)"-", this.getClass().getSimpleName(), String.valueOf(METRIC_INDEX.incrementAndGet()));
        this.metricItemSet = new AgentMetricItemSet(this.metricName);
        MetricRegister.register((MetricItemSet)this.metricItemSet);
        this.readerMetric = (AgentMetricItem)this.metricItemSet.findMetricItem(this.dimensions);
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String serializeOffset(String server, String file, String pos) {
        HashMap<String, String> sourceOffset = new HashMap<String, String>();
        sourceOffset.put("file", file);
        sourceOffset.put("pos", pos);
        DebeziumOffset specificOffset = new DebeziumOffset();
        specificOffset.setSourceOffset(sourceOffset);
        HashMap<String, String> sourcePartition = new HashMap<String, String>();
        sourcePartition.put("server", server);
        specificOffset.setSourcePartition(sourcePartition);
        byte[] serializedOffset = new byte[]{};
        try {
            serializedOffset = DebeziumOffsetSerializer.INSTANCE.serialize(specificOffset);
        }
        catch (IOException e) {
            LOGGER.error("serialize offset message error", (Throwable)e);
        }
        return new String(serializedOffset, StandardCharsets.UTF_8);
    }
}

