/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sources;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.metrics.AgentMetricItem;
import org.apache.inlong.agent.metrics.AgentMetricItemSet;
import org.apache.inlong.agent.plugin.Source;
import org.apache.inlong.common.metric.MetricItemSet;
import org.apache.inlong.common.metric.MetricRegister;

public abstract class AbstractSource
implements Source {
    protected String inlongGroupId;
    protected String inlongStreamId;
    protected AgentMetricItemSet metricItemSet;
    protected AgentMetricItem sourceMetric;
    protected String metricName;
    protected Map<String, String> dimensions;
    protected static final AtomicLong METRIX_INDEX = new AtomicLong(0L);

    protected void init(JobProfile conf) {
        this.inlongGroupId = conf.get("proxy.inlongGroupId", "default_inlong_group_id");
        this.inlongStreamId = conf.get("proxy.inlongStreamId", "default_inlong_stream_id");
        this.dimensions = new HashMap<String, String>();
        this.dimensions.put("pluginId", this.getClass().getSimpleName());
        this.dimensions.put("inlongGroupId", this.inlongGroupId);
        this.dimensions.put("inlongStreamId", this.inlongStreamId);
        this.metricName = String.join((CharSequence)"-", this.getClass().getSimpleName(), String.valueOf(METRIX_INDEX.incrementAndGet()));
        this.metricItemSet = new AgentMetricItemSet(this.metricName);
        MetricRegister.register((MetricItemSet)this.metricItemSet);
        this.sourceMetric = (AgentMetricItem)this.metricItemSet.findMetricItem(this.dimensions);
    }
}

