/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.filter;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateFormatRegex {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateFormatRegex.class);
    private static final String YEAR = "YYYY";
    private static final String YEAR_LOWERCASE = "yyyy";
    private static final String MONTH = "MM";
    private static final String DAY = "DD";
    private static final String DAY_LOWERCASE = "dd";
    private static final String HOUR = "HH";
    private static final String MINUTE = "mm";
    private static final String NORMAL_FORMATTER = "yyyyMMddHHmm";
    private static final String OFFSET_DAY = "d";
    private static final String OFFSET_MIN = "m";
    private static final String OFFSET_HOUR = "h";
    private int dayOffset = 0;
    private int hourOffset = 0;
    private int minuteOffset = 0;
    private String originRegex;
    private String formattedTime = "";
    private String formattedRegex;

    public static DateFormatRegex ofRegex(String regex) {
        DateFormatRegex dateFormatRegex = new DateFormatRegex(regex);
        dateFormatRegex.setRegexWithCurrentTime();
        return dateFormatRegex;
    }

    private DateFormatRegex(String originRegex) {
        this.originRegex = originRegex;
    }

    public boolean match(File file) {
        if (file.isFile()) {
            return PathUtils.antPathMatch((String)file.getAbsolutePath(), (String)this.formattedRegex);
        }
        if (file.isDirectory()) {
            return PathUtils.antPathIncluded((String)file.getAbsolutePath(), (String)this.formattedRegex);
        }
        return false;
    }

    public DateFormatRegex withOffset(String timeOffset) {
        String mark;
        String number = StringUtils.substring((String)timeOffset, (int)0, (int)(timeOffset.length() - 1));
        switch (mark = StringUtils.substring((String)timeOffset, (int)(timeOffset.length() - 1))) {
            case "d": {
                this.dayOffset = Integer.parseInt(number);
                break;
            }
            case "h": {
                this.hourOffset = Integer.parseInt(number);
                break;
            }
            case "m": {
                this.minuteOffset = Integer.parseInt(number);
                break;
            }
            default: {
                LOGGER.warn("time offset is invalid, please check {}", (Object)timeOffset);
            }
        }
        return this;
    }

    public void setRegexWithTime(String time) {
        String[] regexList = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)this.originRegex, (String)File.separator, (int)0);
        ArrayList<String> formattedList = new ArrayList<String>();
        for (String regexStr : regexList) {
            if (regexStr.contains(YEAR) || regexStr.contains(YEAR_LOWERCASE)) {
                String tmpRegexStr = regexStr.replace(YEAR, time.substring(0, 4)).replace(YEAR_LOWERCASE, time.substring(0, 4)).replace(MONTH, time.substring(4, 6)).replace(DAY, time.substring(6, 8)).replace(DAY_LOWERCASE, time.substring(6, 8)).replace(HOUR, time.substring(8, 10)).replace(MINUTE, time.substring(10));
                formattedList.add(tmpRegexStr);
                this.formattedTime = time;
                continue;
            }
            formattedList.add(regexStr);
        }
        this.formattedRegex = StringUtils.join(formattedList, (char)File.separatorChar);
        LOGGER.info("updated formatted regex is {}", (Object)this.formattedRegex);
    }

    public void setRegexWithCurrentTime() {
        String currentTime = AgentUtils.formatCurrentTimeWithOffset((String)NORMAL_FORMATTER, (int)this.dayOffset, (int)this.hourOffset, (int)this.minuteOffset);
        this.setRegexWithTime(currentTime);
    }

    public String getFormattedRegex() {
        return this.formattedRegex;
    }

    public String getFormattedTime() {
        return this.formattedTime;
    }
}

