/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment.application;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.client.cli.ProgramOptionsUtils;
import org.apache.flink.client.deployment.application.ApplicationDispatcherLeaderProcessFactoryFactory;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.PackagedProgramUtils;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.WritableConfig;
import org.apache.flink.runtime.dispatcher.DispatcherFactory;
import org.apache.flink.runtime.dispatcher.ExecutionGraphInfoStore;
import org.apache.flink.runtime.dispatcher.MemoryExecutionGraphInfoStore;
import org.apache.flink.runtime.dispatcher.SessionDispatcherFactory;
import org.apache.flink.runtime.dispatcher.runner.DefaultDispatcherRunnerFactory;
import org.apache.flink.runtime.dispatcher.runner.DispatcherLeaderProcessFactoryFactory;
import org.apache.flink.runtime.dispatcher.runner.DispatcherRunnerFactory;
import org.apache.flink.runtime.entrypoint.ClusterEntrypoint;
import org.apache.flink.runtime.entrypoint.component.DefaultDispatcherResourceManagerComponentFactory;
import org.apache.flink.runtime.entrypoint.component.DispatcherResourceManagerComponentFactory;
import org.apache.flink.runtime.resourcemanager.ResourceManagerFactory;
import org.apache.flink.runtime.rest.JobRestEndpointFactory;
import org.apache.flink.runtime.rest.RestEndpointFactory;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.ScheduledExecutor;

public class ApplicationClusterEntryPoint
extends ClusterEntrypoint {
    private final PackagedProgram program;
    private final ResourceManagerFactory<?> resourceManagerFactory;

    protected ApplicationClusterEntryPoint(Configuration configuration, PackagedProgram program, ResourceManagerFactory<?> resourceManagerFactory) {
        super(configuration);
        this.program = (PackagedProgram)Preconditions.checkNotNull((Object)program);
        this.resourceManagerFactory = (ResourceManagerFactory)Preconditions.checkNotNull(resourceManagerFactory);
    }

    protected DispatcherResourceManagerComponentFactory createDispatcherResourceManagerComponentFactory(Configuration configuration) {
        return new DefaultDispatcherResourceManagerComponentFactory((DispatcherRunnerFactory)new DefaultDispatcherRunnerFactory((DispatcherLeaderProcessFactoryFactory)ApplicationDispatcherLeaderProcessFactoryFactory.create(configuration, (DispatcherFactory)SessionDispatcherFactory.INSTANCE, this.program)), this.resourceManagerFactory, (RestEndpointFactory)JobRestEndpointFactory.INSTANCE);
    }

    protected ExecutionGraphInfoStore createSerializableExecutionGraphStore(Configuration configuration, ScheduledExecutor scheduledExecutor) {
        return new MemoryExecutionGraphInfoStore();
    }

    protected static void configureExecution(Configuration configuration, PackagedProgram program) throws Exception {
        configuration.set(DeploymentOptions.TARGET, (Object)"embedded");
        ConfigUtils.encodeCollectionToConfig((WritableConfig)configuration, (ConfigOption)PipelineOptions.JARS, program.getJobJarAndDependencies(), URL::toString);
        ConfigUtils.encodeCollectionToConfig((WritableConfig)configuration, (ConfigOption)PipelineOptions.CLASSPATHS, ApplicationClusterEntryPoint.getClasspath(configuration, program), URL::toString);
        if (PackagedProgramUtils.isPython(program.getMainClassName()).booleanValue()) {
            ProgramOptionsUtils.configurePythonExecution(configuration, program);
        }
    }

    private static List<URL> getClasspath(Configuration configuration, PackagedProgram program) throws MalformedURLException {
        List classpath = ConfigUtils.decodeListFromConfig((ReadableConfig)configuration, (ConfigOption)PipelineOptions.CLASSPATHS, URL::new);
        classpath.addAll(program.getClasspaths());
        return Collections.unmodifiableList(classpath.stream().distinct().collect(Collectors.toList()));
    }

    protected void cleanupDirectories(ClusterEntrypoint.ShutdownBehaviour shutdownBehaviour) throws IOException {
        this.program.close();
        super.cleanupDirectories(shutdownBehaviour);
    }
}

