/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.tools;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.tubemq.corebase.utils.CheckSum;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.broker.msgstore.disk.FileSegment;
import org.apache.inlong.tubemq.server.broker.msgstore.disk.FileSegmentList;
import org.apache.inlong.tubemq.server.broker.msgstore.disk.Segment;
import org.apache.inlong.tubemq.server.broker.msgstore.disk.SegmentList;
import org.apache.inlong.tubemq.server.broker.msgstore.disk.SegmentType;
import org.apache.inlong.tubemq.server.broker.utils.DataStoreUtils;
import org.apache.inlong.tubemq.server.common.utils.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreRepairAdmin {
    private static final Logger logger = LoggerFactory.getLogger(StoreRepairAdmin.class);

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws Exception {
        File storeDir;
        if (args == null || args.length < 1) {
            System.out.println("[Data Repair] Please input 1 params : storePath [ topicA,topicB,....]");
            return;
        }
        List<String> topicList = null;
        final String storePath = args[0];
        if (args.length > 1 && args[1] != null && TStringUtils.isNotBlank((String)args[1])) {
            topicList = Arrays.asList(args[1].split(","));
        }
        if (!(storeDir = new File(storePath)).exists()) {
            throw new RuntimeException(new StringBuilder(512).append("[Data Repair] store path is not existed, path is ").append(storePath).toString());
        }
        if (!storeDir.isDirectory()) {
            throw new RuntimeException(new StringBuilder(512).append("[Data Repair]  store path is not a directory, path is ").append(storePath).toString());
        }
        long start = System.currentTimeMillis();
        File[] ls = storeDir.listFiles();
        if (topicList == null || topicList.isEmpty()) {
            logger.warn(new StringBuilder(512).append("[Data Repair] Begin to scan store path: ").append(storePath).toString());
        } else {
            logger.warn(new StringBuilder(512).append("[Data Repair] Begin to scan store path: ").append(storePath).append(",topicList:").append(topicList.toString()).toString());
        }
        int count = 0;
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() + 1);
        ArrayList<1> tasks = new ArrayList<1>();
        if (ls != null) {
            void var12_15;
            File[] fileArray = ls;
            int n = fileArray.length;
            boolean bl = false;
            while (var12_15 < n) {
                String name;
                int index;
                final File subDir = fileArray[var12_15];
                if (subDir != null && subDir.isDirectory() && (index = (name = subDir.getName()).lastIndexOf(45)) >= 0) {
                    final String topic = name.substring(0, index);
                    if (topicList == null || topicList.isEmpty() || topicList.contains(topic)) {
                        final int storeId = Integer.parseInt(name.substring(index + 1));
                        tasks.add(new Callable<IndexRepairStore>(){

                            @Override
                            public IndexRepairStore call() throws Exception {
                                StringBuilder sBuilder = new StringBuilder(512);
                                logger.info(sBuilder.append("[Data Repair] Loading data directory:").append(subDir.getAbsolutePath()).append("...").toString());
                                sBuilder.delete(0, sBuilder.length());
                                IndexRepairStore messageStore = new IndexRepairStore(storePath, topic, storeId);
                                messageStore.reCreateIndexFiles();
                                logger.info(sBuilder.append("[Data Repair] Finished data index recreation :").append(subDir.getAbsolutePath()).toString());
                                return messageStore;
                            }
                        });
                        ++count;
                    }
                }
                ++var12_15;
            }
        }
        if (count > 0) {
            ExecutorCompletionService completionService = new ExecutorCompletionService(executor);
            for (Callable callable : tasks) {
                completionService.submit(callable);
            }
            for (int i = 0; i < tasks.size(); ++i) {
                IndexRepairStore indexRepairStore = (IndexRepairStore)completionService.take().get();
                if (indexRepairStore == null) continue;
                indexRepairStore.close();
            }
            tasks.clear();
        }
        executor.shutdown();
        try {
            executor.awaitTermination(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        logger.warn(new StringBuilder(512).append("[Data Repair] End to scan data path in ").append((System.currentTimeMillis() - start) / 1000L).append(" secs").toString());
        System.exit(0);
    }

    private static class IndexRepairStore
    implements Closeable {
        private final String topic;
        private final int storeId;
        private final String basePath;
        private final String topicKey;
        private final String storePath;
        private final String indexPath;
        private final File topicDir;
        private final File indexDir;
        private int maxIndexSegmentSize = 14000000;
        private SegmentList segments;

        public IndexRepairStore(String basePath, String topic, int storeId) {
            this.basePath = basePath;
            this.topic = topic;
            this.storeId = storeId;
            StringBuilder sBuilder = new StringBuilder(512);
            this.topicKey = sBuilder.append(this.topic).append("-").append(this.storeId).toString();
            sBuilder.delete(0, sBuilder.length());
            this.storePath = sBuilder.append(this.basePath).append(File.separator).append(this.topicKey).toString();
            sBuilder.delete(0, sBuilder.length());
            this.indexPath = sBuilder.append(this.basePath).append(File.separator).append(this.topicKey).append(File.separator).append("index").toString();
            sBuilder.delete(0, sBuilder.length());
            this.topicDir = new File(this.storePath);
            this.indexDir = new File(this.indexPath);
        }

        public void reCreateIndexFiles() {
            StringBuilder sBuilder = new StringBuilder(512);
            try {
                this.loadDataSegments(sBuilder);
                this.deleteIndexFiles(sBuilder);
                this.createIndexFiles();
            }
            catch (Throwable ee) {
                sBuilder.delete(0, sBuilder.length());
                logger.error(sBuilder.append("ReCreate Index File of ").append(this.topicKey).append(" error ").toString(), ee);
            }
        }

        private void loadDataSegments(StringBuilder sBuilder) throws IOException {
            if (!this.topicDir.exists()) {
                throw new RuntimeException(sBuilder.append("[Data Repair] Topic data path is not existed, path is ").append(this.storePath).toString());
            }
            if (!this.topicDir.isDirectory()) {
                throw new RuntimeException(sBuilder.append("[Data Repair]  Topic data path is not a directory, path is ").append(this.storePath).toString());
            }
            this.loaderSegments();
        }

        private void loaderSegments() throws IOException {
            ArrayList<Segment> accum = new ArrayList<Segment>();
            String fileSuffix = ".tube";
            File[] ls = this.topicDir.listFiles();
            if (ls != null) {
                for (File file : ls) {
                    if (file == null || !file.isFile() || !file.toString().endsWith(fileSuffix)) continue;
                    if (!file.canRead()) {
                        throw new IOException(new StringBuilder(512).append("Could not read DATA file ").append(file).toString());
                    }
                    String filename = file.getName();
                    long start = Long.parseLong(filename.substring(0, filename.length() - fileSuffix.length()));
                    accum.add(new FileSegment(start, file, false, SegmentType.DATA));
                }
            }
            if (accum.size() > 0) {
                Collections.sort(accum, new Comparator<Segment>(){

                    @Override
                    public int compare(Segment o1, Segment o2) {
                        if (o1.getStart() == o2.getStart()) {
                            return 0;
                        }
                        if (o1.getStart() > o2.getStart()) {
                            return 1;
                        }
                        return -1;
                    }
                });
                this.validateSegments("DATA", accum);
            }
            this.segments = new FileSegmentList(accum.toArray(new Segment[accum.size()]));
            logger.info(new StringBuilder(512).append("[Data Repair] Loaded DATA ").append(accum.size()).append(" segments from ").append(this.topicDir.getAbsolutePath()).toString());
        }

        public void validateSegments(String segTypeStr, List<Segment> segments) {
            for (int i = 0; i < segments.size() - 1; ++i) {
                Segment curr = segments.get(i);
                Segment next = segments.get(i + 1);
                if (curr.getStart() + curr.getCachedSize() == next.getStart()) continue;
                throw new IllegalStateException(new StringBuilder(512).append("The following ").append(segTypeStr).append(" segments don't validate: ").append(curr.getFile().getAbsolutePath()).append(", ").append(next.getFile().getAbsolutePath()).toString());
            }
        }

        @Override
        public void close() throws IOException {
            try {
                if (this.segments != null) {
                    for (Segment segment : this.segments.getView()) {
                        segment.close();
                    }
                }
            }
            catch (Throwable e3) {
                logger.error("[Data Repair] Close data segments error", e3);
            }
        }

        private void deleteIndexFiles(StringBuilder sBuilder) {
            if (this.indexDir.exists()) {
                if (!this.indexDir.isDirectory()) {
                    throw new RuntimeException(sBuilder.append("[Data Repair] Topic index path is not a directory, path is ").append(this.indexPath).toString());
                }
                try {
                    FileUtil.fullyDeleteContents(this.indexDir);
                }
                catch (Throwable er) {
                    logger.error(sBuilder.append("[Data Repair] delete index files error, path is ").append(this.indexPath).toString(), er);
                }
            } else {
                if (!this.indexDir.mkdirs()) {
                    throw new RuntimeException(sBuilder.append("[Data Repair] Could not make index directory ").append(this.indexPath).toString());
                }
                if (!this.indexDir.isDirectory() || !this.indexDir.canRead()) {
                    throw new RuntimeException(sBuilder.append("[Data Repair] Index path ").append(this.indexPath).append(" is not a readable directory").toString());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createIndexFiles() {
            Segment[] segments = this.segments.getView();
            if (segments.length == 0) {
                return;
            }
            Segment curPartSeg = null;
            ByteBuffer dataBuffer = ByteBuffer.allocate(0x1400000);
            ByteBuffer indexBuffer = ByteBuffer.allocate(28);
            for (Segment curSegment : segments) {
                if (curSegment == null) continue;
                try {
                    int dataStart;
                    block8: for (long curOffset = 0L; curOffset < curSegment.getCachedSize(); curOffset += (long)dataStart) {
                        dataBuffer.clear();
                        curSegment.relRead(dataBuffer, curOffset);
                        dataBuffer.flip();
                        int dataRealLimit = dataBuffer.limit();
                        if (dataRealLimit < 52) break;
                        dataStart = 0;
                        while (dataStart < dataRealLimit && dataRealLimit - dataStart > 52) {
                            int msgLen = dataBuffer.getInt(dataStart + 0);
                            int msgToken = dataBuffer.getInt(dataStart + 4);
                            int checkSum = dataBuffer.getInt(dataStart + 8);
                            int partitionId = dataBuffer.getInt(dataStart + 12);
                            long queueOffset = dataBuffer.getLong(dataStart + 16);
                            long timeRecv = dataBuffer.getLong(dataStart + 24);
                            int keyCode = dataBuffer.getInt(dataStart + 36);
                            int msgSize = msgLen + 4;
                            long msgOffset = queueOffset - queueOffset % 28L;
                            int payLoadLen = msgLen - 48;
                            int payLoadOffset = dataStart + 52;
                            if (msgToken != 46766264 || payLoadLen <= 0 || payLoadLen > 29360180) {
                                ++dataStart;
                                continue;
                            }
                            if (payLoadLen > dataRealLimit - dataStart - 52) continue block8;
                            byte[] payLoadData = new byte[payLoadLen];
                            System.arraycopy(dataBuffer.array(), payLoadOffset, payLoadData, 0, payLoadLen);
                            if (checkSum != CheckSum.crc32((byte[])payLoadData)) {
                                ++dataStart;
                                continue;
                            }
                            indexBuffer.clear();
                            indexBuffer.putInt(partitionId);
                            indexBuffer.putLong(curSegment.getStart() + curOffset + (long)dataStart);
                            indexBuffer.putInt(msgSize);
                            indexBuffer.putInt(keyCode);
                            indexBuffer.putLong(timeRecv);
                            indexBuffer.flip();
                            dataStart += msgSize;
                            if (curPartSeg == null) {
                                File newFile = new File(this.indexDir, DataStoreUtils.nameFromOffset(msgOffset, ".index"));
                                curPartSeg = new FileSegment(msgOffset, newFile, SegmentType.INDEX);
                            }
                            curPartSeg.append(indexBuffer, timeRecv, timeRecv);
                            if (curPartSeg.getCachedSize() < (long)this.maxIndexSegmentSize) continue;
                            curPartSeg.flush(true);
                            curPartSeg.close();
                            curPartSeg = null;
                        }
                    }
                    if (curPartSeg == null) continue;
                    curPartSeg.flush(true);
                }
                catch (Throwable ee) {
                    logger.error("Create Index file error ", ee);
                }
                finally {
                    if (curSegment != null) {
                        curSegment.relViewRef();
                    }
                }
            }
            try {
                if (curPartSeg != null) {
                    curPartSeg.flush(true);
                    curPartSeg.close();
                }
            }
            catch (Throwable e2) {
                logger.error("Close Index file error ", e2);
            }
        }
    }
}

