/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.web.simplemvc;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.Part;

public class MultipartHttpServletRequest
extends HttpServletRequestWrapper {
    private boolean parsed = false;
    private HashMap<String, String> cachedParams = new HashMap();

    public MultipartHttpServletRequest(HttpServletRequest request) {
        super(request);
    }

    private void extractParametersFromMultipartFormData(HttpServletRequest req) throws IOException, ServletException {
        for (Part dataPart : req.getParts()) {
            if (dataPart.getSize() > 0x4000000L) continue;
            String dataKey = dataPart.getName();
            int dataSize = (int)dataPart.getSize();
            byte[] buffer = new byte[dataSize];
            dataPart.getInputStream().read(buffer, 0, dataSize);
            String dataValue = new String(buffer, StandardCharsets.UTF_8);
            this.cachedParams.put(dataKey, dataValue);
        }
    }

    public String getParameter(String name) {
        if (!this.parsed) {
            this.parsed = true;
            try {
                this.extractParametersFromMultipartFormData((HttpServletRequest)this.getRequest());
            }
            catch (Exception e) {
                this.cachedParams.clear();
            }
        }
        if (this.cachedParams.containsKey(name)) {
            return this.cachedParams.get(name);
        }
        return null;
    }
}

