/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;
import org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer.ConsumeType;
import org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer.ConsumerInfo;
import org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer.NodeRebInfo;
import org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer.RebProcessInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumeGroupInfo {
    private static final Logger logger = LoggerFactory.getLogger(ConsumeGroupInfo.class);
    private final String groupName;
    private final ConsumeType consumeType;
    private final long createTime;
    private final Set<String> topicSet = new HashSet<String>();
    private final Map<String, TreeSet<String>> topicConditions = new HashMap<String, TreeSet<String>>();
    private final ReadWriteLock csmInfoRWLock = new ReentrantReadWriteLock();
    private final Map<String, ConsumerInfo> consumerInfoMap = new HashMap<String, ConsumerInfo>();
    private String sessionKey = "";
    private long sessionTime = -2L;
    private int sourceCount = -2;
    private boolean isSelectedBig = true;
    private final AtomicBoolean notAllocate = new AtomicBoolean(true);
    private final AtomicLong curCheckCycle = new AtomicLong(0L);
    private final AtomicInteger allocatedTimes = new AtomicInteger(0);
    private final ConcurrentHashMap<String, String> partitionInfoMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Long> partOffsetMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, NodeRebInfo> balanceNodeMap = new ConcurrentHashMap();
    private int confResourceRate = -2;
    private int curResourceRate = -2;
    private int minReqClientCnt = -2;
    private int balanceChkStatus = -2;
    private boolean enableBalanceChkPrint = true;
    private final AtomicLong csmCtrlId = new AtomicLong(-2L);
    private final AtomicLong topicMetaInfoId = new AtomicLong(-2L);
    private final ConcurrentHashMap<String, String> topicMetaInfoMap = new ConcurrentHashMap();
    private final AtomicLong lastMetaInfoFreshTime = new AtomicLong(-2L);

    public ConsumeGroupInfo(ConsumerInfo consumer) {
        this.groupName = consumer.getGroupName();
        this.consumeType = consumer.getConsumeType();
        this.topicSet.addAll(consumer.getTopicSet());
        this.topicConditions.putAll(consumer.getTopicConditions());
        this.createTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addConsumer(ConsumerInfo inConsumer, StringBuilder strBuff, ProcessResult result) {
        try {
            this.csmInfoRWLock.writeLock().lock();
            if (this.consumerInfoMap.isEmpty()) {
                if (this.consumeType == ConsumeType.CONSUME_BAND) {
                    this.sessionKey = inConsumer.getSessionKey();
                    this.sessionTime = inConsumer.getStartTime();
                    this.sourceCount = inConsumer.getSourceCount();
                    this.isSelectedBig = inConsumer.isSelectedBig();
                    this.curCheckCycle.set(0L);
                } else if (this.consumeType == ConsumeType.CONSUME_CLIENT_REB) {
                    this.sourceCount = inConsumer.getSourceCount();
                }
            } else {
                if (!this.validConsumerInfo(inConsumer, strBuff, result)) {
                    boolean bl = false;
                    return bl;
                }
                ConsumerInfo curConsumerInfo = this.consumerInfoMap.get(inConsumer.getConsumerId());
                if (curConsumerInfo != null) {
                    curConsumerInfo.updCurConsumerInfo(inConsumer);
                    result.setSuccResult((Object)false);
                    boolean bl = true;
                    return bl;
                }
            }
            this.consumerInfoMap.put(inConsumer.getConsumerId(), inConsumer);
            if (this.consumeType == ConsumeType.CONSUME_BAND) {
                this.bookPartitionInfo(inConsumer);
            }
            result.setSuccResult((Object)true);
            boolean bl = true;
            return bl;
        }
        finally {
            this.csmInfoRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerInfo removeConsumer(String consumerId) {
        if (consumerId == null) {
            return null;
        }
        try {
            this.csmInfoRWLock.writeLock().lock();
            this.balanceNodeMap.remove(consumerId);
            ArrayList<String> partKeyList = new ArrayList<String>();
            for (Map.Entry<String, String> entry : this.partitionInfoMap.entrySet()) {
                if (entry.getValue() == null || !entry.getValue().equals(consumerId)) continue;
                partKeyList.add(entry.getKey());
            }
            for (String partKey : partKeyList) {
                this.partitionInfoMap.remove(partKey);
                this.partOffsetMap.remove(partKey);
            }
            ConsumerInfo consumerInfo = this.consumerInfoMap.remove(consumerId);
            return consumerInfo;
        }
        finally {
            this.csmInfoRWLock.writeLock().unlock();
        }
    }

    public int getGroupCnt() {
        try {
            this.csmInfoRWLock.readLock().lock();
            int n = this.consumerInfoMap.size();
            return n;
        }
        finally {
            this.csmInfoRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodeRelInfo(String clientId, int waitDuration) {
        NodeRebInfo nodeRebInfo = this.balanceNodeMap.get(clientId);
        if (nodeRebInfo != null) {
            if (nodeRebInfo.getStatus() == 4) {
                this.balanceNodeMap.remove(clientId);
            } else {
                return;
            }
        }
        try {
            this.csmInfoRWLock.readLock().lock();
            if (this.consumerInfoMap.containsKey(clientId)) {
                this.balanceNodeMap.putIfAbsent(clientId, new NodeRebInfo(clientId, waitDuration));
            }
        }
        finally {
            this.csmInfoRWLock.readLock().unlock();
        }
    }

    public RebProcessInfo getNeedBalanceNodes() {
        ArrayList<String> needProcessList = new ArrayList<String>();
        ArrayList<String> needEscapeList = new ArrayList<String>();
        ArrayList<String> needRemoved = new ArrayList<String>();
        for (NodeRebInfo nodeRebInfo : this.balanceNodeMap.values()) {
            if (nodeRebInfo.getStatus() == 0) {
                nodeRebInfo.setStatus(1);
                needProcessList.add(nodeRebInfo.getClientId());
                continue;
            }
            if (nodeRebInfo.getReqType() != 1 || nodeRebInfo.getStatus() != 2) continue;
            if (nodeRebInfo.decrAndGetWaitDuration() <= 0) {
                nodeRebInfo.setStatus(4);
                needRemoved.add(nodeRebInfo.getClientId());
                continue;
            }
            needEscapeList.add(nodeRebInfo.getClientId());
        }
        for (String clientId : needRemoved) {
            this.balanceNodeMap.remove(clientId);
        }
        return new RebProcessInfo(needProcessList, needEscapeList);
    }

    public void setBalanceNodeProcessed(List<String> processList) {
        if (processList == null || processList.isEmpty() || this.balanceNodeMap.isEmpty()) {
            return;
        }
        ArrayList<String> needRemoved = new ArrayList<String>();
        for (NodeRebInfo nodeRebInfo : this.balanceNodeMap.values()) {
            if (!processList.contains(nodeRebInfo.getClientId())) continue;
            if (nodeRebInfo.getReqType() == 0) {
                nodeRebInfo.setStatus(4);
                needRemoved.add(nodeRebInfo.getClientId());
                continue;
            }
            nodeRebInfo.setStatus(2);
        }
        for (String clientId : needRemoved) {
            this.balanceNodeMap.remove(clientId);
        }
    }

    public void updCsmFromMaxCtrlId() {
        this.csmCtrlId.set(System.currentTimeMillis());
    }

    public void updCsmTopicMetaInfo(Map<String, String> newMetaInfoMap) {
        this.lastMetaInfoFreshTime.set(System.currentTimeMillis());
        if (newMetaInfoMap == null || newMetaInfoMap.isEmpty()) {
            return;
        }
        boolean isChanged = false;
        Set<String> newTopics = newMetaInfoMap.keySet();
        Set curTopics = this.topicMetaInfoMap.keySet();
        if (newTopics.size() != curTopics.size() || !newTopics.containsAll(curTopics)) {
            isChanged = true;
        } else {
            for (String topicKey : newTopics) {
                String newConfig = newMetaInfoMap.get(topicKey);
                String curConfig = this.topicMetaInfoMap.get(topicKey);
                if (newConfig == null || newConfig.equals(curConfig)) continue;
                isChanged = true;
                break;
            }
        }
        if (isChanged) {
            for (String newTopic : newTopics) {
                this.topicMetaInfoMap.put(newTopic, newMetaInfoMap.get(newTopic));
            }
            this.topicMetaInfoId.set(System.currentTimeMillis());
        }
    }

    public boolean isUnReadyServerBalance() {
        return this.consumeType == ConsumeType.CONSUME_BAND && this.notAllocate.get() && !this.partitionInfoMap.isEmpty() && this.allocatedTimes.get() < 2;
    }

    public boolean isNotNeedBoundBalance() {
        return this.consumeType != ConsumeType.CONSUME_BAND || !this.notAllocate.get() || this.partitionInfoMap.isEmpty() || this.allocatedTimes.get() >= 2;
    }

    public boolean needResourceCheck() {
        return this.consumeType == ConsumeType.CONSUME_NORMAL && this.balanceChkStatus <= 0;
    }

    public ConsumeType getConsumeType() {
        return this.consumeType;
    }

    public boolean isClientBalance() {
        return this.consumeType == ConsumeType.CONSUME_CLIENT_REB;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public boolean isNotAllocate() {
        return this.notAllocate.get();
    }

    public void settAllocated() {
        this.notAllocate.compareAndSet(true, false);
    }

    public int getAllocatedTimes() {
        return this.allocatedTimes.get();
    }

    public int addAllocatedTimes() {
        return this.allocatedTimes.incrementAndGet();
    }

    public boolean isGroupEmpty() {
        try {
            this.csmInfoRWLock.readLock().lock();
            boolean bl = this.consumerInfoMap.isEmpty();
            return bl;
        }
        finally {
            this.csmInfoRWLock.readLock().unlock();
        }
    }

    public boolean isGroupFullSize() {
        try {
            this.csmInfoRWLock.readLock().lock();
            boolean bl = this.consumerInfoMap.size() >= this.sourceCount;
            return bl;
        }
        finally {
            this.csmInfoRWLock.readLock().unlock();
        }
    }

    public boolean isBalanceMapEmpty() {
        return this.balanceNodeMap.isEmpty();
    }

    public long getSessionTime() {
        return this.sessionTime;
    }

    public int getSourceCount() {
        return this.sourceCount;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getCurCheckCycle() {
        return this.curCheckCycle.get();
    }

    public long addCurCheckCycle() {
        return this.curCheckCycle.addAndGet(1L);
    }

    public void setConsumeResourceInfo(int confResourceRate, int curResourceRate, int minReqClientCnt, boolean isRebalanced) {
        this.confResourceRate = confResourceRate;
        this.curResourceRate = curResourceRate;
        this.minReqClientCnt = minReqClientCnt;
        this.enableBalanceChkPrint = false;
        this.balanceChkStatus = isRebalanced ? 1 : 0;
    }

    public boolean isEnableBalanceChkPrint() {
        return this.enableBalanceChkPrint;
    }

    public int getConfResourceRate() {
        return this.confResourceRate;
    }

    public int getCurResourceRate() {
        return this.curResourceRate;
    }

    public int getMinReqClientCnt() {
        return this.minReqClientCnt;
    }

    public int getBalanceChkStatus() {
        return this.balanceChkStatus;
    }

    public Set<String> getTopicSet() {
        return this.topicSet;
    }

    public boolean isSelectedBig() {
        return this.isSelectedBig;
    }

    public Map<String, TreeSet<String>> getTopicConditions() {
        return this.topicConditions;
    }

    public long getCsmFromMaxCtrlId() {
        return this.csmCtrlId.get();
    }

    public Tuple2<Long, List<String>> getTopicMetaInfo() {
        ArrayList<String> topicMetaInfoList = new ArrayList<String>();
        for (String metaInfo : this.topicMetaInfoMap.values()) {
            if (TStringUtils.isBlank((String)metaInfo)) continue;
            topicMetaInfoList.add(metaInfo);
        }
        return new Tuple2((Object)this.topicMetaInfoId.get(), topicMetaInfoList);
    }

    public AtomicLong getLastMetaInfoFreshTime() {
        return this.lastMetaInfoFreshTime;
    }

    public List<ConsumerInfo> getConsumerInfoList() {
        try {
            this.csmInfoRWLock.readLock().lock();
            ArrayList<ConsumerInfo> arrayList = new ArrayList<ConsumerInfo>(this.consumerInfoMap.values());
            return arrayList;
        }
        finally {
            this.csmInfoRWLock.readLock().unlock();
        }
    }

    public List<String> getConsumerIdList() {
        try {
            this.csmInfoRWLock.readLock().lock();
            ArrayList<String> arrayList = new ArrayList<String>(this.consumerInfoMap.keySet());
            return arrayList;
        }
        finally {
            this.csmInfoRWLock.readLock().unlock();
        }
    }

    public ConsumerInfo getConsumerInfo(String consumerId) {
        try {
            this.csmInfoRWLock.readLock().lock();
            ConsumerInfo consumerInfo = this.consumerInfoMap.get(consumerId);
            return consumerInfo;
        }
        finally {
            this.csmInfoRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getConsumerViewInfos() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            this.csmInfoRWLock.readLock().lock();
            for (ConsumerInfo consumerInfo : this.consumerInfoMap.values()) {
                if (consumerInfo == null) continue;
                result.add(consumerInfo.getConsumerViewInfo());
            }
        }
        finally {
            this.csmInfoRWLock.readLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tuple2<String, Boolean>> getConsumerIdAndTlsInfos() {
        ArrayList<Tuple2<String, Boolean>> result = new ArrayList<Tuple2<String, Boolean>>();
        try {
            this.csmInfoRWLock.readLock().lock();
            for (ConsumerInfo consumerInfo : this.consumerInfoMap.values()) {
                if (consumerInfo == null) continue;
                result.add(consumerInfo.getConsumerIdAndTlsInfoTuple());
            }
        }
        finally {
            this.csmInfoRWLock.readLock().unlock();
        }
        return result;
    }

    public Map<String, String> getPartitionInfoMap() {
        return this.partitionInfoMap;
    }

    public Map<String, Long> getPartOffsetMap() {
        return this.partOffsetMap;
    }

    public Map<String, NodeRebInfo> getBalanceMap() {
        return this.balanceNodeMap;
    }

    private void bookPartitionInfo(ConsumerInfo consumer) {
        if (this.consumeType != ConsumeType.CONSUME_BAND) {
            return;
        }
        Map<String, Long> consumerPartMap = consumer.getRequiredPartition();
        if (consumerPartMap == null || consumerPartMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Long> entry : consumerPartMap.entrySet()) {
            String oldClientId = this.partitionInfoMap.get(entry.getKey());
            if (oldClientId == null) {
                this.partitionInfoMap.put(entry.getKey(), consumer.getConsumerId());
                this.partOffsetMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            ConsumerInfo oldConsumerInfo = this.consumerInfoMap.get(oldClientId);
            if (oldConsumerInfo == null) {
                this.partitionInfoMap.put(entry.getKey(), consumer.getConsumerId());
                this.partOffsetMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            Map<String, Long> oldConsumerPartMap = oldConsumerInfo.getRequiredPartition();
            if (oldConsumerPartMap == null || oldConsumerPartMap.isEmpty()) {
                this.partitionInfoMap.put(entry.getKey(), consumer.getConsumerId());
                this.partOffsetMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            Long oldConsumerOff = oldConsumerPartMap.get(entry.getKey());
            if (oldConsumerOff == null) {
                this.partitionInfoMap.put(entry.getKey(), consumer.getConsumerId());
                this.partOffsetMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (this.isSelectedBig) {
                if (entry.getValue() < oldConsumerOff) continue;
                this.partitionInfoMap.put(entry.getKey(), consumer.getConsumerId());
                this.partOffsetMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getValue() >= oldConsumerOff) continue;
            this.partitionInfoMap.put(entry.getKey(), consumer.getConsumerId());
            this.partOffsetMap.put(entry.getKey(), entry.getValue());
        }
    }

    private boolean validConsumerInfo(ConsumerInfo inConsumer, StringBuilder strBuff, ProcessResult result) {
        boolean isCondEqual;
        block16: {
            block15: {
                if (inConsumer.getConsumeType() != this.consumeType) {
                    strBuff.append("[Inconsistency subscribe] ").append(inConsumer.getConsumerId()).append(" using ").append(inConsumer.getConsumeType().getName()).append(" subscribe is inconsistency with other consumers using ").append(this.consumeType.getName()).append(" subscribe in the group");
                    result.setFailResult(424, strBuff.toString());
                    logger.warn(strBuff.toString());
                    strBuff.delete(0, strBuff.length());
                    return false;
                }
                if (CollectionUtils.isNotEmpty(this.topicSet) && (this.topicSet.size() != inConsumer.getTopicSet().size() || !this.topicSet.containsAll(inConsumer.getTopicSet()))) {
                    strBuff.append("[Inconsistency subscribe] ").append(inConsumer.getConsumerId()).append(" subscribed topics ").append(inConsumer.getTopicSet()).append(" is inconsistency with other consumers in the group, existedTopics: ").append(this.topicSet);
                    result.setFailResult(425, strBuff.toString());
                    logger.warn(strBuff.toString());
                    strBuff.delete(0, strBuff.length());
                    return false;
                }
                isCondEqual = true;
                if (!this.topicConditions.isEmpty()) break block15;
                if (inConsumer.getTopicConditions().isEmpty()) break block16;
                isCondEqual = false;
                strBuff.append("[Inconsistency subscribe] ").append(inConsumer.getConsumerId()).append(" subscribe with filter condition ").append(inConsumer.getTopicConditions()).append(" is inconsistency with other consumers in the group: topic without conditions");
                break block16;
            }
            if (inConsumer.getTopicConditions().isEmpty()) {
                isCondEqual = false;
                strBuff.append("[Inconsistency subscribe] ").append(inConsumer.getConsumerId()).append(" subscribe without filter condition ").append(" is inconsistency with other consumers in the group, existed topic conditions is ").append(this.topicConditions);
            } else {
                Set<String> existedCondTopics = this.topicConditions.keySet();
                Set<String> reqCondTopics = inConsumer.getTopicConditions().keySet();
                if (existedCondTopics.size() != reqCondTopics.size() || !existedCondTopics.containsAll(reqCondTopics)) {
                    isCondEqual = false;
                    strBuff.append("[Inconsistency subscribe] ").append(inConsumer.getConsumerId()).append(" subscribe with filter condition ").append(inConsumer.getTopicConditions()).append(" is inconsistency with other consumers in the group, existed topic conditions is ").append(this.topicConditions);
                } else {
                    for (String topicKey : existedCondTopics) {
                        if (this.topicConditions.get(topicKey).size() == inConsumer.getTopicConditions().get(topicKey).size() && this.topicConditions.get(topicKey).containsAll((Collection)inConsumer.getTopicConditions().get(topicKey))) continue;
                        isCondEqual = false;
                        strBuff.append("[Inconsistency subscribe] ").append(inConsumer.getConsumerId()).append(" subscribe with filter condition ").append(inConsumer.getTopicConditions()).append(" is inconsistency with other consumers in the group,").append(" existed topic conditions is ").append(this.topicConditions);
                        break;
                    }
                }
            }
        }
        if (!isCondEqual) {
            result.setFailResult(426, strBuff.toString());
            logger.warn(strBuff.toString());
            return false;
        }
        if (this.consumeType == ConsumeType.CONSUME_BAND) {
            if (!this.validBoundParameters(inConsumer, strBuff, result)) {
                return false;
            }
        } else if (this.consumeType == ConsumeType.CONSUME_CLIENT_REB && this.sourceCount > 0) {
            if (this.sourceCount != inConsumer.getSourceCount()) {
                strBuff.append("[Inconsistency subscribe] ").append(inConsumer.getConsumerId()).append("'s sourceCount is inconsistency with other consumers in the group, required is ").append(this.sourceCount).append(", request is ").append(inConsumer.getSourceCount());
                result.setFailResult(429, strBuff.toString());
                logger.warn(strBuff.toString());
                return false;
            }
            boolean foundOccupied = false;
            int occupiedNodeId = -1;
            String occupiedConsumerId = null;
            for (ConsumerInfo consumerInfo : this.consumerInfoMap.values()) {
                if (consumerInfo == null || consumerInfo.getNodeId() != inConsumer.getNodeId() || consumerInfo.getConsumerId().equals(inConsumer.getConsumerId())) continue;
                foundOccupied = true;
                occupiedNodeId = consumerInfo.getNodeId();
                occupiedConsumerId = consumerInfo.getConsumerId();
                break;
            }
            if (foundOccupied) {
                strBuff.append("[Inconsistency subscribe] ").append(inConsumer.getConsumerId()).append("'s nodeId value(").append(inConsumer.getNodeId()).append(") is occupied by ").append(occupiedConsumerId).append("'s nodeId value(").append(occupiedNodeId).append(") in the group!");
                result.setFailResult(430, strBuff.toString());
                logger.warn(strBuff.toString());
                return false;
            }
        }
        result.setSuccResult((Object)"Ok");
        return true;
    }

    private boolean validBoundParameters(ConsumerInfo inConsumer, StringBuilder strBuff, ProcessResult result) {
        if (this.consumeType != ConsumeType.CONSUME_BAND) {
            result.setSuccResult((Object)"");
            return true;
        }
        if (!this.sessionKey.equals(inConsumer.getSessionKey())) {
            strBuff.append("[Inconsistency subscribe] ").append(inConsumer.getConsumerId()).append("'s sessionKey is inconsistency with other consumers in the group, required is ").append(this.sessionKey).append(", request is ").append(inConsumer.getSessionKey());
            result.setFailResult(427, strBuff.toString());
            logger.warn(strBuff.toString());
            return false;
        }
        if (this.isSelectedBig != inConsumer.isSelectedBig()) {
            strBuff.append("[Inconsistency subscribe] ").append(inConsumer.getConsumerId()).append("'s isSelectBig is inconsistency with other consumers in the group, required is ").append(this.isSelectedBig).append(", request is ").append(inConsumer.isSelectedBig());
            result.setFailResult(428, strBuff.toString());
            logger.warn(strBuff.toString());
            return false;
        }
        if (this.sourceCount != inConsumer.getSourceCount()) {
            strBuff.append("[Inconsistency subscribe] ").append(inConsumer.getConsumerId()).append("'s sourceCount is inconsistency with other consumers in the group, required is ").append(this.sourceCount).append(", request is ").append(inConsumer.getSourceCount());
            result.setFailResult(429, strBuff.toString());
            logger.warn(strBuff.toString());
            return false;
        }
        result.setSuccResult((Object)"Ok");
        return true;
    }
}

