/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.bdbimpl;

import com.sleepycat.je.Environment;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.StoreConfig;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.server.common.exception.LoadMetaException;
import org.apache.inlong.tubemq.server.master.bdbstore.bdbentitys.BdbGroupFilterCondEntity;
import org.apache.inlong.tubemq.server.master.metamanage.DataOpErrCode;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.GroupConsumeCtrlEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.AbsConsumeCtrlMapperImpl;

public class BdbConsumeCtrlMapperImpl
extends AbsConsumeCtrlMapperImpl {
    private EntityStore groupConsumeStore;
    private final PrimaryIndex<String, BdbGroupFilterCondEntity> groupConsumeIndex;

    public BdbConsumeCtrlMapperImpl(ReplicatedEnvironment repEnv, StoreConfig storeConfig) {
        this.groupConsumeStore = new EntityStore((Environment)repEnv, "bdbGroupFilterCond", storeConfig);
        this.groupConsumeIndex = this.groupConsumeStore.getPrimaryIndex(String.class, BdbGroupFilterCondEntity.class);
    }

    @Override
    public void close() {
        this.clearCachedData();
        if (this.groupConsumeStore != null) {
            try {
                this.groupConsumeStore.close();
                this.groupConsumeStore = null;
            }
            catch (Throwable e) {
                logger.error("[BDB Impl] close consume control configure failure ", e);
            }
        }
        logger.info("[BDB Impl] consume control configure closed!");
    }

    @Override
    public void loadConfig(StringBuilder strBuff) throws LoadMetaException {
        long totalCnt = 0L;
        logger.info("[BDB Impl] load consume control configure start...");
        try (EntityCursor cursor = null;){
            this.clearCachedData();
            cursor = this.groupConsumeIndex.entities();
            for (BdbGroupFilterCondEntity bdbEntity : cursor) {
                if (bdbEntity == null) {
                    logger.warn("[BDB Impl] found Null data while loading consume control configure!");
                    continue;
                }
                this.putRecord2Caches(new GroupConsumeCtrlEntity(bdbEntity));
                ++totalCnt;
            }
        }
        logger.info(strBuff.append("[BDB Impl] loaded ").append(totalCnt).append(" consume control configure successfully...").toString());
        strBuff.delete(0, strBuff.length());
    }

    @Override
    protected boolean putConfig2Persistent(GroupConsumeCtrlEntity entity, StringBuilder strBuff, ProcessResult result) {
        BdbGroupFilterCondEntity bdbEntity = entity.buildBdbGroupFilterCondEntity();
        try {
            this.groupConsumeIndex.put((Object)bdbEntity);
        }
        catch (Throwable e) {
            logger.error("[BDB Impl] put consume control configure failure ", e);
            result.setFailResult(DataOpErrCode.DERR_STORE_ABNORMAL.getCode(), strBuff.append("Put consume control configure failure: ").append(e.getMessage()).toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        result.setSuccResult(null);
        return result.isSuccess();
    }

    @Override
    protected boolean delConfigFromPersistent(String recordKey, StringBuilder strBuff) {
        try {
            this.groupConsumeIndex.delete((Object)recordKey);
        }
        catch (Throwable e) {
            logger.error("[BDB Impl] delete consume control configure failure ", e);
            return false;
        }
        return true;
    }
}

