/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.bdbimpl;

import com.sleepycat.je.Environment;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.StoreConfig;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.server.common.exception.LoadMetaException;
import org.apache.inlong.tubemq.server.master.bdbstore.bdbentitys.BdbClusterSettingEntity;
import org.apache.inlong.tubemq.server.master.metamanage.DataOpErrCode;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.ClusterSettingEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.AbsClusterConfigMapperImpl;

public class BdbClusterConfigMapperImpl
extends AbsClusterConfigMapperImpl {
    private EntityStore clsDefSettingStore;
    private final PrimaryIndex<String, BdbClusterSettingEntity> clsDefSettingIndex;

    public BdbClusterConfigMapperImpl(ReplicatedEnvironment repEnv, StoreConfig storeConfig) {
        this.clsDefSettingStore = new EntityStore((Environment)repEnv, "bdbClusterSetting", storeConfig);
        this.clsDefSettingIndex = this.clsDefSettingStore.getPrimaryIndex(String.class, BdbClusterSettingEntity.class);
    }

    @Override
    public void close() {
        this.clearCachedData();
        if (this.clsDefSettingStore != null) {
            try {
                this.clsDefSettingStore.close();
                this.clsDefSettingStore = null;
            }
            catch (Throwable e) {
                logger.error("[BDB Impl] close cluster configure failure ", e);
            }
        }
        logger.info("[BDB Impl] cluster configure closed!");
    }

    @Override
    public void loadConfig(StringBuilder strBuff) throws LoadMetaException {
        long totalCnt = 0L;
        EntityCursor cursor = null;
        logger.info("[BDB Impl] load cluster configure start...");
        this.clearCachedData();
        try {
            cursor = this.clsDefSettingIndex.entities();
            for (BdbClusterSettingEntity bdbEntity : cursor) {
                if (bdbEntity == null) {
                    logger.warn("[BDB Impl] found Null data while loading cluster configure!");
                    continue;
                }
                this.putRecord2Caches(new ClusterSettingEntity(bdbEntity));
                ++totalCnt;
            }
        }
        catch (Exception e) {
            logger.error("[BDB Impl] load cluster configure failure ", (Throwable)e);
            throw new LoadMetaException(e.getMessage());
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        logger.info(strBuff.append("[BDB Impl] loaded ").append(totalCnt).append(" cluster configure successfully...").toString());
        strBuff.delete(0, strBuff.length());
    }

    @Override
    protected boolean putConfig2Persistent(ClusterSettingEntity entity, StringBuilder strBuff, ProcessResult result) {
        BdbClusterSettingEntity bdbEntity = entity.buildBdbClsDefSettingEntity();
        try {
            this.clsDefSettingIndex.put((Object)bdbEntity);
        }
        catch (Throwable e) {
            logger.error("[BDB Impl] put cluster configure failure ", e);
            result.setFailResult(DataOpErrCode.DERR_STORE_ABNORMAL.getCode(), strBuff.append("Put cluster configure failure: ").append(e.getMessage()).toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        result.setSuccResult(null);
        return result.isSuccess();
    }

    @Override
    protected boolean delConfigFromPersistent(StringBuilder strBuff, String key) {
        try {
            this.clsDefSettingIndex.delete((Object)key);
        }
        catch (Throwable e) {
            logger.error("[BDB Impl] delete cluster configure failure ", e);
            return false;
        }
        return true;
    }
}

