/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.common.utils;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.inlong.tubemq.server.Stoppable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sleeper {
    private static final long MINIMAL_DELTA_FOR_LOGGING = 10000L;
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final int period;
    private final Stoppable stopper;
    private final Object sleepLock = new Object();
    private final AtomicBoolean triggerWake = new AtomicBoolean(false);

    public Sleeper(int sleep, Stoppable stopper) {
        this.period = sleep;
        this.stopper = stopper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skipSleepCycle() {
        if (this.triggerWake.compareAndSet(false, true)) {
            Object object = this.sleepLock;
            synchronized (object) {
                this.sleepLock.notifyAll();
            }
        }
    }

    public void sleep() {
        this.sleep(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sleep(long startTime) {
        if (this.stopper.isStopped()) {
            return;
        }
        long now = System.currentTimeMillis();
        long waitTime = (long)this.period - (now - startTime);
        if (waitTime > (long)this.period) {
            this.logger.warn("Calculated wait time > " + this.period + "; setting to this.period: " + System.currentTimeMillis() + ", " + startTime);
            waitTime = this.period;
        }
        while (waitTime > 0L) {
            long woke;
            block9: {
                woke = -1L;
                try {
                    if (this.triggerWake.get()) break;
                    Object object = this.sleepLock;
                    synchronized (object) {
                        this.sleepLock.wait(waitTime);
                    }
                    woke = System.currentTimeMillis();
                    long slept = woke - now;
                    if (slept - (long)this.period > 10000L) {
                        this.logger.warn("We slept " + slept + "ms instead of " + this.period + "ms, this is likely due to a long garbage collecting pause and it's usually bad!");
                    }
                }
                catch (InterruptedException iex) {
                    if (!this.stopper.isStopped()) break block9;
                    return;
                }
            }
            woke = woke == -1L ? System.currentTimeMillis() : woke;
            waitTime = (long)this.period - (woke - startTime);
        }
        this.triggerWake.compareAndSet(true, false);
    }
}

