/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.common.utils;

import java.io.File;
import java.io.IOException;

public class FileUtil {
    public static boolean fullyDelete(File dir) throws IOException {
        if (!FileUtil.fullyDeleteContents(dir)) {
            return false;
        }
        return dir.delete();
    }

    public static boolean fullyDeleteContents(File dir) throws IOException {
        boolean deletionSucceeded = true;
        File[] contents = dir.listFiles();
        if (contents != null) {
            for (int i = 0; i < contents.length; ++i) {
                if (contents[i].isFile()) {
                    if (contents[i].delete()) continue;
                    deletionSucceeded = false;
                    continue;
                }
                if (contents[i].delete() || FileUtil.fullyDelete(contents[i])) continue;
                deletionSucceeded = false;
            }
        }
        return deletionSucceeded;
    }

    public static void checkDir(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException(new StringBuilder(512).append("Create directory failed:").append(dir.getAbsolutePath()).toString());
        }
        if (!dir.isDirectory()) {
            throw new RuntimeException(new StringBuilder(512).append("Path is not a directory:").append(dir.getAbsolutePath()).toString());
        }
    }
}

