/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.common.MediaOutputObject;
import com.qcloud.cos.model.ciModel.job.DocJobDetail;
import com.qcloud.cos.model.ciModel.job.DocJobListRequest;
import com.qcloud.cos.model.ciModel.job.DocJobListResponse;
import com.qcloud.cos.model.ciModel.job.DocJobObject;
import com.qcloud.cos.model.ciModel.job.DocJobRequest;
import com.qcloud.cos.model.ciModel.job.DocJobResponse;
import com.qcloud.cos.model.ciModel.job.DocProcessObject;

public class DocJobDemo {
    public static void main(String[] args) {
        COSClient client = ClientUtils.getTestClient();
        DocJobDemo.createDocJobs(client);
    }

    public static void createDocJobs(COSClient client) {
        DocJobRequest request = new DocJobRequest();
        request.setBucketName("examplebucket-1250000000");
        DocJobObject docJobObject = request.getDocJobObject();
        docJobObject.setTag("DocProcess");
        docJobObject.getInput().setObject("demo.docx");
        docJobObject.setQueueId("pc02270c617ae4b6d9b0a52cb1c*****");
        DocProcessObject docProcessObject = docJobObject.getOperation().getDocProcessObject();
        docProcessObject.setQuality("100");
        docProcessObject.setZoom("100");
        docProcessObject.setStartPage("1");
        docProcessObject.setEndPage("3");
        docProcessObject.setTgtType("png");
        docProcessObject.setDocPassword("123");
        MediaOutputObject output = docJobObject.getOperation().getOutput();
        output.setRegion("ap-chongqing");
        output.setBucket("examplebucket-1250000000");
        output.setObject("mark/pic-${Page}.jpg");
        DocJobResponse docProcessJobs = client.createDocProcessJobs(request);
        System.out.println(docProcessJobs);
    }

    public static void describeMediaJob(COSClient client) {
        DocJobRequest request = new DocJobRequest();
        request.setBucketName("examplebucket-1250000000");
        request.setJobId("d75b6ea083df711eb8d09476dfb8*****");
        DocJobResponse docJobResponse = client.describeDocProcessJob(request);
        System.out.println(docJobResponse);
    }

    public static void describeMediaJobs(COSClient client) {
        DocJobListRequest request = new DocJobListRequest();
        request.setBucketName("examplebucket-1250000000");
        request.setQueueId("pc02270c617ae4b6d9b0a52cb1c*****");
        request.setTag("DocProcess");
        request.setStartCreationTime("2020-12-10T16:20:07+0800");
        DocJobListResponse docJobResponse = client.describeDocProcessJobs(request);
        for (DocJobDetail jobDetail : docJobResponse.getDocJobDetailList()) {
            System.out.println(jobDetail);
        }
    }
}

