/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.job.MediaAudioObject;
import com.qcloud.cos.model.ciModel.job.MediaConcatFragmentObject;
import com.qcloud.cos.model.ciModel.job.MediaConcatTemplateObject;
import com.qcloud.cos.model.ciModel.job.MediaContainerObject;
import com.qcloud.cos.model.ciModel.job.MediaJobObject;
import com.qcloud.cos.model.ciModel.job.MediaJobResponse;
import com.qcloud.cos.model.ciModel.job.MediaJobsRequest;
import com.qcloud.cos.model.ciModel.job.MediaListJobResponse;
import com.qcloud.cos.model.ciModel.job.MediaVideoObject;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class ConcatDemo {
    public static void main(String[] args) throws Exception {
        COSClient client = ClientUtils.getTestClient();
        ConcatDemo.createMediaJobs(client);
    }

    public static void createMediaJobs(COSClient client) throws UnsupportedEncodingException {
        MediaJobsRequest request = new MediaJobsRequest();
        request.setBucketName("examplebucket-1250000000");
        request.setTag("Concat");
        request.getInput().setObject("demo.mp4");
        MediaConcatTemplateObject mediaConcatTemplate = request.getOperation().getMediaConcatTemplate();
        List<MediaConcatFragmentObject> concatFragmentList = mediaConcatTemplate.getConcatFragmentList();
        MediaConcatFragmentObject mediaConcatFragmentObject = new MediaConcatFragmentObject();
        mediaConcatFragmentObject.setMode("Start");
        mediaConcatFragmentObject.setUrl("http://examplebucket-1250000000.cos.ap-chongqing.myqcloud.com/demo1.mp4");
        concatFragmentList.add(mediaConcatFragmentObject);
        mediaConcatFragmentObject = new MediaConcatFragmentObject();
        mediaConcatFragmentObject.setMode("End");
        mediaConcatFragmentObject.setUrl("http://examplebucket-1250000000.cos.ap-chongqing.myqcloud.com/demo2.mp4");
        concatFragmentList.add(mediaConcatFragmentObject);
        MediaAudioObject audio = mediaConcatTemplate.getAudio();
        audio.setCodec("mp3");
        MediaVideoObject video = mediaConcatTemplate.getVideo();
        video.setCodec("H.264");
        video.setBitrate("1000");
        video.setWidth("1280");
        video.setFps("30");
        MediaContainerObject container = mediaConcatTemplate.getContainer();
        container.setFormat("mp4");
        mediaConcatTemplate.setIndex("1");
        request.getOperation().getOutput().setBucket("examplebucket-1250000000");
        request.getOperation().getOutput().setRegion("ap-chongqing");
        request.getOperation().getOutput().setObject("concat.mp4");
        request.setQueueId("p9900025e4ec44b5e8225e70a521*****");
        MediaJobResponse response = client.createMediaJobs(request);
        System.out.println(response);
    }

    public static void describeMediaJob(COSClient client) {
        MediaJobsRequest request = new MediaJobsRequest();
        request.setBucketName("examplebucket-1250000000");
        request.setJobId("j6fc9306c8bd411eb8b416b8ff9172c91");
        MediaJobResponse response = client.describeMediaJob(request);
        System.out.println(response);
    }

    public static void describeMediaJobs(COSClient client) {
        MediaJobsRequest request = new MediaJobsRequest();
        request.setBucketName("examplebucket-1250000000");
        request.setQueueId("p9900025e4ec44b5e8225e70a521*****");
        request.setTag("Concat");
        request.setSize(100);
        MediaListJobResponse response = client.describeMediaJobs(request);
        List<MediaJobObject> jobsDetail = response.getJobsDetailList();
        for (MediaJobObject mediaJobObject : jobsDetail) {
            System.out.println(mediaJobObject);
        }
    }

    public static void cancelMediaJob(COSClient client) {
        MediaJobsRequest request = new MediaJobsRequest();
        request.setBucketName("examplebucket-1250000000");
        request.setJobId("jbfb0d02a092111ebb3167781d*****");
        Boolean response = client.cancelMediaJob(request);
        System.out.println(response);
    }
}

