/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.binding;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.ServerApi;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.binding.AbstractReferenceCounted;
import com.mongodb.internal.binding.ClusterAwareReadWriteBinding;
import com.mongodb.internal.binding.ConnectionSource;
import com.mongodb.internal.binding.ReadWriteBinding;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.connection.ReadConcernAwareNoOpSessionContext;
import com.mongodb.internal.connection.Server;
import com.mongodb.internal.connection.ServerTuple;
import com.mongodb.internal.selector.ReadPreferenceServerSelector;
import com.mongodb.internal.selector.ServerAddressSelector;
import com.mongodb.internal.selector.WritableServerSelector;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.lang.Nullable;
import com.mongodb.selector.ServerSelector;

public class ClusterBinding
extends AbstractReferenceCounted
implements ClusterAwareReadWriteBinding {
    private final Cluster cluster;
    private final ReadPreference readPreference;
    private final ReadConcern readConcern;
    @Nullable
    private final ServerApi serverApi;

    public ClusterBinding(Cluster cluster, ReadPreference readPreference, ReadConcern readConcern, @Nullable ServerApi serverApi) {
        this.cluster = Assertions.notNull("cluster", cluster);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
        this.readConcern = Assertions.notNull("readConcern", readConcern);
        this.serverApi = serverApi;
    }

    @Override
    public Cluster getCluster() {
        return this.cluster;
    }

    @Override
    public ReadWriteBinding retain() {
        super.retain();
        return this;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public SessionContext getSessionContext() {
        return new ReadConcernAwareNoOpSessionContext(this.readConcern);
    }

    @Override
    @Nullable
    public ServerApi getServerApi() {
        return this.serverApi;
    }

    @Override
    public ConnectionSource getReadConnectionSource() {
        return new ClusterBindingConnectionSource(new ReadPreferenceServerSelector(this.readPreference));
    }

    @Override
    public ConnectionSource getWriteConnectionSource() {
        return new ClusterBindingConnectionSource(new WritableServerSelector());
    }

    @Override
    public ConnectionSource getConnectionSource(ServerAddress serverAddress) {
        return new ClusterBindingConnectionSource(new ServerAddressSelector(serverAddress));
    }

    private final class ClusterBindingConnectionSource
    extends AbstractReferenceCounted
    implements ConnectionSource {
        private final Server server;
        private final ServerDescription serverDescription;

        private ClusterBindingConnectionSource(ServerSelector serverSelector) {
            ServerTuple serverTuple = ClusterBinding.this.cluster.selectServer(serverSelector);
            this.server = serverTuple.getServer();
            this.serverDescription = serverTuple.getServerDescription();
            ClusterBinding.this.retain();
        }

        @Override
        public ServerDescription getServerDescription() {
            return this.serverDescription;
        }

        @Override
        public SessionContext getSessionContext() {
            return new ReadConcernAwareNoOpSessionContext(ClusterBinding.this.readConcern);
        }

        @Override
        public ServerApi getServerApi() {
            return ClusterBinding.this.serverApi;
        }

        @Override
        public Connection getConnection() {
            return this.server.getConnection();
        }

        @Override
        public ConnectionSource retain() {
            super.retain();
            ClusterBinding.this.retain();
            return this;
        }

        @Override
        public void release() {
            super.release();
            ClusterBinding.this.release();
        }
    }
}

