/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.functions.adaptors;

import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.cep.PatternSelectFunction;
import org.apache.flink.cep.PatternTimeoutFunction;
import org.apache.flink.cep.functions.PatternProcessFunction;
import org.apache.flink.cep.functions.TimedOutPartialMatchHandler;
import org.apache.flink.cep.functions.adaptors.PatternSelectAdapter;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;

@Internal
public class PatternTimeoutSelectAdapter<IN, OUT, T>
extends PatternSelectAdapter<IN, OUT>
implements TimedOutPartialMatchHandler<IN> {
    private final PatternTimeoutFunction<IN, T> timeoutFunction;
    private final OutputTag<T> timedOutPartialMatchesTag;

    public PatternTimeoutSelectAdapter(PatternSelectFunction<IN, OUT> selectFunction, PatternTimeoutFunction<IN, T> timeoutFunction, OutputTag<T> timedOutPartialMatchesTag) {
        super(selectFunction);
        this.timeoutFunction = (PatternTimeoutFunction)Preconditions.checkNotNull(timeoutFunction);
        this.timedOutPartialMatchesTag = (OutputTag)Preconditions.checkNotNull(timedOutPartialMatchesTag);
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        FunctionUtils.setFunctionRuntimeContext(this.timeoutFunction, (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.openFunction(this.timeoutFunction, (Configuration)parameters);
    }

    @Override
    public void close() throws Exception {
        super.close();
        FunctionUtils.closeFunction(this.timeoutFunction);
    }

    @Override
    public void processTimedOutMatch(Map<String, List<IN>> match, PatternProcessFunction.Context ctx) throws Exception {
        T timedOutPatternResult = this.timeoutFunction.timeout(match, ctx.timestamp());
        ctx.output(this.timedOutPartialMatchesTag, timedOutPatternResult);
    }
}

