/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.inner.client;

import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.service.NoAuthApi;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.user.UserRequest;

public class NoAuthClient {
    private final NoAuthApi noAuthApi;

    public NoAuthClient(ClientConfiguration configuration) {
        this.noAuthApi = (NoAuthApi)ClientUtils.createRetrofit(configuration).create(NoAuthApi.class);
    }

    public Integer register(UserRequest request) {
        Preconditions.expectNotBlank((String)request.getName(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"username cannot be empty");
        Preconditions.expectNotBlank((String)request.getPassword(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"password cannot be empty");
        Preconditions.expectNotNull((Object)request.getAccountType(), (String)"accountType cannot be null");
        Preconditions.expectNotNull((Object)request.getValidDays(), (String)"validDays cannot be null");
        Response<Integer> response = ClientUtils.executeHttpCall(this.noAuthApi.register(request));
        ClientUtils.assertRespSuccess(response);
        return (Integer)response.getData();
    }
}

