/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.mapping.Associations;
import org.springframework.data.rest.webmvc.support.ExcerptProjector;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.server.core.EmbeddedWrapper;
import org.springframework.hateoas.server.core.EmbeddedWrappers;
import org.springframework.util.Assert;

public class EmbeddedResourcesAssembler {
    private final PersistentEntities entities;
    private final Associations associations;
    private final ExcerptProjector projector;
    private final EmbeddedWrappers wrappers = new EmbeddedWrappers(false);

    public EmbeddedResourcesAssembler(PersistentEntities entities, Associations associations, ExcerptProjector projector) {
        Assert.notNull((Object)entities, (String)"PersistentEntities must not be null!");
        Assert.notNull((Object)associations, (String)"Associations must not be null!");
        Assert.notNull((Object)projector, (String)"ExcerptProjector must not be null!");
        this.entities = entities;
        this.associations = associations;
        this.projector = projector;
    }

    public Iterable<EmbeddedWrapper> getEmbeddedResources(Object instance) {
        Assert.notNull((Object)instance, (String)"Entity instance must not be null!");
        PersistentEntity entity = this.entities.getRequiredPersistentEntity(instance.getClass());
        ArrayList<EmbeddedWrapper> associationProjections = new ArrayList<EmbeddedWrapper>();
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(instance);
        ResourceMetadata metadata = this.associations.getMetadataFor(entity.getType());
        entity.doWithAssociations(association -> {
            PersistentProperty property = association.getInverse();
            if (!this.associations.isLinkableAssociation(property)) {
                return;
            }
            if (!this.projector.hasExcerptProjection(property.getActualType())) {
                return;
            }
            Object value = accessor.getProperty(association.getInverse());
            if (value == null) {
                return;
            }
            LinkRelation rel = metadata.getMappingFor(property).getRel();
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                if (collection.isEmpty()) {
                    return;
                }
                ArrayList<Object> nestedCollection = new ArrayList<Object>();
                for (Object element : collection) {
                    if (element == null) continue;
                    nestedCollection.add(this.projector.projectExcerpt(element));
                }
                associationProjections.add(this.wrappers.wrap(nestedCollection, rel));
            } else {
                associationProjections.add(this.wrappers.wrap(this.projector.projectExcerpt(value), rel));
            }
        });
        return associationProjections;
    }
}

