/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.temporal;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

public abstract class TimestampExtractFunction
implements ValueParser {
    private TimestampExtractFunctionType type;
    private ValueParser timestampParser;

    public TimestampExtractFunction(TimestampExtractFunctionType type, Function expr) {
        this.type = type;
        List expressions = expr.getParameters().getExpressions();
        this.timestampParser = OperatorTools.buildParser((Expression)expressions.get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object timestampObj = this.timestampParser.parse(sourceData, rowIndex, context);
        Timestamp timestamp = OperatorTools.parseTimestamp(timestampObj);
        LocalDateTime localDateTime = timestamp.toLocalDateTime();
        switch (this.type) {
            case HOUR: {
                return localDateTime.getHour();
            }
            case MINUTE: {
                return localDateTime.getMinute();
            }
            case SECOND: {
                return localDateTime.getSecond();
            }
        }
        return null;
    }

    @TransformFunction(type="temporal", names={"second"}, parameter="(String timestamp)", descriptions={"- Return \"\" if 'timestamp' is null;", "- Return the second of a minute (an integer between 0 and 59) from SQL 'timestamp'."}, examples={"second(2024-08-12 12:23:34) = 34"})
    public static class SecondExtractFunction
    extends TimestampExtractFunction {
        public SecondExtractFunction(Function expr) {
            super(TimestampExtractFunctionType.SECOND, expr);
        }
    }

    @TransformFunction(type="temporal", names={"minute"}, parameter="(String timestamp)", descriptions={"- Return \"\" if 'timestamp' is null;", "- Return the minute of an hour (an integer between 0 and 59) from SQL 'timestamp'."}, examples={"minute(2024-08-12 12:23:34) = 23"})
    public static class MinuteExtractFunction
    extends TimestampExtractFunction {
        public MinuteExtractFunction(Function expr) {
            super(TimestampExtractFunctionType.MINUTE, expr);
        }
    }

    @TransformFunction(type="temporal", names={"hour"}, parameter="(String timestamp)", descriptions={"- Return \"\" if 'timestamp' is null;", "- Return the hour of a day (an integer between 0 and 23) from SQL 'timestamp'."}, examples={"hour(2024-08-12 12:23:34) = 12"})
    public static class HourExtractFunction
    extends TimestampExtractFunction {
        public HourExtractFunction(Function expr) {
            super(TimestampExtractFunctionType.HOUR, expr);
        }
    }

    public static enum TimestampExtractFunctionType {
        HOUR,
        MINUTE,
        SECOND;

    }
}

