/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.NullValue;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransformFunction(type="string", names={"concat_ws"}, parameter="(String string1 [, String string2, ...])", descriptions={"- Return NULL If 'STRING1' is NULL;", "- Return a string that concatenates ('STRING2', 'STRING3', ...) with a separator STRING1."}, examples={"concat_ws('-', 'apple', 'banana', 'cloud') = \"apple-banana-cloud\"", "concat_ws('-', 'apple', '', 'cloud') = \"apple--cloud\"", "concat_ws('-', 'apple', null, 'cloud') = \"apple-cloud\""})
public class ConcatWsFunction
implements ValueParser {
    private static final Logger log = LoggerFactory.getLogger(ConcatWsFunction.class);
    private final String separator;
    private final List<ValueParser> nodeList;

    public ConcatWsFunction(Function expr) {
        List params = expr.getParameters().getExpressions();
        if (params == null || params.isEmpty()) {
            this.separator = null;
            this.nodeList = new ArrayList<ValueParser>();
            return;
        }
        Expression separatorExpr = (Expression)params.get(0);
        this.separator = separatorExpr instanceof NullValue ? null : OperatorTools.parseString(OperatorTools.buildParser(separatorExpr).parse(null, 0, null));
        this.nodeList = new ArrayList<ValueParser>(params.size() - 1);
        for (int i = 1; i < params.size(); ++i) {
            Expression paramExpr = (Expression)params.get(i);
            if (paramExpr instanceof NullValue) {
                this.nodeList.add(null);
                continue;
            }
            this.nodeList.add(OperatorTools.buildParser(paramExpr));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        if (this.separator == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        boolean firstStrFlag = true;
        for (ValueParser node : this.nodeList) {
            Object parsedValue;
            if (node == null || (parsedValue = node.parse(sourceData, rowIndex, context)) == null) continue;
            if (!firstStrFlag) {
                result.append(this.separator);
            }
            result.append(parsedValue);
            firstStrFlag = false;
        }
        return result.toString();
    }
}

