/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.encryption;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="encryption", names={"from_base64"}, parameter="(String base64Str)", descriptions={"- Return \"\" if 'base64Str' is NULL;", "- Return the base64-decoded result from 'base64Str'."}, examples={"from_base64('QXBhY2hlIEluTG9uZw==') = \"Apache InLong\""})
public class FromBase64Function
implements ValueParser {
    private final ValueParser stringParser;

    public FromBase64Function(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.stringParser = OperatorTools.buildParser((Expression)expressions.get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object stringObj = this.stringParser.parse(sourceData, rowIndex, context);
        if (stringObj == null) {
            return null;
        }
        String encodedString = OperatorTools.parseString(stringObj);
        if (encodedString == null) {
            return null;
        }
        try {
            byte[] decodedBytes = Base64.getDecoder().decode(encodedString);
            return new String(decodedBytes, StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Invalid Base64 input: " + encodedString, e);
        }
    }
}

