/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.encryption;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="encryption", names={"encode"}, parameter="(String strInfo,String charsetStr)", descriptions={"- Return \"\" if any parameter is NULL;", "- Return the result of encoding 'strInfo' using the character set specified by 'charsetStr'.", "- Note: 'charsetStr' is one of ('US-ASCII', 'ISO-8859-1', 'UTF-8', 'UTF-16BE', 'UTF-16LE', 'UTF-16')."}, examples={"decode(encode('Hello','UTF-8'),'UTF-8') = \"Hello\""})
public class EncodeFunction
implements ValueParser {
    private ValueParser stringParser;
    private ValueParser characterSetParser;
    private static final Set<String> SUPPORTED_CHARSETS;

    public EncodeFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        if (expressions != null && expressions.size() == 2) {
            this.stringParser = OperatorTools.buildParser((Expression)expressions.get(0));
            this.characterSetParser = OperatorTools.buildParser((Expression)expressions.get(1));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object stringObj = this.stringParser.parse(sourceData, rowIndex, context);
        Object characterObj = this.characterSetParser.parse(sourceData, rowIndex, context);
        if (stringObj == null || characterObj == null) {
            return null;
        }
        String stringValue = OperatorTools.parseString(stringObj);
        String characterSetValue = OperatorTools.parseString(characterObj).toUpperCase();
        return this.encode(stringValue, characterSetValue);
    }

    private byte[] encode(String stringValue, String characterSetValue) {
        if (stringValue == null || stringValue.isEmpty() || characterSetValue == null || characterSetValue.isEmpty()) {
            return new byte[0];
        }
        if (Charset.isSupported(characterSetValue) && SUPPORTED_CHARSETS.contains(characterSetValue)) {
            Charset charset = Charset.forName(characterSetValue);
            return stringValue.getBytes(charset);
        }
        return null;
    }

    static {
        HashSet<String> charsets = new HashSet<String>();
        charsets.add(StandardCharsets.US_ASCII.name());
        charsets.add(StandardCharsets.ISO_8859_1.name());
        charsets.add(StandardCharsets.UTF_8.name());
        charsets.add(StandardCharsets.UTF_16.name());
        charsets.add(StandardCharsets.UTF_16BE.name());
        charsets.add(StandardCharsets.UTF_16LE.name());
        SUPPORTED_CHARSETS = Collections.unmodifiableSet(charsets);
    }
}

