/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.condition;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="condition", names={"coalesce"}, parameter="(String value1 [, String value2, ...])", descriptions={"- Return \"\" If all arguments are NULL or \"\";", "- Return the first argument that is not NULL or \"\".", "Note: The return type is the least restrictive, common type of all of its arguments. The return type is nullable if all arguments are nullable as well."}, examples={"coalesce('', 'SQL', 'hh') = \"SQL\""})
public class CoalesceFunction
implements ValueParser {
    private List<ValueParser> parserList;

    public CoalesceFunction(Function expr) {
        if (expr.getParameters() == null) {
            this.parserList = new ArrayList<ValueParser>();
        } else {
            List params = expr.getParameters().getExpressions();
            this.parserList = new ArrayList<ValueParser>(params.size());
            for (Expression param : params) {
                ValueParser node = OperatorTools.buildParser(param);
                this.parserList.add(node);
            }
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        for (ValueParser node : this.parserList) {
            Object parseObj = node.parse(sourceData, rowIndex, context);
            Object valueObj = this.parseValue(parseObj);
            if (valueObj == null) continue;
            return this.parseValue(parseObj);
        }
        return null;
    }

    private Object parseValue(Object value) {
        Object parsedValue = value instanceof BigDecimal ? OperatorTools.parseBigDecimal(value) : (value instanceof Timestamp ? OperatorTools.parseTimestamp(value) : (value instanceof Date ? OperatorTools.parseDate(value) : (value instanceof byte[] ? (Object)OperatorTools.parseBytes(value) : OperatorTools.parseString(value))));
        if (parsedValue instanceof String && ((String)parsedValue).isEmpty()) {
            return null;
        }
        return parsedValue;
    }
}

