/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.collection;

import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="collection", names={"find_in_set"}, parameter="(String str,String strList)", descriptions={"- Return \"\" if either argument is NULL;", "- Return 0 if 'str' is not in 'strList' or if 'strList' is the empty string;", "- Return a value in the range of 1 to N if the string 'str' is in the string list 'strList' consisting of N substrings.", "Note: strList is a string composed of substrings separated by ',' characters. This function does not work properly if the first argument contains a comma (,) character."}, examples={"FIND_IN_SET('b','a,b,b,c,d') = 2", "FIND_IN_SET('','a,,b,c,d') = 2"})
public class FindInSetFunction
implements ValueParser {
    private final ValueParser strParser;
    private final ValueParser strListParser;

    public FindInSetFunction(Function expr) {
        this.strParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
        this.strListParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(1));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object strObj = this.strParser.parse(sourceData, rowIndex, context);
        Object strListObj = this.strListParser.parse(sourceData, rowIndex, context);
        if (strObj == null || strListObj == null) {
            return null;
        }
        String str = OperatorTools.parseString(strObj);
        String strList = OperatorTools.parseString(strListObj);
        if (!strList.isEmpty()) {
            String[] strArray = strList.split(",");
            for (int i = 0; i < strArray.length; ++i) {
                if (!str.equals(strArray[i])) continue;
                return i + 1;
            }
        }
        return 0;
    }
}

