/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.collection;

import java.util.ArrayList;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="collection", names={"array_contains"}, parameter="(Array array, Object needle)", descriptions={"- Return \"\" if 'array' is NULL;", "- Return whether the given element exists in 'array'.", "Note: Checking for null elements in the array is supported."}, examples={"array_contains(array('he',7,'xxd'), 'cloud') = false", "array_contains(array('he',-1,''),'') = true"})
public class ArrayContainsFunction
implements ValueParser {
    private final ValueParser arrayParser;
    private final ValueParser elementParser;

    public ArrayContainsFunction(Function expr) {
        this.arrayParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
        this.elementParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(1));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object arrayObj = this.arrayParser.parse(sourceData, rowIndex, context);
        Object elementObj = this.elementParser.parse(sourceData, rowIndex, context);
        if (arrayObj == null) {
            return null;
        }
        if (arrayObj instanceof ArrayList) {
            ArrayList array = (ArrayList)arrayObj;
            if (array.isEmpty()) {
                return null;
            }
            for (Object element : array) {
                if (element == null && elementObj == null) {
                    return true;
                }
                if (element == null || !element.equals(elementObj)) continue;
                return true;
            }
        }
        return false;
    }
}

