/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.arithmetic;

import java.math.BigDecimal;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransformFunction(type="arithmetic", names={"factorial"}, parameter="(Numeric numeric)", descriptions={"- Return \"\" if 'numeric' is NULL;", "- Return the factorial of a non-negative."}, examples={"factorial(5) = 120", "factorial(0) = 1"})
public class FactorialFunction
implements ValueParser {
    private static final Logger log = LoggerFactory.getLogger(FactorialFunction.class);
    private ValueParser numberParser;

    public FactorialFunction(Function expr) {
        List expressions;
        if (expr.getParameters() != null && (expressions = expr.getParameters().getExpressions()) != null && expressions.size() == 1) {
            this.numberParser = OperatorTools.buildParser((Expression)expressions.get(0));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        if (this.numberParser != null) {
            Object valueObj = this.numberParser.parse(sourceData, rowIndex, context);
            if (valueObj == null) {
                return null;
            }
            BigDecimal value = OperatorTools.parseBigDecimal(valueObj);
            if (value.scale() > 0 || value.compareTo(BigDecimal.ZERO) < 0) {
                log.warn("Factorial is only defined for non-negative integers. Invalid input: {}", (Object)value);
                return null;
            }
            return this.factorial(value.intValue());
        }
        return null;
    }

    private BigDecimal factorial(int n) {
        if (n < 0) {
            log.error("Factorial is not defined for negative numbers.");
            return null;
        }
        BigDecimal result = BigDecimal.ONE;
        for (int i = 2; i <= n; ++i) {
            result = result.multiply(BigDecimal.valueOf(i));
        }
        return result;
    }
}

