/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corerpc;

import java.util.concurrent.atomic.AtomicLong;

public class RemoteConErrStats {
    private long statisticDuration = 60000L;
    private int maxConnAllowedFailCount = 5;
    private final AtomicLong errCounter = new AtomicLong(0L);
    private final AtomicLong lastTimeStamp = new AtomicLong(0L);

    public RemoteConErrStats(long statisticDuration, int maxConnAllowedFailCount) {
        this.errCounter.set(0L);
        this.lastTimeStamp.set(System.currentTimeMillis());
        this.statisticDuration = statisticDuration;
        this.maxConnAllowedFailCount = maxConnAllowedFailCount;
    }

    public void resetErrCount() {
        this.errCounter.set(0L);
        this.lastTimeStamp.set(System.currentTimeMillis());
    }

    public boolean increErrCount() {
        long curLastTimeStamp = this.lastTimeStamp.get();
        if (System.currentTimeMillis() - curLastTimeStamp > this.statisticDuration && this.lastTimeStamp.compareAndSet(curLastTimeStamp, System.currentTimeMillis())) {
            this.errCounter.set(0L);
        }
        boolean isForbidden = false;
        if (this.errCounter.incrementAndGet() > (long)this.maxConnAllowedFailCount) {
            isForbidden = true;
        }
        return isForbidden;
    }

    public boolean isExpiredRecord(long currentTIme) {
        return currentTIme - this.lastTimeStamp.get() > this.statisticDuration * 10L;
    }
}

