/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corerpc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.apache.inlong.tubemq.corerpc.ResponseWrapper;
import org.apache.inlong.tubemq.corerpc.RpcConfig;
import org.apache.inlong.tubemq.corerpc.client.Callback;
import org.apache.inlong.tubemq.corerpc.client.ClientFactory;
import org.apache.inlong.tubemq.corerpc.utils.MixUtils;

public abstract class AbstractServiceInvoker
implements InvocationHandler {
    protected ClientFactory clientFactory;
    protected Class serviceClass;
    protected RpcConfig conf;
    protected int requestTimeout;

    protected AbstractServiceInvoker(ClientFactory clientFactory, Class serviceClass, RpcConfig conf) {
        this.clientFactory = clientFactory;
        this.serviceClass = serviceClass;
        this.conf = conf;
        this.requestTimeout = conf.getInt("rpc.request.timeout", 10000);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (args == null || args.length == 0) {
            throw new RuntimeException("Call method without args!");
        }
        String finalInterfaceName = method.getDeclaringClass().getName();
        String finalMethodName = method.getName();
        Object finalArg = args[0];
        RpcResponseCallback callback = null;
        if (args[args.length - 1] instanceof Callback) {
            finalInterfaceName = ((Class)method.getDeclaringClass().getGenericInterfaces()[0]).getName();
            callback = new RpcResponseCallback((Callback)args[args.length - 1]);
        }
        return this.callMethod(finalInterfaceName, finalMethodName, finalArg, callback);
    }

    public abstract Object callMethod(String var1, String var2, Object var3, Callback var4) throws Throwable;

    public void destroy() {
    }

    private static class RpcResponseCallback
    implements Callback {
        private Callback chainedCallback;

        public RpcResponseCallback(Callback chainedCallback) {
            this.chainedCallback = chainedCallback;
        }

        public void handleResult(Object result) {
            if (result instanceof ResponseWrapper) {
                ResponseWrapper wrapper = (ResponseWrapper)result;
                if (wrapper.isSuccess()) {
                    this.chainedCallback.handleResult(wrapper.getResponseData());
                } else {
                    String errMsg = new StringBuilder(512).append(wrapper.getErrMsg() == null ? "" : wrapper.getErrMsg()).append("#").append(wrapper.getStackTrace()).toString();
                    this.handleError(MixUtils.unwrapException(errMsg));
                }
            }
        }

        @Override
        public void handleError(Throwable error) {
            this.chainedCallback.handleError(error);
        }
    }
}

