/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corebase.daemon;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.inlong.tubemq.corebase.daemon.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDaemonService
implements Service,
Runnable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDaemonService.class);
    private final String name;
    private final long intervalMs;
    private final Thread daemon;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);

    public AbstractDaemonService(String serviceName, long intervalMs) {
        this.name = serviceName;
        this.intervalMs = intervalMs;
        this.daemon = new Thread((Runnable)this, serviceName + "-daemon-thread");
        this.daemon.setDaemon(true);
    }

    @Override
    public void run() {
        StringBuilder strBuff = new StringBuilder(512);
        logger.info(strBuff.append(this.name).append("-daemon-thread started").toString());
        strBuff.delete(0, strBuff.length());
        while (!this.isStopped()) {
            try {
                Thread.sleep(this.intervalMs);
                this.loopProcess(strBuff);
            }
            catch (InterruptedException e) {
                strBuff.delete(0, strBuff.length());
                logger.warn(strBuff.append(this.name).append("-daemon-thread thread has been interrupted").toString());
                strBuff.delete(0, strBuff.length());
                return;
            }
            catch (Throwable t) {
                strBuff.delete(0, strBuff.length());
                logger.error(strBuff.append(this.name).append("-daemon-thread throw a exception").toString(), t);
                strBuff.delete(0, strBuff.length());
            }
        }
        logger.info(strBuff.append(this.name).append("-daemon-thread stopped").toString());
        strBuff.delete(0, strBuff.length());
    }

    protected abstract void loopProcess(StringBuilder var1);

    @Override
    public void start() {
        this.daemon.start();
    }

    @Override
    public boolean isStopped() {
        return this.shutdown.get();
    }

    @Override
    public boolean stop() {
        if (this.shutdown.get()) {
            return true;
        }
        if (this.shutdown.compareAndSet(false, true)) {
            logger.info(new StringBuilder(256).append(this.name).append("-daemon-thread closing ......").toString());
            try {
                if (this.daemon != null) {
                    this.daemon.interrupt();
                    this.daemon.join();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            logger.info(new StringBuilder(256).append(this.name).append("-daemon-thread stopped!").toString());
            return false;
        }
        return true;
    }
}

