/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.util.Collection;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;

public class ExpressionListDeParser
extends AbstractDeParser<Collection<Expression>> {
    private final ExpressionVisitor expressionVisitor;
    private final boolean useBrackets;
    private final boolean useComma;

    public ExpressionListDeParser(ExpressionVisitor expressionVisitor, StringBuilder builder, boolean useBrackets, boolean useComma) {
        super(builder);
        this.expressionVisitor = expressionVisitor;
        this.useBrackets = useBrackets;
        this.useComma = useComma;
    }

    @Override
    public void deParse(Collection<Expression> expressions) {
        if (expressions != null) {
            String comma;
            String string = comma = this.useComma ? ", " : " ";
            if (this.useBrackets) {
                this.buffer.append("(");
            }
            int i = 0;
            int size = expressions.size() - 1;
            for (Expression expression : expressions) {
                expression.accept(this.expressionVisitor);
                if (i < size) {
                    this.buffer.append(comma);
                }
                ++i;
            }
            if (this.useBrackets) {
                this.buffer.append(")");
            }
        }
    }
}

