/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class AuthorityInfoAccess
implements ASN1Object,
Externalizable {
    private LinkedHashMap<ASN1ObjectID, ArrayList<GeneralName>> access = new LinkedHashMap();
    private ASN1Sequence contents = null;

    public AuthorityInfoAccess() {
    }

    public AuthorityInfoAccess(InputStream is) throws IOException {
        this.input(is);
    }

    public void addAccessDescription(ASN1ObjectID method, GeneralName location) {
        ArrayList<GeneralName> v = this.access.get(method);
        if (v == null) {
            v = new ArrayList();
        }
        v.add(location);
        this.access.put(method, v);
        this.reset();
    }

    @Deprecated
    public Enumeration<ASN1ObjectID> accessMethods() {
        return this.access == null ? null : new Vector<ASN1ObjectID>(this.access.keySet()).elements();
    }

    public Vector<GeneralName> getAccessDescriptions(ASN1ObjectID method) {
        ArrayList<GeneralName> v = this.access.get(method);
        if (v != null && v.size() > 0) {
            return new VectorOverArrayList(v);
        }
        return null;
    }

    public ArrayList<GeneralName> getAccessDescriptionsAsList(ASN1ObjectID method) {
        ArrayList<GeneralName> v = this.access.get(method);
        if (v != null && v.size() > 0) {
            return v;
        }
        return null;
    }

    public boolean hasAccessMethod(ASN1ObjectID method) {
        return this.getAccessDescriptionsAsList(method) != null;
    }

    public int methodCount() {
        return this.access.size();
    }

    public String toString() {
        String s = "AuthorityAccessInfo {";
        for (ASN1ObjectID m : this.access.keySet()) {
            ArrayList<GeneralName> v = this.access.get(m);
            if (v == null) continue;
            for (GeneralName loc : v) {
                s = s + " {" + m.toStringCompact() + "," + loc + "}";
            }
        }
        s = s + " }";
        return s;
    }

    public void input(InputStream is) throws IOException {
        this.reset();
        this.access = new LinkedHashMap();
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(is);
        while (sis.hasMoreData()) {
            ASN1SequenceInputStream seq = new ASN1SequenceInputStream((InputStream)sis);
            ASN1ObjectID m = new ASN1ObjectID((InputStream)seq);
            GeneralName loc = new GeneralName((InputStream)seq);
            this.addAccessDescription(m, loc);
            seq.terminate();
        }
        sis.terminate();
        if (this.access.size() == 0) {
            throw new ASN1FormatException("Sequence must contain at least 1 access description");
        }
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1Sequence().output(os);
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            ASN1Sequence seq = new ASN1Sequence();
            for (ASN1ObjectID m : this.access.keySet()) {
                ArrayList<GeneralName> v = this.access.get(m);
                if (v == null) continue;
                for (GeneralName loc : v) {
                    ASN1Sequence dsc = new ASN1Sequence();
                    dsc.addElement((ASN1Object)m);
                    dsc.addElement((ASN1Object)loc);
                    seq.addElement((ASN1Object)dsc);
                }
            }
            this.contents = seq;
        }
        return this.contents;
    }

    private void reset() {
        this.contents = null;
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes((Streamable)this));
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException((Exception)ex);
        }
        this.input((InputStream)new UnsyncByteArrayInputStream(data));
    }
}

