/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.mapping;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.rest.core.Path;
import org.springframework.data.rest.core.annotation.Description;
import org.springframework.data.rest.core.annotation.RepositoryRestResource;
import org.springframework.data.rest.core.annotation.RestResource;
import org.springframework.data.rest.core.mapping.AnnotationBasedResourceDescription;
import org.springframework.data.rest.core.mapping.CollectionResourceMapping;
import org.springframework.data.rest.core.mapping.EvoInflectorTypeBasedCollectionResourceMapping;
import org.springframework.data.rest.core.mapping.RepositoryDetectionStrategy;
import org.springframework.data.rest.core.mapping.ResourceDescription;
import org.springframework.data.rest.core.mapping.SimpleResourceDescription;
import org.springframework.data.rest.core.mapping.TypeBasedCollectionResourceMapping;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.Optionals;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.server.LinkRelationProvider;
import org.springframework.hateoas.server.core.EvoInflectorLinkRelationProvider;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class RepositoryCollectionResourceMapping
implements CollectionResourceMapping {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryCollectionResourceMapping.class);
    private static final boolean EVO_INFLECTOR_IS_PRESENT = ClassUtils.isPresent((String)"org.atteo.evo.inflector.English", null);
    private final boolean repositoryExported;
    private final RepositoryMetadata metadata;
    private final Path path;
    private final Lazy<LinkRelation> rel;
    private final Lazy<LinkRelation> itemResourceRel;
    private final Lazy<ResourceDescription> description;
    private final Lazy<ResourceDescription> itemDescription;
    private final Lazy<Class<?>> excerptProjection;

    public RepositoryCollectionResourceMapping(RepositoryMetadata metadata, RepositoryDetectionStrategy strategy) {
        this(metadata, strategy, (LinkRelationProvider)new EvoInflectorLinkRelationProvider());
    }

    RepositoryCollectionResourceMapping(RepositoryMetadata metadata, RepositoryDetectionStrategy strategy, LinkRelationProvider relProvider) {
        Assert.notNull((Object)metadata, (String)"Repository metadata must not be null!");
        Assert.notNull((Object)relProvider, (String)"LinkRelationProvider must not be null!");
        Assert.notNull((Object)strategy, (String)"RepositoryDetectionStrategy must not be null!");
        Class repositoryType = metadata.getRepositoryInterface();
        Optional<Annotation> annotation = Optional.ofNullable(AnnotationUtils.findAnnotation((Class)repositoryType, RestResource.class));
        Optional<Annotation> repositoryAnnotation = Optional.ofNullable(AnnotationUtils.findAnnotation((Class)repositoryType, RepositoryRestResource.class));
        this.metadata = metadata;
        this.repositoryExported = strategy.isExported(metadata);
        Class domainType = metadata.getDomainType();
        TypeBasedCollectionResourceMapping domainTypeMapping = EVO_INFLECTOR_IS_PRESENT ? new EvoInflectorTypeBasedCollectionResourceMapping(domainType, relProvider) : new TypeBasedCollectionResourceMapping(domainType, relProvider);
        this.rel = Lazy.of(() -> Optionals.firstNonEmpty((Supplier[])new Supplier[]{() -> RepositoryCollectionResourceMapping.toLinkRelation(repositoryAnnotation.map(RepositoryRestResource::collectionResourceRel)), () -> RepositoryCollectionResourceMapping.toLinkRelation(annotation.map(RestResource::rel))}).orElseGet(domainTypeMapping::getRel));
        this.itemResourceRel = Lazy.of(() -> RepositoryCollectionResourceMapping.toLinkRelation(repositoryAnnotation.map(RepositoryRestResource::itemResourceRel)).orElseGet(domainTypeMapping::getItemResourceRel));
        this.path = Optionals.firstNonEmpty((Supplier[])new Supplier[]{() -> repositoryAnnotation.map(RepositoryRestResource::path), () -> annotation.map(RestResource::path)}).filter(StringUtils::hasText).filter(it -> {
            if (it.contains("/")) {
                throw new IllegalStateException(String.format("Path %s configured for %s must only contain a single path segment!", it, metadata.getRepositoryInterface().getName()));
            }
            return true;
        }).map(Path::new).orElseGet(domainTypeMapping::getPath);
        this.description = Lazy.of(() -> {
            ResourceDescription fallback = SimpleResourceDescription.defaultFor(this.getRel());
            return repositoryAnnotation.map(RepositoryRestResource::collectionResourceDescription).map(it -> new AnnotationBasedResourceDescription((Description)it, fallback)).orElse(fallback);
        });
        this.itemDescription = Lazy.of(() -> {
            ResourceDescription fallback = SimpleResourceDescription.defaultFor(this.getItemResourceRel());
            return repositoryAnnotation.map(RepositoryRestResource::itemResourceDescription).map(it -> new AnnotationBasedResourceDescription((Description)it, fallback)).orElse(fallback);
        });
        this.excerptProjection = Lazy.of(() -> repositoryAnnotation.map(RepositoryRestResource::excerptProjection).filter(it -> !it.equals(RepositoryRestResource.None.class)).orElse(null));
        if (annotation.isPresent()) {
            LOGGER.warn("@RestResource detected to customize the repository resource for {}! Use @RepositoryRestResource instead!", (Object)metadata.getRepositoryInterface().getName());
        }
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public LinkRelation getRel() {
        return (LinkRelation)this.rel.get();
    }

    @Override
    public LinkRelation getItemResourceRel() {
        return (LinkRelation)this.itemResourceRel.get();
    }

    @Override
    public boolean isExported() {
        return this.repositoryExported;
    }

    @Override
    public boolean isPagingResource() {
        return this.metadata.isPagingRepository();
    }

    @Override
    public ResourceDescription getDescription() {
        return (ResourceDescription)this.description.get();
    }

    @Override
    public ResourceDescription getItemResourceDescription() {
        return (ResourceDescription)this.itemDescription.get();
    }

    @Override
    public Optional<Class<?>> getExcerptProjection() {
        return this.excerptProjection.getOptional();
    }

    private static Optional<LinkRelation> toLinkRelation(Optional<String> source) {
        return source.filter(StringUtils::hasText).map(LinkRelation::of);
    }
}

