/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class UriToEntityConverter
implements ConditionalGenericConverter {
    private static final TypeDescriptor URI_TYPE = TypeDescriptor.valueOf(URI.class);
    private final PersistentEntities entities;
    private final RepositoryInvokerFactory invokerFactory;
    private final Repositories repositories;
    private final Set<GenericConverter.ConvertiblePair> convertiblePairs;

    public UriToEntityConverter(PersistentEntities entities, RepositoryInvokerFactory invokerFactory, Repositories repositories) {
        Assert.notNull((Object)entities, (String)"PersistentEntities must not be null!");
        Assert.notNull((Object)invokerFactory, (String)"RepositoryInvokerFactory must not be null!");
        Assert.notNull((Object)repositories, (String)"Repositories must not be null!");
        HashSet<GenericConverter.ConvertiblePair> convertiblePairs = new HashSet<GenericConverter.ConvertiblePair>();
        for (TypeInformation domainType : entities.getManagedTypes()) {
            Class rawType = domainType.getType();
            Optional entity = entities.getPersistentEntity(rawType);
            if (!entity.map(it -> it.hasIdProperty()).orElse(false).booleanValue()) continue;
            convertiblePairs.add(new GenericConverter.ConvertiblePair(URI.class, domainType.getType()));
        }
        this.convertiblePairs = Collections.unmodifiableSet(convertiblePairs);
        this.entities = entities;
        this.invokerFactory = invokerFactory;
        this.repositories = repositories;
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return !sourceType.equals((Object)URI_TYPE) ? false : this.repositories.getRepositoryInformationFor(targetType.getType()).isPresent();
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return this.convertiblePairs;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        Optional entity = this.entities.getPersistentEntity(targetType.getType());
        if (!entity.isPresent()) {
            throw new ConversionFailedException(sourceType, targetType, source, (Throwable)new IllegalArgumentException("No PersistentEntity information available for " + targetType.getType()));
        }
        URI uri = (URI)source;
        String[] parts = uri.getPath().split("/");
        if (parts.length < 2) {
            throw new ConversionFailedException(sourceType, targetType, source, (Throwable)new IllegalArgumentException("Cannot resolve URI " + uri + ". Is it local or remote? Only local URIs are resolvable."));
        }
        return this.invokerFactory.getInvokerFor(targetType.getType()).invokeFindById((Object)parts[parts.length - 1]).orElse(null);
    }
}

