/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptUtil {
    public static final String AES = "AES";
    public static final int AES_KEY_SIZE = 128;
    public static final int MAX_ENCRYPT_BLOCK = 117;
    public static final int MAX_DECRYPT_BLOCK = 128;
    private static final Logger logger = LoggerFactory.getLogger(EncryptUtil.class);

    public static String loadPublicKeyByFileText(String path) throws Exception {
        try {
            BufferedReader br = new BufferedReader(new FileReader(path));
            String readLine = null;
            StringBuilder sb = new StringBuilder();
            while ((readLine = br.readLine()) != null) {
                sb.append(readLine);
            }
            br.close();
            return sb.toString();
        }
        catch (IOException e) {
            throw new Exception("key error");
        }
        catch (NullPointerException e) {
            throw new Exception("npe error");
        }
    }

    public static byte[] loadPublicKeyByFileBinary(String path) throws Exception {
        try {
            File file = new File(path);
            int len = 0;
            if (file.exists()) {
                len = (int)file.length();
            }
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(path)));
            byte[] content = new byte[len];
            while (dis.read(content) != -1) {
            }
            dis.close();
            return content;
        }
        catch (IOException e) {
            throw new Exception("key error");
        }
        catch (NullPointerException e) {
            throw new Exception("npe error");
        }
    }

    public static RSAPublicKey loadPublicKeyByText(String publicKeyStr) {
        try {
            byte[] buffer = Base64.decodeBase64((String)publicKeyStr);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(buffer);
            return (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("no such algorithm", (Throwable)e);
        }
        catch (InvalidKeySpecException e) {
            logger.error("invalid key spec", (Throwable)e);
        }
        catch (NullPointerException e) {
            logger.error("public key is null", (Throwable)e);
        }
        return null;
    }

    public static RSAPublicKey loadPublicKeyByBinary(byte[] publicKeyByte) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKeyByte);
            return (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("no such algorithm", (Throwable)e);
        }
        catch (InvalidKeySpecException e) {
            logger.error("invalid key spec", (Throwable)e);
        }
        catch (NullPointerException e) {
            logger.error("public key is null", (Throwable)e);
        }
        return null;
    }

    public static String loadPrivateKeyByFileText(String path) throws Exception {
        try {
            BufferedReader br = new BufferedReader(new FileReader(path));
            String readLine = null;
            StringBuilder sb = new StringBuilder();
            while ((readLine = br.readLine()) != null) {
                sb.append(readLine);
            }
            br.close();
            return sb.toString();
        }
        catch (IOException e) {
            throw new Exception("key error");
        }
        catch (NullPointerException e) {
            throw new Exception("npe error");
        }
    }

    public static byte[] loadPrivateKeyByFileBinary(String path) throws Exception {
        try {
            File file = new File(path);
            int len = 0;
            if (file.exists()) {
                len = (int)file.length();
            }
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(path)));
            byte[] content = new byte[len];
            while (dis.read(content) != -1) {
            }
            dis.close();
            return content;
        }
        catch (IOException e) {
            throw new Exception("key error");
        }
        catch (NullPointerException e) {
            throw new Exception("npe error");
        }
    }

    public static RSAPrivateKey loadPrivateKeyByText(String privateKeyStr) throws Exception {
        try {
            byte[] buffer = privateKeyStr.getBytes();
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(buffer);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("no such algorithm");
        }
        catch (InvalidKeySpecException e) {
            throw new Exception("key error");
        }
        catch (NullPointerException e) {
            throw new Exception("npe error");
        }
    }

    public static RSAPrivateKey loadPrivateKeyByBinary(byte[] privateKeyByte) throws Exception {
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyByte);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("no such algorithm");
        }
        catch (InvalidKeySpecException e) {
            throw new Exception("key error");
        }
        catch (NullPointerException e) {
            throw new Exception("npe error");
        }
    }

    public static byte[] rsaEncrypt(RSAPublicKey publicKey, byte[] data) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, publicKey);
        int inputLen = data.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(data, offSet, 117) : cipher.doFinal(data, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 117;
        }
        byte[] encryptedData = out.toByteArray();
        out.close();
        return encryptedData;
    }

    public static byte[] decryptByPrivateKey(RSAPrivateKey privateKey, byte[] encryptedData) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, privateKey);
        int inputLen = encryptedData.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(encryptedData, offSet, 128) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 128;
        }
        byte[] decryptedData = out.toByteArray();
        out.close();
        return decryptedData;
    }

    public static byte[] rsaDecrypt(RSAPrivateKey privateKey, byte[] cipherData) throws Exception {
        if (privateKey == null) {
            throw new Exception("private key is null");
        }
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("RSA");
            cipher.init(2, privateKey);
            byte[] output = cipher.doFinal(cipherData);
            return output;
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("no such algorithm");
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvalidKeyException e) {
            throw new Exception("invalid key");
        }
        catch (IllegalBlockSizeException e) {
            throw new Exception("illegal size");
        }
        catch (BadPaddingException e) {
            throw new Exception("bad padding");
        }
    }

    public static byte[] rsaDecrypt(RSAPublicKey publicKey, byte[] cipherData) throws Exception {
        if (publicKey == null) {
            throw new Exception("public key is null");
        }
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("RSA");
            cipher.init(2, publicKey);
            byte[] output = cipher.doFinal(cipherData);
            return output;
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("no such algorithm");
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvalidKeyException e) {
            throw new Exception("invalid key");
        }
        catch (IllegalBlockSizeException e) {
            throw new Exception("illegal block");
        }
        catch (BadPaddingException e) {
            throw new Exception("bad padding");
        }
    }

    public static byte[] generateAesKey() {
        KeyGenerator kg = null;
        try {
            kg = KeyGenerator.getInstance(AES);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("generate Aes key error {}", (Throwable)e);
        }
        kg.init(128);
        SecretKey secretKey = kg.generateKey();
        return secretKey.getEncoded();
    }

    public static byte[] aesEncrypt(byte[] plainText, byte[] aesKey) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(aesKey, AES);
            Cipher cipher = Cipher.getInstance(AES);
            cipher.init(1, secretKeySpec);
            return cipher.doFinal(plainText);
        }
        catch (Exception e) {
            logger.error("aesEncrypt error {}", (Throwable)e);
            return null;
        }
    }

    public static byte[] aesDecrypt(byte[] cipherText, byte[] aesKey) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(aesKey, AES);
            Cipher cipher = Cipher.getInstance(AES);
            cipher.init(2, secretKeySpec);
            return cipher.doFinal(cipherText);
        }
        catch (Exception e) {
            logger.error("aesDecrypt error {}", (Throwable)e);
            return null;
        }
    }
}

